# -*- mode: perl; -*-

use strict;
use warnings;

use Test::More tests => 929;

use Math::BigFloat;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($x_str, $expected) = split /:/;
    my ($x, $str);

    for my $accu ("undef", "20") {
        my $test = qq|Math::BigFloat -> accuracy($accu);|
                 . qq| \$x = Math::BigFloat -> new("$x_str");|
                 . qq| \$str = \$x -> bdstr();|;

        note "\n$test\n\n";
        eval $test;
        die $@ if $@;           # should never happen

        is($str, $expected, qq|output is "$expected"|);
        if ($x_str eq 'NaN') {
            ok($x -> is_nan(), "input object is unmodified");
        } else {
            cmp_ok($x, "==", $x_str, "input object is unmodified");
        }
    }
}

# Reset accuracy and precision.

Math::BigFloat -> accuracy(undef);
Math::BigFloat -> precision(undef);

# 355/113 rounded to 40 digits.

my $str = '3.141592920353982300884955752212389380531';

# Default rounding.

note(qq|\nMath::BigFloat -> new("$str") -> bdstr();\n\n|);
is(Math::BigFloat -> new($str) -> bdstr(),
   '3.141592920353982300884955752212389380531');

# Accuracy as argument.

note(qq|\nMath::BigFloat -> new("$str") -> bdstr(3);\n\n|);
is(Math::BigFloat -> new($str) -> bdstr(3), '3.14');

# Precision as argument.

note(qq|\nMath::BigFloat -> new("$str") -> bdstr(undef, -3);\n\n|);
is(Math::BigFloat -> new($str) -> bdstr(undef, -3), '3.142');

# Accuracy as class variable.

note(qq|\nMath::BigFloat -> accuracy(5); Math::BigFloat -> new("$str") -> bdstr();\n\n|);
Math::BigFloat -> accuracy(5);
is(Math::BigFloat -> new($str) -> bdstr(), '3.1416');

# Precision as class variable.

note(qq|\nMath::BigFloat -> precision(-5); Math::BigFloat -> new("$str") -> bdstr();\n\n|);
Math::BigFloat -> precision(-5);
is(Math::BigFloat -> new($str) -> bdstr(), '3.14159');

__DATA__

NaN:NaN

inf:inf
-inf:-inf

0:0
-0:0

# positive numbers

0.000000000001:0.000000000001
0.00000000001:0.00000000001
0.0000000001:0.0000000001
0.000000001:0.000000001
0.00000001:0.00000001
0.0000001:0.0000001
0.000001:0.000001
0.00001:0.00001
0.0001:0.0001
0.001:0.001
0.01:0.01
0.1:0.1
1:1
10:10
100:100
1000:1000
10000:10000
100000:100000
1000000:1000000
10000000:10000000
100000000:100000000
1000000000:1000000000
10000000000:10000000000
100000000000:100000000000
1000000000000:1000000000000

0.0000000000012:0.0000000000012
0.000000000012:0.000000000012
0.00000000012:0.00000000012
0.0000000012:0.0000000012
0.000000012:0.000000012
0.00000012:0.00000012
0.0000012:0.0000012
0.000012:0.000012
0.00012:0.00012
0.0012:0.0012
0.012:0.012
0.12:0.12
1.2:1.2
12:12
120:120
1200:1200
12000:12000
120000:120000
1200000:1200000
12000000:12000000
120000000:120000000
1200000000:1200000000
12000000000:12000000000
120000000000:120000000000
1200000000000:1200000000000

0.00000000000123:0.00000000000123
0.0000000000123:0.0000000000123
0.000000000123:0.000000000123
0.00000000123:0.00000000123
0.0000000123:0.0000000123
0.000000123:0.000000123
0.00000123:0.00000123
0.0000123:0.0000123
0.000123:0.000123
0.00123:0.00123
0.0123:0.0123
0.123:0.123
1.23:1.23
12.3:12.3
123:123
1230:1230
12300:12300
123000:123000
1230000:1230000
12300000:12300000
123000000:123000000
1230000000:1230000000
12300000000:12300000000
123000000000:123000000000
1230000000000:1230000000000

0.000000000001234:0.000000000001234
0.00000000001234:0.00000000001234
0.0000000001234:0.0000000001234
0.000000001234:0.000000001234
0.00000001234:0.00000001234
0.0000001234:0.0000001234
0.000001234:0.000001234
0.00001234:0.00001234
0.0001234:0.0001234
0.001234:0.001234
0.01234:0.01234
0.1234:0.1234
1.234:1.234
12.34:12.34
123.4:123.4
1234:1234
12340:12340
123400:123400
1234000:1234000
12340000:12340000
123400000:123400000
1234000000:1234000000
12340000000:12340000000
123400000000:123400000000
1234000000000:1234000000000

0.000003141592:0.000003141592
0.00003141592:0.00003141592
0.0003141592:0.0003141592
0.003141592:0.003141592
0.03141592:0.03141592
0.3141592:0.3141592
3.141592:3.141592
31.41592:31.41592
314.1592:314.1592
3141.592:3141.592
31415.92:31415.92
314159.2:314159.2
3141592:3141592

# negative numbers

-0.000000000001:-0.000000000001
-0.00000000001:-0.00000000001
-0.0000000001:-0.0000000001
-0.000000001:-0.000000001
-0.00000001:-0.00000001
-0.0000001:-0.0000001
-0.000001:-0.000001
-0.00001:-0.00001
-0.0001:-0.0001
-0.001:-0.001
-0.01:-0.01
-0.1:-0.1
-1:-1
-10:-10
-100:-100
-1000:-1000
-10000:-10000
-100000:-100000
-1000000:-1000000
-10000000:-10000000
-100000000:-100000000
-1000000000:-1000000000
-10000000000:-10000000000
-100000000000:-100000000000
-1000000000000:-1000000000000

-0.0000000000012:-0.0000000000012
-0.000000000012:-0.000000000012
-0.00000000012:-0.00000000012
-0.0000000012:-0.0000000012
-0.000000012:-0.000000012
-0.00000012:-0.00000012
-0.0000012:-0.0000012
-0.000012:-0.000012
-0.00012:-0.00012
-0.0012:-0.0012
-0.012:-0.012
-0.12:-0.12
-1.2:-1.2
-12:-12
-120:-120
-1200:-1200
-12000:-12000
-120000:-120000
-1200000:-1200000
-12000000:-12000000
-120000000:-120000000
-1200000000:-1200000000
-12000000000:-12000000000
-120000000000:-120000000000
-1200000000000:-1200000000000

-0.00000000000123:-0.00000000000123
-0.0000000000123:-0.0000000000123
-0.000000000123:-0.000000000123
-0.00000000123:-0.00000000123
-0.0000000123:-0.0000000123
-0.000000123:-0.000000123
-0.00000123:-0.00000123
-0.0000123:-0.0000123
-0.000123:-0.000123
-0.00123:-0.00123
-0.0123:-0.0123
-0.123:-0.123
-1.23:-1.23
-12.3:-12.3
-123:-123
-1230:-1230
-12300:-12300
-123000:-123000
-1230000:-1230000
-12300000:-12300000
-123000000:-123000000
-1230000000:-1230000000
-12300000000:-12300000000
-123000000000:-123000000000
-1230000000000:-1230000000000

-0.000000000001234:-0.000000000001234
-0.00000000001234:-0.00000000001234
-0.0000000001234:-0.0000000001234
-0.000000001234:-0.000000001234
-0.00000001234:-0.00000001234
-0.0000001234:-0.0000001234
-0.000001234:-0.000001234
-0.00001234:-0.00001234
-0.0001234:-0.0001234
-0.001234:-0.001234
-0.01234:-0.01234
-0.1234:-0.1234
-1.234:-1.234
-12.34:-12.34
-123.4:-123.4
-1234:-1234
-12340:-12340
-123400:-123400
-1234000:-1234000
-12340000:-12340000
-123400000:-123400000
-1234000000:-1234000000
-12340000000:-12340000000
-123400000000:-123400000000
-1234000000000:-1234000000000

-0.000003141592:-0.000003141592
-0.00003141592:-0.00003141592
-0.0003141592:-0.0003141592
-0.003141592:-0.003141592
-0.03141592:-0.03141592
-0.3141592:-0.3141592
-3.141592:-3.141592
-31.41592:-31.41592
-314.1592:-314.1592
-3141.592:-3141.592
-31415.92:-31415.92
-314159.2:-314159.2
-3141592:-3141592
