/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.cataloggen.config.DatasetSource;

public class DatasetFilter {
    private DatasetSource parentDatasetSource = null;
    private String name = null;
    private Type type = null;
    private String matchPattern = null;
    protected Pattern regExpPattern;
    private String matchPatternTarget = null;
    private boolean applyToCollectionDatasets = false;
    private boolean applyToAtomicDatasets = true;
    private boolean rejectMatchingDatasets = false;
    private boolean isValid = true;
    private StringBuffer log = new StringBuffer();

    public DatasetFilter(DatasetSource parentDsSource, String name, Type type, String matchPattern) {
        if (type == null) {
            this.isValid = false;
            this.log.append(" ** DatasetFilter (1): invalid type for datasetFilter (" + name + ")");
        }
        this.parentDatasetSource = parentDsSource;
        this.name = name;
        this.type = type;
        if (matchPattern == null) {
            this.isValid = false;
            this.log.append(" ** DatasetFilter (2): null matchPattern not allowed.");
        } else {
            this.matchPattern = matchPattern;
            try {
                this.regExpPattern = Pattern.compile(this.matchPattern);
            }
            catch (PatternSyntaxException e) {
                this.isValid = false;
                this.log.append(" ** DatasetFilter (3): invalid matchPattern [" + this.matchPattern + "].");
            }
        }
    }

    public DatasetFilter(DatasetSource parentDsSource, String name, Type type, String matchPattern, boolean applyToCollectionDatasets, boolean applyToAtomicDatasets, boolean rejectMatchingDatasets) {
        this(parentDsSource, name, type, matchPattern);
        this.applyToCollectionDatasets = applyToCollectionDatasets;
        this.applyToAtomicDatasets = applyToAtomicDatasets;
        this.rejectMatchingDatasets = rejectMatchingDatasets;
    }

    public DatasetSource getParentDatasetSource() {
        return this.parentDatasetSource;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public String getMatchPatternTarget() {
        return this.matchPatternTarget;
    }

    public void setMatchPatternTarget(String matchPatternTarget) {
        this.matchPatternTarget = matchPatternTarget;
    }

    public boolean isApplyToCollectionDatasets() {
        return this.applyToCollectionDatasets;
    }

    public void setApplyToCollectionDatasets(boolean applyToCollectionDatasets) {
        this.applyToCollectionDatasets = applyToCollectionDatasets;
    }

    public boolean isApplyToAtomicDatasets() {
        return this.applyToAtomicDatasets;
    }

    public void setApplyToAtomicDatasets(boolean applyToAtomicDatasets) {
        this.applyToAtomicDatasets = applyToAtomicDatasets;
    }

    public boolean isRejectMatchingDatasets() {
        return this.rejectMatchingDatasets;
    }

    public boolean isAcceptMatchingDatasets() {
        return !this.rejectMatchingDatasets;
    }

    public void setRejectMatchingDatasets(boolean rejectMatchingDatasets) {
        this.rejectMatchingDatasets = rejectMatchingDatasets;
    }

    boolean validate(StringBuilder out) {
        this.isValid = true;
        if (this.log.length() > 0) {
            out.append(this.log);
        }
        if (this.getName() == null) {
            this.isValid = false;
            out.append(" ** DatasetFilter (4): null value for name is not valid.");
        }
        if (this.getType() == null) {
            this.isValid = false;
            out.append(" ** DatasetFilter (5): null value for type is not valid (set with bad string?).");
        }
        if (this.type == Type.REGULAR_EXPRESSION && this.matchPattern == null) {
            this.isValid = false;
            out.append(" ** DatasetFilter (6): null value for matchPattern not valid when type is 'RegExp'.");
        }
        if (this.type != Type.REGULAR_EXPRESSION && this.type != null && this.matchPattern != null) {
            this.isValid = false;
            out.append(" ** DatasetFilter (7): matchPattern value (" + this.matchPattern + ") must be null if type is not 'RegExp'.");
        }
        return this.isValid;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("DatasetFilter[name:<" + this.getName() + "> type:<" + (Object)((Object)this.getType()) + "> matchPattern:<" + this.getMatchPattern() + ">");
        return tmp.toString();
    }

    public boolean reject(InvDataset dataset) {
        if (this.isAcceptMatchingDatasets()) {
            throw new IllegalStateException("Accept filter <" + this.getName() + "> does not allow call to reject().");
        }
        return this.match(dataset);
    }

    public boolean accept(InvDataset dataset) {
        if (this.isRejectMatchingDatasets()) {
            throw new IllegalStateException("Reject filter <" + this.getName() + "> does not allow call to accept().");
        }
        return this.match(dataset);
    }

    protected boolean appliesToDataset(InvDataset dataset) {
        if (this.getParentDatasetSource().isCollection(dataset) && !this.applyToCollectionDatasets) {
            return false;
        }
        return this.getParentDatasetSource().isCollection(dataset) || this.applyToAtomicDatasets;
    }

    private boolean match(InvDataset dataset) {
        if (this.getParentDatasetSource().isCollection(dataset) && !this.applyToCollectionDatasets) {
            return false;
        }
        if (!this.getParentDatasetSource().isCollection(dataset) && !this.applyToAtomicDatasets) {
            return false;
        }
        if (this.matchPatternTarget == null) {
            if (this.getParentDatasetSource().isCollection(dataset)) {
                this.setMatchPatternTarget("name");
            } else {
                this.setMatchPatternTarget("urlPath");
            }
        }
        if (this.type == Type.REGULAR_EXPRESSION) {
            boolean isMatch;
            if (this.getMatchPatternTarget().equals("name")) {
                Matcher matcher = this.regExpPattern.matcher(dataset.getName());
                isMatch = matcher.find();
            } else if (this.getMatchPatternTarget().equals("urlPath")) {
                Matcher matcher = this.regExpPattern.matcher(((InvDatasetImpl)dataset).getUrlPath());
                isMatch = matcher.find();
            } else {
                isMatch = false;
            }
            return isMatch;
        }
        System.err.println("WARNING -- DatasetFilter.accept(): unsupported type <" + this.type.toString() + ">.");
        return false;
    }

    public static boolean acceptDatasetByFilterGroup(List filters, InvDataset dataset, boolean isCollectionDataset) {
        if (filters == null) {
            throw new NullPointerException("Given null list of filters.");
        }
        if (dataset == null) {
            throw new NullPointerException("Given null dataset.");
        }
        if (filters.isEmpty()) {
            return true;
        }
        boolean accept = false;
        boolean anyApplyToAtomic = false;
        boolean anyApplyToCollection = false;
        for (DatasetFilter curFilter : filters) {
            anyApplyToAtomic |= curFilter.isApplyToAtomicDatasets();
            anyApplyToCollection |= curFilter.isApplyToCollectionDatasets();
            if (curFilter.isAcceptMatchingDatasets()) {
                if (!curFilter.accept(dataset)) continue;
                accept = true;
                continue;
            }
            if (!curFilter.reject(dataset)) continue;
            return false;
        }
        if (accept) {
            return true;
        }
        return isCollectionDataset ? !anyApplyToCollection : !anyApplyToAtomic;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        REGULAR_EXPRESSION("RegExp");

        private String altId;

        private Type(String altId) {
            this.altId = altId;
        }

        public String toString() {
            return this.altId;
        }

        public static Type getType(String altId) {
            if (altId == null) {
                return null;
            }
            for (Type curType : Type.values()) {
                if (!curType.altId.equals(altId)) continue;
                return curType;
            }
            return null;
        }
    }
}

