#!perl -I../../lib
# Readonly hash tests
use strict;
use Test::More;
use Test::Fatal;
use ReadonlyX;
#
sub expected {
    my $line = shift;
    $@ =~ s/\.$//;    # difference between croak and die
    return "Modification of a read-only value attempted at " . __FILE__
        . " line $line\n";
}
use vars qw/%h1/;
my (%mh1, %mh2);

# creation (3 tests)
eval { Readonly::Hash %h1 => (a => "A", b => "B", c => "C", d => "D") };
is $@ => '', 'Create global hash';

# Scalar
like(exception { Readonly::Hash %mh1 => (one => 1, two => 2, three => 3, 4) },
     qr'Odd number of elements in hash assignment',
     'odd number of elements'
);
eval { Readonly::Hash %mh1 => {one => 1, two => 2, three => 3, four => 4} };
is $@ => '', 'Create lexical hash';

# fetch (3 tests)
is $h1{a} => 'A', 'Fetch global';

like(exception { defined $h1{'q'}},
     qr[Attempt to access disallowed key 'q' in a restricted hash],
     'nonexistent element undefined and cannot be autoinstantiated'
);

is $mh1{two} => 2, 'Fetch lexical';

# store (1 test)
eval { $h1{a} = 'Z' };
is $@ => expected(__LINE__- 1), 'Store';

# delete (1 test)
eval { delete $h1{c} };
like $@,qr[Attempt to delete readonly key 'c' from a restricted hash],  'delete';

# clear (1 test)
eval { %h1 = () };
like $@,qr[Attempt to delete readonly key '.' from a restricted hash],  'clear';

# exists (3 tests)
ok exists $h1{a}, 'Exists';
eval { ok !exists $h1{x}, "Doesn't exist" };
is $@ => '', "Doesn't exist (no error)";

# keys, values (4 tests)
my @a = sort keys %h1;
is $a[0], 'a', 'Keys a';
is $a[1], 'b', 'Keys b';
@a = sort values %h1;
is $a[0], 'A', 'Values A';
is $a[1], 'B', 'Values B';

# each (2 tests)
my ($k, $v);
while (($k, $v) = each %h1) {
    $mh2{$k} = $v;
}
is $mh2{c} => 'C', 'Each C';
is $mh2{d} => 'D', 'Each D';
 #
done_testing;
