# Generated by default/object.tt
package Paws::AutoScalingPlans::PredefinedLoadMetricSpecification;
  use Moose;
  has PredefinedLoadMetricType => (is => 'ro', isa => 'Str', required => 1);
  has ResourceLabel => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AutoScalingPlans::PredefinedLoadMetricSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AutoScalingPlans::PredefinedLoadMetricSpecification object:

  $service_obj->Method(Att1 => { PredefinedLoadMetricType => $value, ..., ResourceLabel => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AutoScalingPlans::PredefinedLoadMetricSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->PredefinedLoadMetricType

=head1 DESCRIPTION

Represents a predefined metric that can be used for predictive scaling.

After creating your scaling plan, you can use the AWS Auto Scaling
console to visualize forecasts for the specified metric. For more
information, see View Scaling Information for a Resource
(https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-create-scaling-plan.html#gs-view-resource)
in the I<AWS Auto Scaling User Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> PredefinedLoadMetricType => Str

The metric type.


=head2 ResourceLabel => Str

Identifies the resource associated with the metric type. You can't
specify a resource label unless the metric type is
C<ALBTargetGroupRequestCount> and there is a target group for an
Application Load Balancer attached to the Auto Scaling group.

You create the resource label by appending the final portion of the
load balancer ARN and the final portion of the target group ARN into a
single value, separated by a forward slash (/). The format is
app/E<lt>load-balancer-nameE<gt>/E<lt>load-balancer-idE<gt>/targetgroup/E<lt>target-group-nameE<gt>/E<lt>target-group-idE<gt>,
where:

=over

=item *

app/E<lt>load-balancer-nameE<gt>/E<lt>load-balancer-idE<gt> is the
final portion of the load balancer ARN

=item *

targetgroup/E<lt>target-group-nameE<gt>/E<lt>target-group-idE<gt> is
the final portion of the target group ARN.

=back

This is an example:
app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.

To find the ARN for an Application Load Balancer, use the
DescribeLoadBalancers
(https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
API operation. To find the ARN for the target group, use the
DescribeTargetGroups
(https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
API operation.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AutoScalingPlans>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

