# Generated by default/object.tt
package Paws::EMR::ExecutionEngineConfig;
  use Moose;
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has MasterInstanceSecurityGroupId => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMR::ExecutionEngineConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMR::ExecutionEngineConfig object:

  $service_obj->Method(Att1 => { Id => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMR::ExecutionEngineConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->Id

=head1 DESCRIPTION

Specifies the execution engine (cluster) to run the notebook and
perform the notebook execution, for example, an EMR cluster.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Id => Str

The unique identifier of the execution engine. For an EMR cluster, this
is the cluster ID.


=head2 MasterInstanceSecurityGroupId => Str

An optional unique ID of an EC2 security group to associate with the
master instance of the EMR cluster for this notebook execution. For
more information see Specifying EC2 Security Groups for EMR Notebooks
(https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html)
in the I<EMR Management Guide>.


=head2 Type => Str

The type of execution engine. A value of C<EMR> specifies an EMR
cluster.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMR>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

