## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::date::dow_nums;

our $DATE = '2022-10-12'; # DATE
our $VERSION = '0.018'; # VERSION

our $rschema = do{my$var={base=>"array",clsets_after_base=>[{description=>"\nSee also <pm:Sah::Schema::date::dow_num> which is the schema for the elements.\n\nSee also related schemas that coerce from other locales, e.g.\n<pm:Sah::Schema::date::dow_nums::id> (Indonesian),\n<pm:Sah::Schema::date::dow_num::en_or_id> (English/Indonesian), etc.\n\n",examples=>[{valid=>1,validated_value=>[],value=>""},{valid=>1,validated_value=>[1],value=>1},{valid=>1,value=>[1]},{summary=>"Contains undef",valid=>0,value=>[1,undef]},{valid=>1,value=>[1,7]},{valid=>1,validated_value=>[1,7],value=>"1,7"},{valid=>1,validated_value=>[1,7],value=>["Mon","SunDAY"]},{valid=>1,validated_value=>[1,7],value=>"Mo,SU"},{summary=>"Has number not in 1-7",valid=>0,value=>[1,7,8]},{summary=>"Has number not in 1-7",valid=>0,value=>"1,7,8"}],of=>["date::dow_num",{req=>1}],summary=>"Array of required date::dow_num (day-of-week, 1-7, 1=Monday, like DateTime, with coercions), e.g. [1,3,5]","x.completion"=>["date_dow_nums"],"x.perl.coerce_rules"=>["From_str::comma_sep"]}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["array"],type=>"array",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Array of required date::dow_num (day-of-week, 1-7, 1=Monday, like DateTime, with coercions), e.g. [1,3,5]

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::date::dow_nums - Array of required date::dow_num (day-of-week, 1-7, 1=Monday, like DateTime, with coercions), e.g. [1,3,5]

=head1 VERSION

This document describes version 0.018 of Sah::SchemaR::date::dow_nums (from Perl distribution Sah-Schemas-Date), released on 2022-10-12.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Date>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Date>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022, 2020, 2019 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Date>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
