/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ManagementObject;
import org.apache.uima.util.Level;

public class JmxMBeanAgent {
    private static boolean jmxAvailable = true;
    private static MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMBean(ManagementObject aMBean, Object aMBeanServerO) {
        MBeanServer aMBeanServer = (MBeanServer)aMBeanServerO;
        if (!jmxAvailable) {
            return;
        }
        if (aMBeanServer == null) {
            if (platformMBeanServer != null) {
                aMBeanServer = platformMBeanServer;
            } else {
                UIMAFramework.getLogger().logrb(Level.CONFIG, JmxMBeanAgent.class.getName(), "registerMBean", LOG_RESOURCE_BUNDLE, "UIMA_JMX_platform_mbean_server_not_available__CONFIG");
                return;
            }
        }
        try {
            ObjectName mbeanName = new ObjectName(aMBean.getUniqueMBeanName());
            MBeanServer mBeanServer = aMBeanServer;
            synchronized (mBeanServer) {
                if (!aMBeanServer.isRegistered(mbeanName)) {
                    aMBeanServer.registerMBean(aMBean, mbeanName);
                }
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger().logrb(Level.WARNING, JmxMBeanAgent.class.getName(), "registerMBean", LOG_RESOURCE_BUNDLE, "UIMA_JMX_failed_to_register_mbean__WARNING", e);
            return;
        }
    }

    public static void unregisterMBean(ManagementObject aMBean, Object aMBeanServerO) {
        MBeanServer aMBeanServer = (MBeanServer)aMBeanServerO;
        if (!jmxAvailable) {
            return;
        }
        if (aMBeanServer == null) {
            if (platformMBeanServer != null) {
                aMBeanServer = platformMBeanServer;
            } else {
                UIMAFramework.getLogger().logrb(Level.CONFIG, JmxMBeanAgent.class.getName(), "unregisterMBean", LOG_RESOURCE_BUNDLE, "UIMA_JMX_platform_mbean_server_not_available__CONFIG");
                return;
            }
        }
        try {
            ObjectName objName;
            String mbeanName = aMBean.getUniqueMBeanName();
            if (mbeanName != null && aMBeanServer.isRegistered(objName = new ObjectName(mbeanName))) {
                aMBeanServer.unregisterMBean(objName);
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger().logrb(Level.WARNING, JmxMBeanAgent.class.getName(), "unregisterMBean", LOG_RESOURCE_BUNDLE, "UIMA_JMX_failed_to_unregister_mbean__WARNING", e);
            return;
        }
    }
}

