#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Ankh 1
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241023.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='ankh-1'
GAME_NAME='Ankh'

ARCHIVE_BASE_0_NAME='setup_ankh_-_anniversary_edition_1.0a_(34062).exe'
ARCHIVE_BASE_0_MD5='b1e6094c37d3da40352303c0a1f51f0c'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='910000'
ARCHIVE_BASE_0_VERSION='1.0a-gog34062'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/ankh_anniversary_edition'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
bin'
CONTENT_GAME_DATA_FILES='
media'
CONTENT_DOC_DATA_FILES='
readme.txt'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Ankh'
USER_PERSISTENT_FILES='
bin/release/plugins.cfg
media/*.cfg
media/*.ini'

APP_MAIN_EXE='bin/release/ankh.exe'
APP_MAIN_ICON='bin/release/ankh.ico'
## The game expects a writable "save" directory,
## despite not using it to store saved games
APP_MAIN_PRERUN='
# The game expects a writable "save" directory,
# despite not using it to store saved games
mkdir --parents save
'
## Enable game logs storage
APP_MAIN_PRERUN="${APP_MAIN_PRERUN:-}"'
# Enable game logs storage
mkdir --parents bin/release/logs
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Drop log files
	rm --recursive \
		'bin/release/logs' \
		'bin/release/cegui.log' \
		'bin/release/ogre.log'
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Run the game binary from its parent directory
game_exec_line() {
	cat <<- 'EOF'
	cd bin/release
	$(wine_command) ankh.exe "$@"
	EOF
}

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
