# Python SDK Pylint Guide

Cheat sheet for the Python SDK pylint general guidelines for your client library 

# Table of contents
  - [General Guidance](#general-guidance)
    - [What is Pylint?](#what-is-pylint)
    - [How to run Pylint?](#how-to-run-pylint)
  - [Ignoring Pylint Checkers](#ignoring-pylint-checkers)
  - [Pylint Warnings and Where to Find Them](#pylint-warnings-and-where-to-find-them)
    - [Next Pylint](#next-pylint)
  - [How to Prepare your SDK?](#how-to-prepare-your-sdk-for-a-new-pylint-update)


# General Guidance 

## What is pylint?

Pylint is a set of (mostly) [astroid](https://pylint.pycqa.org/projects/astroid/en/latest/index.html) based checkers that run static analysis on your code and check that your formatting aligns with Python's style guide (i.e [PEPs](https://peps.python.org/)). 

In the Azure SDK for Python repository, in addition to the standard pylint library, there are also custom checkers within the azure-pylint-guidelines-checker package that help to customize our libraries to the standards described in the [Azure SDK for Python Guidelines](https://azure.github.io/azure-sdk/python_design.html).

## How to run Pylint?

The recommended way to run pylint is with `azpysdk` at the package level:

    .../azure-sdk-for-python/sdk/eventgrid/azure-eventgrid> azpysdk pylint .

If you don't want to use `azpysdk`, you can also install and run pylint on its own:

 - If taking this approach, in order to run with the pylintrc formatting and the custom pylint checkers you must also install the custom checkers and `SET` the pylintrc path. 

        pip install pylint
        pip install azure-pylint-guidelines-checker --index-url="https://pkgs.dev.azure.com/azure-sdk/public/_packaging/azure-sdk-for-python/pypi/simple/"

        .../azure-sdk-for-python>SET PYLINTRC="./pylintrc"
        .../azure-sdk-for-python>pylint ./sdk/eventgrid/azure-eventgrid

    Note that you may see different errors if running a different version of [pylint](https://github.com/Azure/azure-sdk-for-python/blob/main/eng/tools/azure-sdk-tools/azpysdk/pylint.py#L17) or [azure-pylint-guidelines-checker](https://github.com/Azure/azure-sdk-for-python/blob/main/eng/tools/azure-sdk-tools/azpysdk/pylint.py#L61) than the one in CI.

# Ignoring Pylint Checkers

- If there is a pylint checker within your SDK that you wish to ignore for that specific scenario (i.e protected-access) you can ignore it with a comment on the offending line.

    `# pylint:disable=protected-access`  
    
- (Not Recommended) Another way to disable a checker is by ignoring the entire package in the [pyproject.toml](https://github.com/Azure/azure-sdk-for-python/blob/main/doc/eng_sys_checks.md#the-pyprojecttoml).


# Pylint Warnings and Where to Find Them 

Information on the custom pylint checkers resides [here](https://github.com/Azure/azure-sdk-tools/blob/main/tools/pylint-extensions/azure-pylint-guidelines-checker/README.md). [This table](https://github.com/Azure/azure-sdk-tools/blob/main/tools/pylint-extensions/azure-pylint-guidelines-checker/README.md#rules-list), provides information on each custom check and how to resolve them. 

In addition to being a part of the CI, the custom pylint checkers are also integrated into ApiView. If there are unaddressed warnings, they will show as system comments. 

## Next Pylint

There is now a new step on the CI pipeline called `Run Pylint Next`. This is merely a duplicate of the `Run Pylint` step with the exception that `Run Pylint Next` uses the latest version of pylint and the latest version of the custom pylint checkers.

This next-pylint check can also be run locally:

    azpysdk pylint --next=True <path to python package>

The errors generated by the `Run Pylint Next` step will not break your weekly test pipelines, but make sure to fix the warnings so that your client library is up to date for the next pylint release. 

# How to prepare your SDK for a new pylint update?

Check each client library's `Run Pylint Next` output in the [test-weekly CI pipeline](https://dev.azure.com/azure-sdk/internal/_build?pipelineNameFilter=python%20*%20tests-weekly). If there is no corresponding test-weekly pipeline, run `next-pylint` locally with `azpysdk pylint --next=True .` as described in [How to run Pylint?](#how-to-run-pylint). In order to ensure that the SDK pipeline will not break when pylint is updated, make sure to address all pylint warnings present. 
