# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AccountSku(_Model):
    """SKU of the artifact signing account.

    :ivar name: Name of the SKU. Required. Known values are: "Basic" and "Premium".
    :vartype name: str or ~azure.mgmt.artifactsigning.models.SkuName
    """

    name: Union[str, "_models.SkuName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the SKU. Required. Known values are: \"Basic\" and \"Premium\"."""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AccountSkuPatch(_Model):
    """SKU of the artifact signing account.

    :ivar name: Name of the SKU. Known values are: "Basic" and "Premium".
    :vartype name: str or ~azure.mgmt.artifactsigning.models.SkuName
    """

    name: Optional[Union[str, "_models.SkuName"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the SKU. Known values are: \"Basic\" and \"Premium\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.SkuName"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Certificate(_Model):
    """Properties of the certificate.

    :ivar serial_number: Serial number of the certificate.
    :vartype serial_number: str
    :ivar enhanced_key_usage: Enhanced key usage of the certificate.
    :vartype enhanced_key_usage: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar thumbprint: Thumbprint of the certificate.
    :vartype thumbprint: str
    :ivar created_date: Certificate created date.
    :vartype created_date: str
    :ivar expiry_date: Certificate expiry date.
    :vartype expiry_date: str
    :ivar status: Status of the certificate. Known values are: "Active", "Expired", and "Revoked".
    :vartype status: str or ~azure.mgmt.artifactsigning.models.CertificateStatus
    :ivar revocation: Revocations history of a certificate.
    :vartype revocation: ~azure.mgmt.artifactsigning.models.Revocation
    """

    serial_number: Optional[str] = rest_field(
        name="serialNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """Serial number of the certificate."""
    enhanced_key_usage: Optional[str] = rest_field(
        name="enhancedKeyUsage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enhanced key usage of the certificate."""
    subject_name: Optional[str] = rest_field(
        name="subjectName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Subject name of the certificate."""
    thumbprint: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Thumbprint of the certificate."""
    created_date: Optional[str] = rest_field(
        name="createdDate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Certificate created date."""
    expiry_date: Optional[str] = rest_field(
        name="expiryDate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Certificate expiry date."""
    status: Optional[Union[str, "_models.CertificateStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Status of the certificate. Known values are: \"Active\", \"Expired\", and \"Revoked\"."""
    revocation: Optional["_models.Revocation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Revocations history of a certificate."""

    __flattened_items = ["requested_at", "effective_at", "reason", "remarks", "status", "failure_reason"]

    @overload
    def __init__(
        self,
        *,
        serial_number: Optional[str] = None,
        enhanced_key_usage: Optional[str] = None,
        subject_name: Optional[str] = None,
        thumbprint: Optional[str] = None,
        created_date: Optional[str] = None,
        expiry_date: Optional[str] = None,
        status: Optional[Union[str, "_models.CertificateStatus"]] = None,
        revocation: Optional["_models.Revocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.revocation is None:
                return None
            return getattr(self.revocation, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.revocation is None:
                self.revocation = self._attr_to_rest_field["revocation"]._class_type()
            setattr(self.revocation, key, value)
        else:
            super().__setattr__(key, value)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.artifactsigning.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.artifactsigning.models.SystemData
    """


class CertificateProfile(ProxyResource):
    """Certificate profile resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.artifactsigning.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.artifactsigning.models.CertificateProfileProperties
    """

    properties: Optional["_models.CertificateProfileProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "profile_type",
        "include_street_address",
        "include_city",
        "include_state",
        "include_country",
        "include_postal_code",
        "identity_validation_id",
        "provisioning_state",
        "status",
        "certificates",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.CertificateProfileProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class CertificateProfileProperties(_Model):
    """Properties of the certificate profile.

    :ivar profile_type: Profile type of the certificate. Required. Known values are: "PublicTrust",
     "PrivateTrust", "PrivateTrustCIPolicy", "VBSEnclave", and "PublicTrustTest".
    :vartype profile_type: str or ~azure.mgmt.artifactsigning.models.ProfileType
    :ivar include_street_address: Whether to include STREET in the certificate subject name.
    :vartype include_street_address: bool
    :ivar include_city: Whether to include L in the certificate subject name. Applicable only for
     private trust, private trust ci profile types.
    :vartype include_city: bool
    :ivar include_state: Whether to include S in the certificate subject name. Applicable only for
     private trust, private trust ci profile types.
    :vartype include_state: bool
    :ivar include_country: Whether to include C in the certificate subject name. Applicable only
     for private trust, private trust ci profile types.
    :vartype include_country: bool
    :ivar include_postal_code: Whether to include PC in the certificate subject name.
    :vartype include_postal_code: bool
    :ivar identity_validation_id: Identity validation id used for the certificate subject name.
     Required.
    :vartype identity_validation_id: str
    :ivar provisioning_state: Status of the current operation on certificate profile. Known values
     are: "Succeeded", "Failed", "Canceled", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.artifactsigning.models.ProvisioningState
    :ivar status: Status of the certificate profile. Known values are: "Active", "Disabled", and
     "Suspended".
    :vartype status: str or ~azure.mgmt.artifactsigning.models.CertificateProfileStatus
    :ivar certificates: List of renewed certificates.
    :vartype certificates: list[~azure.mgmt.artifactsigning.models.Certificate]
    """

    profile_type: Union[str, "_models.ProfileType"] = rest_field(
        name="profileType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Profile type of the certificate. Required. Known values are: \"PublicTrust\", \"PrivateTrust\",
     \"PrivateTrustCIPolicy\", \"VBSEnclave\", and \"PublicTrustTest\"."""
    include_street_address: Optional[bool] = rest_field(
        name="includeStreetAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to include STREET in the certificate subject name."""
    include_city: Optional[bool] = rest_field(
        name="includeCity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to include L in the certificate subject name. Applicable only for private trust,
     private trust ci profile types."""
    include_state: Optional[bool] = rest_field(
        name="includeState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to include S in the certificate subject name. Applicable only for private trust,
     private trust ci profile types."""
    include_country: Optional[bool] = rest_field(
        name="includeCountry", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to include C in the certificate subject name. Applicable only for private trust,
     private trust ci profile types."""
    include_postal_code: Optional[bool] = rest_field(
        name="includePostalCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to include PC in the certificate subject name."""
    identity_validation_id: str = rest_field(
        name="identityValidationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity validation id used for the certificate subject name. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Status of the current operation on certificate profile. Known values are: \"Succeeded\",
     \"Failed\", \"Canceled\", \"Updating\", \"Deleting\", and \"Accepted\"."""
    status: Optional[Union[str, "_models.CertificateProfileStatus"]] = rest_field(visibility=["read"])
    """Status of the certificate profile. Known values are: \"Active\", \"Disabled\", and
     \"Suspended\"."""
    certificates: Optional[list["_models.Certificate"]] = rest_field(visibility=["read"])
    """List of renewed certificates."""

    @overload
    def __init__(
        self,
        *,
        profile_type: Union[str, "_models.ProfileType"],
        identity_validation_id: str,
        include_street_address: Optional[bool] = None,
        include_city: Optional[bool] = None,
        include_state: Optional[bool] = None,
        include_country: Optional[bool] = None,
        include_postal_code: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailability(_Model):
    """The parameters used to check the availability of the artifact signing account name.

    :ivar type: The type of the resource, "Microsoft.CodeSigning/codeSigningAccounts". Required.
    :vartype type: str
    :ivar name: Artifact signing account name. Required.
    :vartype name: str
    """

    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of the resource, \"Microsoft.CodeSigning/codeSigningAccounts\". Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Artifact signing account name. Required."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityResult(_Model):
    """The CheckNameAvailability operation response.

    :ivar name_available: A boolean value that indicates whether the name is available for you to
     use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: The reason that an artifact signing account name could not be used. The Reason
     element is only returned if nameAvailable is false. Known values are: "AccountNameInvalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.artifactsigning.models.NameUnavailabilityReason
    :ivar message: An error message explaining the Reason value in more detail.
    :vartype message: str
    """

    name_available: Optional[bool] = rest_field(name="nameAvailable", visibility=["read"])
    """A boolean value that indicates whether the name is available for you to use. If true, the name
     is available. If false, the name has already been taken or is invalid and cannot be used."""
    reason: Optional[Union[str, "_models.NameUnavailabilityReason"]] = rest_field(visibility=["read"])
    """The reason that an artifact signing account name could not be used. The Reason element is only
     returned if nameAvailable is false. Known values are: \"AccountNameInvalid\" and
     \"AlreadyExists\"."""
    message: Optional[str] = rest_field(visibility=["read"])
    """An error message explaining the Reason value in more detail."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.artifactsigning.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CodeSigningAccount(TrackedResource):
    """Artifact signing account resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.artifactsigning.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.artifactsigning.models.CodeSigningAccountProperties
    """

    properties: Optional["_models.CodeSigningAccountProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["account_uri", "sku", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.CodeSigningAccountProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class CodeSigningAccountPatch(_Model):
    """Parameters for creating or updating an artifact signing account.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the artifact signing account.
    :vartype properties: ~azure.mgmt.artifactsigning.models.CodeSigningAccountPatchProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.CodeSigningAccountPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the artifact signing account."""

    __flattened_items = ["sku"]

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.CodeSigningAccountPatchProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class CodeSigningAccountPatchProperties(_Model):
    """Properties of the artifact signing account.

    :ivar sku: SKU of the artifact signing account.
    :vartype sku: ~azure.mgmt.artifactsigning.models.AccountSkuPatch
    """

    sku: Optional["_models.AccountSkuPatch"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU of the artifact signing account."""

    @overload
    def __init__(
        self,
        *,
        sku: Optional["_models.AccountSkuPatch"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CodeSigningAccountProperties(_Model):
    """Properties of the artifact signing account.

    :ivar account_uri: The URI of the artifact signing account which is used during signing files.
    :vartype account_uri: str
    :ivar sku: SKU of the artifact signing account.
    :vartype sku: ~azure.mgmt.artifactsigning.models.AccountSku
    :ivar provisioning_state: Status of the current operation on artifact signing account. Known
     values are: "Succeeded", "Failed", "Canceled", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.artifactsigning.models.ProvisioningState
    """

    account_uri: Optional[str] = rest_field(name="accountUri", visibility=["read"])
    """The URI of the artifact signing account which is used during signing files."""
    sku: Optional["_models.AccountSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU of the artifact signing account."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Status of the current operation on artifact signing account. Known values are: \"Succeeded\",
     \"Failed\", \"Canceled\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        sku: Optional["_models.AccountSku"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.artifactsigning.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.artifactsigning.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.artifactsigning.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.artifactsigning.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.artifactsigning.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.artifactsigning.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for an operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class Revocation(_Model):
    """Revocation details of the certificate.

    :ivar requested_at: The timestamp when the revocation is requested.
    :vartype requested_at: ~datetime.datetime
    :ivar effective_at: The timestamp when the revocation is effective.
    :vartype effective_at: ~datetime.datetime
    :ivar reason: Reason for revocation.
    :vartype reason: str
    :ivar remarks: Remarks for the revocation.
    :vartype remarks: str
    :ivar status: Status of the revocation. Known values are: "Succeeded", "InProgress", and
     "Failed".
    :vartype status: str or ~azure.mgmt.artifactsigning.models.RevocationStatus
    :ivar failure_reason: Reason for the revocation failure.
    :vartype failure_reason: str
    """

    requested_at: Optional[datetime.datetime] = rest_field(
        name="requestedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp when the revocation is requested."""
    effective_at: Optional[datetime.datetime] = rest_field(
        name="effectiveAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp when the revocation is effective."""
    reason: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Reason for revocation."""
    remarks: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Remarks for the revocation."""
    status: Optional[Union[str, "_models.RevocationStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Status of the revocation. Known values are: \"Succeeded\", \"InProgress\", and \"Failed\"."""
    failure_reason: Optional[str] = rest_field(
        name="failureReason", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reason for the revocation failure."""

    @overload
    def __init__(
        self,
        *,
        requested_at: Optional[datetime.datetime] = None,
        effective_at: Optional[datetime.datetime] = None,
        reason: Optional[str] = None,
        remarks: Optional[str] = None,
        status: Optional[Union[str, "_models.RevocationStatus"]] = None,
        failure_reason: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RevokeCertificate(_Model):
    """Defines the certificate revocation properties.

    :ivar serial_number: Serial number of the certificate. Required.
    :vartype serial_number: str
    :ivar thumbprint: Thumbprint of the certificate. Required.
    :vartype thumbprint: str
    :ivar effective_at: The timestamp when the revocation is effective. Required.
    :vartype effective_at: ~datetime.datetime
    :ivar reason: Reason for the revocation. Required.
    :vartype reason: str
    :ivar remarks: Remarks for the revocation.
    :vartype remarks: str
    """

    serial_number: str = rest_field(name="serialNumber", visibility=["read", "create", "update", "delete", "query"])
    """Serial number of the certificate. Required."""
    thumbprint: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Thumbprint of the certificate. Required."""
    effective_at: datetime.datetime = rest_field(
        name="effectiveAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp when the revocation is effective. Required."""
    reason: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Reason for the revocation. Required."""
    remarks: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Remarks for the revocation."""

    @overload
    def __init__(
        self,
        *,
        serial_number: str,
        thumbprint: str,
        effective_at: datetime.datetime,
        reason: str,
        remarks: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.artifactsigning.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.artifactsigning.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
