# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.batch.aio import BatchManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBatchManagementPoolOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BatchManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_pool_get(self, resource_group):
        response = await self.client.pool.get(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_pool_create(self, resource_group):
        response = await self.client.pool.create(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            parameters={
                "etag": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "allocationState": "str",
                    "allocationStateTransitionTime": "2020-02-20 00:00:00",
                    "applicationPackages": [{"id": "str", "version": "str"}],
                    "autoScaleRun": {
                        "evaluationTime": "2020-02-20 00:00:00",
                        "error": {"code": "str", "message": "str", "details": [...]},
                        "results": "str",
                    },
                    "creationTime": "2020-02-20 00:00:00",
                    "currentDedicatedNodes": 0,
                    "currentLowPriorityNodes": 0,
                    "deploymentConfiguration": {
                        "virtualMachineConfiguration": {
                            "imageReference": {
                                "communityGalleryImageId": "str",
                                "id": "str",
                                "offer": "str",
                                "publisher": "str",
                                "sharedGalleryImageId": "str",
                                "sku": "str",
                                "version": "str",
                            },
                            "nodeAgentSkuId": "str",
                            "containerConfiguration": {
                                "type": "str",
                                "containerImageNames": ["str"],
                                "containerRegistries": [
                                    {
                                        "identityReference": {"resourceId": "str"},
                                        "password": "str",
                                        "registryServer": "str",
                                        "username": "str",
                                    }
                                ],
                            },
                            "dataDisks": [
                                {
                                    "diskSizeGB": 0,
                                    "lun": 0,
                                    "caching": "str",
                                    "managedDisk": {
                                        "diskEncryptionSet": {"id": "str"},
                                        "securityProfile": {
                                            "diskEncryptionSet": {"id": "str"},
                                            "securityEncryptionType": "str",
                                        },
                                        "storageAccountType": "str",
                                    },
                                }
                            ],
                            "diskEncryptionConfiguration": {
                                "customerManagedKey": {
                                    "identityReference": {"resourceId": "str"},
                                    "keyUrl": "str",
                                    "rotationToLatestKeyVersionEnabled": bool,
                                },
                                "targets": ["str"],
                            },
                            "extensions": [
                                {
                                    "name": "str",
                                    "publisher": "str",
                                    "type": "str",
                                    "autoUpgradeMinorVersion": bool,
                                    "enableAutomaticUpgrade": bool,
                                    "protectedSettings": {},
                                    "provisionAfterExtensions": ["str"],
                                    "settings": {},
                                    "typeHandlerVersion": "str",
                                }
                            ],
                            "licenseType": "str",
                            "nodePlacementConfiguration": {"policy": "str"},
                            "osDisk": {
                                "caching": "str",
                                "diskSizeGB": 0,
                                "ephemeralOSDiskSettings": {"placement": "str"},
                                "managedDisk": {
                                    "diskEncryptionSet": {"id": "str"},
                                    "securityProfile": {
                                        "diskEncryptionSet": {"id": "str"},
                                        "securityEncryptionType": "str",
                                    },
                                    "storageAccountType": "str",
                                },
                                "writeAcceleratorEnabled": bool,
                            },
                            "securityProfile": {
                                "encryptionAtHost": bool,
                                "proxyAgentSettings": {
                                    "enabled": bool,
                                    "imds": {"inVMAccessControlProfileReferenceId": "str", "mode": "str"},
                                    "wireServer": {"inVMAccessControlProfileReferenceId": "str", "mode": "str"},
                                },
                                "securityType": "str",
                                "uefiSettings": {"secureBootEnabled": bool, "vTpmEnabled": bool},
                            },
                            "serviceArtifactReference": {"id": "str"},
                            "windowsConfiguration": {"enableAutomaticUpdates": bool},
                        }
                    },
                    "displayName": "str",
                    "interNodeCommunication": "str",
                    "lastModified": "2020-02-20 00:00:00",
                    "metadata": [{"name": "str", "value": "str"}],
                    "mountConfiguration": [
                        {
                            "azureBlobFileSystemConfiguration": {
                                "accountName": "str",
                                "containerName": "str",
                                "relativeMountPath": "str",
                                "accountKey": "str",
                                "blobfuseOptions": "str",
                                "identityReference": {"resourceId": "str"},
                                "sasKey": "str",
                            },
                            "azureFileShareConfiguration": {
                                "accountKey": "str",
                                "accountName": "str",
                                "azureFileUrl": "str",
                                "relativeMountPath": "str",
                                "mountOptions": "str",
                            },
                            "cifsMountConfiguration": {
                                "password": "str",
                                "relativeMountPath": "str",
                                "source": "str",
                                "userName": "str",
                                "mountOptions": "str",
                            },
                            "nfsMountConfiguration": {
                                "relativeMountPath": "str",
                                "source": "str",
                                "mountOptions": "str",
                            },
                        }
                    ],
                    "networkConfiguration": {
                        "dynamicVnetAssignmentScope": "str",
                        "enableAcceleratedNetworking": bool,
                        "endpointConfiguration": {
                            "inboundNatPools": [
                                {
                                    "backendPort": 0,
                                    "frontendPortRangeEnd": 0,
                                    "frontendPortRangeStart": 0,
                                    "name": "str",
                                    "protocol": "str",
                                    "networkSecurityGroupRules": [
                                        {
                                            "access": "str",
                                            "priority": 0,
                                            "sourceAddressPrefix": "str",
                                            "sourcePortRanges": ["str"],
                                        }
                                    ],
                                }
                            ]
                        },
                        "publicIPAddressConfiguration": {
                            "ipAddressIds": ["str"],
                            "ipFamilies": ["str"],
                            "ipTags": [{"ipTagType": "str", "tag": "str"}],
                            "provision": "str",
                        },
                        "subnetId": "str",
                    },
                    "provisioningState": "str",
                    "provisioningStateTransitionTime": "2020-02-20 00:00:00",
                    "resizeOperationStatus": {
                        "errors": [{"code": "str", "message": "str", "details": [...]}],
                        "nodeDeallocationOption": "str",
                        "resizeTimeout": "1 day, 0:00:00",
                        "startTime": "2020-02-20 00:00:00",
                        "targetDedicatedNodes": 0,
                        "targetLowPriorityNodes": 0,
                    },
                    "scaleSettings": {
                        "autoScale": {"formula": "str", "evaluationInterval": "1 day, 0:00:00"},
                        "fixedScale": {
                            "nodeDeallocationOption": "str",
                            "resizeTimeout": "1 day, 0:00:00",
                            "targetDedicatedNodes": 0,
                            "targetLowPriorityNodes": 0,
                        },
                    },
                    "startTask": {
                        "commandLine": "str",
                        "containerSettings": {
                            "imageName": "str",
                            "containerHostBatchBindMounts": [{"isReadOnly": bool, "source": "str"}],
                            "containerRunOptions": "str",
                            "registry": {
                                "identityReference": {"resourceId": "str"},
                                "password": "str",
                                "registryServer": "str",
                                "username": "str",
                            },
                            "workingDirectory": "str",
                        },
                        "environmentSettings": [{"name": "str", "value": "str"}],
                        "maxTaskRetryCount": 0,
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",
                                "blobPrefix": "str",
                                "fileMode": "str",
                                "filePath": "str",
                                "httpUrl": "str",
                                "identityReference": {"resourceId": "str"},
                                "storageContainerUrl": "str",
                            }
                        ],
                        "userIdentity": {"autoUser": {"elevationLevel": "str", "scope": "str"}, "userName": "str"},
                        "waitForSuccess": bool,
                    },
                    "taskSchedulingPolicy": {"nodeFillType": "str", "jobDefaultOrder": "str"},
                    "taskSlotsPerNode": 0,
                    "upgradePolicy": {
                        "mode": "str",
                        "automaticOSUpgradePolicy": {
                            "disableAutomaticRollback": bool,
                            "enableAutomaticOSUpgrade": bool,
                            "osRollingUpgradeDeferral": bool,
                            "useRollingUpgradePolicy": bool,
                        },
                        "rollingUpgradePolicy": {
                            "enableCrossZoneUpgrade": bool,
                            "maxBatchInstancePercent": 0,
                            "maxUnhealthyInstancePercent": 0,
                            "maxUnhealthyUpgradedInstancePercent": 0,
                            "pauseTimeBetweenBatches": "str",
                            "prioritizeUnhealthyInstances": bool,
                            "rollbackFailedInstancesOnPolicyBreach": bool,
                        },
                    },
                    "userAccounts": [
                        {
                            "name": "str",
                            "password": "str",
                            "elevationLevel": "str",
                            "linuxUserConfiguration": {"gid": 0, "sshPrivateKey": "str", "uid": 0},
                            "windowsUserConfiguration": {"loginMode": "str"},
                        }
                    ],
                    "vmSize": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_pool_update(self, resource_group):
        response = await self.client.pool.update(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            parameters={
                "etag": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "allocationState": "str",
                    "allocationStateTransitionTime": "2020-02-20 00:00:00",
                    "applicationPackages": [{"id": "str", "version": "str"}],
                    "autoScaleRun": {
                        "evaluationTime": "2020-02-20 00:00:00",
                        "error": {"code": "str", "message": "str", "details": [...]},
                        "results": "str",
                    },
                    "creationTime": "2020-02-20 00:00:00",
                    "currentDedicatedNodes": 0,
                    "currentLowPriorityNodes": 0,
                    "deploymentConfiguration": {
                        "virtualMachineConfiguration": {
                            "imageReference": {
                                "communityGalleryImageId": "str",
                                "id": "str",
                                "offer": "str",
                                "publisher": "str",
                                "sharedGalleryImageId": "str",
                                "sku": "str",
                                "version": "str",
                            },
                            "nodeAgentSkuId": "str",
                            "containerConfiguration": {
                                "type": "str",
                                "containerImageNames": ["str"],
                                "containerRegistries": [
                                    {
                                        "identityReference": {"resourceId": "str"},
                                        "password": "str",
                                        "registryServer": "str",
                                        "username": "str",
                                    }
                                ],
                            },
                            "dataDisks": [
                                {
                                    "diskSizeGB": 0,
                                    "lun": 0,
                                    "caching": "str",
                                    "managedDisk": {
                                        "diskEncryptionSet": {"id": "str"},
                                        "securityProfile": {
                                            "diskEncryptionSet": {"id": "str"},
                                            "securityEncryptionType": "str",
                                        },
                                        "storageAccountType": "str",
                                    },
                                }
                            ],
                            "diskEncryptionConfiguration": {
                                "customerManagedKey": {
                                    "identityReference": {"resourceId": "str"},
                                    "keyUrl": "str",
                                    "rotationToLatestKeyVersionEnabled": bool,
                                },
                                "targets": ["str"],
                            },
                            "extensions": [
                                {
                                    "name": "str",
                                    "publisher": "str",
                                    "type": "str",
                                    "autoUpgradeMinorVersion": bool,
                                    "enableAutomaticUpgrade": bool,
                                    "protectedSettings": {},
                                    "provisionAfterExtensions": ["str"],
                                    "settings": {},
                                    "typeHandlerVersion": "str",
                                }
                            ],
                            "licenseType": "str",
                            "nodePlacementConfiguration": {"policy": "str"},
                            "osDisk": {
                                "caching": "str",
                                "diskSizeGB": 0,
                                "ephemeralOSDiskSettings": {"placement": "str"},
                                "managedDisk": {
                                    "diskEncryptionSet": {"id": "str"},
                                    "securityProfile": {
                                        "diskEncryptionSet": {"id": "str"},
                                        "securityEncryptionType": "str",
                                    },
                                    "storageAccountType": "str",
                                },
                                "writeAcceleratorEnabled": bool,
                            },
                            "securityProfile": {
                                "encryptionAtHost": bool,
                                "proxyAgentSettings": {
                                    "enabled": bool,
                                    "imds": {"inVMAccessControlProfileReferenceId": "str", "mode": "str"},
                                    "wireServer": {"inVMAccessControlProfileReferenceId": "str", "mode": "str"},
                                },
                                "securityType": "str",
                                "uefiSettings": {"secureBootEnabled": bool, "vTpmEnabled": bool},
                            },
                            "serviceArtifactReference": {"id": "str"},
                            "windowsConfiguration": {"enableAutomaticUpdates": bool},
                        }
                    },
                    "displayName": "str",
                    "interNodeCommunication": "str",
                    "lastModified": "2020-02-20 00:00:00",
                    "metadata": [{"name": "str", "value": "str"}],
                    "mountConfiguration": [
                        {
                            "azureBlobFileSystemConfiguration": {
                                "accountName": "str",
                                "containerName": "str",
                                "relativeMountPath": "str",
                                "accountKey": "str",
                                "blobfuseOptions": "str",
                                "identityReference": {"resourceId": "str"},
                                "sasKey": "str",
                            },
                            "azureFileShareConfiguration": {
                                "accountKey": "str",
                                "accountName": "str",
                                "azureFileUrl": "str",
                                "relativeMountPath": "str",
                                "mountOptions": "str",
                            },
                            "cifsMountConfiguration": {
                                "password": "str",
                                "relativeMountPath": "str",
                                "source": "str",
                                "userName": "str",
                                "mountOptions": "str",
                            },
                            "nfsMountConfiguration": {
                                "relativeMountPath": "str",
                                "source": "str",
                                "mountOptions": "str",
                            },
                        }
                    ],
                    "networkConfiguration": {
                        "dynamicVnetAssignmentScope": "str",
                        "enableAcceleratedNetworking": bool,
                        "endpointConfiguration": {
                            "inboundNatPools": [
                                {
                                    "backendPort": 0,
                                    "frontendPortRangeEnd": 0,
                                    "frontendPortRangeStart": 0,
                                    "name": "str",
                                    "protocol": "str",
                                    "networkSecurityGroupRules": [
                                        {
                                            "access": "str",
                                            "priority": 0,
                                            "sourceAddressPrefix": "str",
                                            "sourcePortRanges": ["str"],
                                        }
                                    ],
                                }
                            ]
                        },
                        "publicIPAddressConfiguration": {
                            "ipAddressIds": ["str"],
                            "ipFamilies": ["str"],
                            "ipTags": [{"ipTagType": "str", "tag": "str"}],
                            "provision": "str",
                        },
                        "subnetId": "str",
                    },
                    "provisioningState": "str",
                    "provisioningStateTransitionTime": "2020-02-20 00:00:00",
                    "resizeOperationStatus": {
                        "errors": [{"code": "str", "message": "str", "details": [...]}],
                        "nodeDeallocationOption": "str",
                        "resizeTimeout": "1 day, 0:00:00",
                        "startTime": "2020-02-20 00:00:00",
                        "targetDedicatedNodes": 0,
                        "targetLowPriorityNodes": 0,
                    },
                    "scaleSettings": {
                        "autoScale": {"formula": "str", "evaluationInterval": "1 day, 0:00:00"},
                        "fixedScale": {
                            "nodeDeallocationOption": "str",
                            "resizeTimeout": "1 day, 0:00:00",
                            "targetDedicatedNodes": 0,
                            "targetLowPriorityNodes": 0,
                        },
                    },
                    "startTask": {
                        "commandLine": "str",
                        "containerSettings": {
                            "imageName": "str",
                            "containerHostBatchBindMounts": [{"isReadOnly": bool, "source": "str"}],
                            "containerRunOptions": "str",
                            "registry": {
                                "identityReference": {"resourceId": "str"},
                                "password": "str",
                                "registryServer": "str",
                                "username": "str",
                            },
                            "workingDirectory": "str",
                        },
                        "environmentSettings": [{"name": "str", "value": "str"}],
                        "maxTaskRetryCount": 0,
                        "resourceFiles": [
                            {
                                "autoStorageContainerName": "str",
                                "blobPrefix": "str",
                                "fileMode": "str",
                                "filePath": "str",
                                "httpUrl": "str",
                                "identityReference": {"resourceId": "str"},
                                "storageContainerUrl": "str",
                            }
                        ],
                        "userIdentity": {"autoUser": {"elevationLevel": "str", "scope": "str"}, "userName": "str"},
                        "waitForSuccess": bool,
                    },
                    "taskSchedulingPolicy": {"nodeFillType": "str", "jobDefaultOrder": "str"},
                    "taskSlotsPerNode": 0,
                    "upgradePolicy": {
                        "mode": "str",
                        "automaticOSUpgradePolicy": {
                            "disableAutomaticRollback": bool,
                            "enableAutomaticOSUpgrade": bool,
                            "osRollingUpgradeDeferral": bool,
                            "useRollingUpgradePolicy": bool,
                        },
                        "rollingUpgradePolicy": {
                            "enableCrossZoneUpgrade": bool,
                            "maxBatchInstancePercent": 0,
                            "maxUnhealthyInstancePercent": 0,
                            "maxUnhealthyUpgradedInstancePercent": 0,
                            "pauseTimeBetweenBatches": "str",
                            "prioritizeUnhealthyInstances": bool,
                            "rollbackFailedInstancesOnPolicyBreach": bool,
                        },
                    },
                    "userAccounts": [
                        {
                            "name": "str",
                            "password": "str",
                            "elevationLevel": "str",
                            "linuxUserConfiguration": {"gid": 0, "sshPrivateKey": "str", "uid": 0},
                            "windowsUserConfiguration": {"loginMode": "str"},
                        }
                    ],
                    "vmSize": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_pool_begin_delete(self, resource_group):
        response = await (
            await self.client.pool.begin_delete(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_pool_list_by_batch_account(self, resource_group):
        response = self.client.pool.list_by_batch_account(
            resource_group_name=resource_group.name,
            account_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_pool_disable_auto_scale(self, resource_group):
        response = await self.client.pool.disable_auto_scale(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_pool_stop_resize(self, resource_group):
        response = await self.client.pool.stop_resize(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
        )

        # please add some check logic here by yourself
        # ...
