# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerregistrytasks import ContainerRegistryTasksMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerRegistryTasksMgmtRegistriesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerRegistryTasksMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_registries_schedule_run(self, resource_group):
        response = self.client.registries.schedule_run(
            resource_group_name=resource_group.name,
            registry_name="str",
            run_request={
                "dockerFilePath": "str",
                "platform": {"os": "str", "architecture": "str", "variant": "str"},
                "type": "DockerBuildRequest",
                "agentConfiguration": {"cpu": 0},
                "agentPoolName": "str",
                "arguments": [{"name": "str", "value": "str", "isSecret": bool}],
                "credentials": {
                    "customRegistries": {
                        "str": {
                            "identity": "str",
                            "password": {"type": "str", "value": "str"},
                            "userName": {"type": "str", "value": "str"},
                        }
                    },
                    "sourceRegistry": {"identity": "str", "loginMode": "str"},
                },
                "imageNames": ["str"],
                "isArchiveEnabled": bool,
                "isPushEnabled": bool,
                "logTemplate": "str",
                "noCache": bool,
                "sourceLocation": "str",
                "target": "str",
                "timeout": 0,
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_registries_get_build_source_upload_url(self, resource_group):
        response = self.client.registries.get_build_source_upload_url(
            resource_group_name=resource_group.name,
            registry_name="str",
        )

        # please add some check logic here by yourself
        # ...
