# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AzureMonitorConfiguration(_Model):
    """Configuration for the Azure Monitor Insights service.

    :ivar azure_monitor_workspace_id: Azure monitor workspace resource ID used by the service.
     Required.
    :vartype azure_monitor_workspace_id: str
    """

    azure_monitor_workspace_id: str = rest_field(
        name="azureMonitorWorkspaceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure monitor workspace resource ID used by the service. Required."""

    @overload
    def __init__(
        self,
        *,
        azure_monitor_workspace_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureMonitorInformation(_Model):
    """Azure Monitor Insights service information.

    :ivar dcr_id: ID of Data Collection Rule (DCR) associated with this service. Required.
    :vartype dcr_id: str
    :ivar enablement_status: Indicates whether the service is enabled. Required. Is one of the
     following types: Literal["Enabled"], Literal["InProgress"], Literal["Failed"],
     Literal["Disabled"], str
    :vartype enablement_status: str or str or str or str or str
    """

    dcr_id: str = rest_field(name="dcrId", visibility=["read", "create", "update", "delete", "query"])
    """ID of Data Collection Rule (DCR) associated with this service. Required."""
    enablement_status: Union[Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str] = (
        rest_field(name="enablementStatus", visibility=["read", "create", "update", "delete", "query"])
    )
    """Indicates whether the service is enabled. Required. Is one of the following types:
     Literal[\"Enabled\"], Literal[\"InProgress\"], Literal[\"Failed\"], Literal[\"Disabled\"], str"""

    @overload
    def __init__(
        self,
        *,
        dcr_id: str,
        enablement_status: Union[
            Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str
        ],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ChangeTrackingConfiguration(_Model):
    """Configuration for the Change Tracking and Inventory service.

    :ivar log_analytics_workspace_id: Log analytics workspace resource ID used by the service.
     Required.
    :vartype log_analytics_workspace_id: str
    """

    log_analytics_workspace_id: str = rest_field(
        name="logAnalyticsWorkspaceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Log analytics workspace resource ID used by the service. Required."""

    @overload
    def __init__(
        self,
        *,
        log_analytics_workspace_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ChangeTrackingInformation(_Model):
    """Change Tracking and Inventory service information.

    :ivar dcr_id: ID of Data Collection Rule (DCR) associated with this service. Required.
    :vartype dcr_id: str
    :ivar enablement_status: Indicates whether the service is enabled. Required. Is one of the
     following types: Literal["Enabled"], Literal["InProgress"], Literal["Failed"],
     Literal["Disabled"], str
    :vartype enablement_status: str or str or str or str or str
    """

    dcr_id: str = rest_field(name="dcrId", visibility=["read", "create", "update", "delete", "query"])
    """ID of Data Collection Rule (DCR) associated with this service. Required."""
    enablement_status: Union[Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str] = (
        rest_field(name="enablementStatus", visibility=["read", "create", "update", "delete", "query"])
    )
    """Indicates whether the service is enabled. Required. Is one of the following types:
     Literal[\"Enabled\"], Literal[\"InProgress\"], Literal[\"Failed\"], Literal[\"Disabled\"], str"""

    @overload
    def __init__(
        self,
        *,
        dcr_id: str,
        enablement_status: Union[
            Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str
        ],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DefenderCspmInformation(_Model):
    """Defender Cloud Security Posture Management (CSPM) service information.

    :ivar enablement_status: Indicates whether the service is enabled. Required. Is one of the
     following types: Literal["Enabled"], Literal["InProgress"], Literal["Failed"],
     Literal["Disabled"], str
    :vartype enablement_status: str or str or str or str or str
    """

    enablement_status: Union[Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str] = (
        rest_field(name="enablementStatus", visibility=["read", "create", "update", "delete", "query"])
    )
    """Indicates whether the service is enabled. Required. Is one of the following types:
     Literal[\"Enabled\"], Literal[\"InProgress\"], Literal[\"Failed\"], Literal[\"Disabled\"], str"""

    @overload
    def __init__(
        self,
        *,
        enablement_status: Union[
            Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str
        ],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DefenderForServersInformation(_Model):
    """Defender for Servers service information.

    :ivar enablement_status: Indicates whether the service is enabled. Required. Is one of the
     following types: Literal["Enabled"], Literal["InProgress"], Literal["Failed"],
     Literal["Disabled"], str
    :vartype enablement_status: str or str or str or str or str
    """

    enablement_status: Union[Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str] = (
        rest_field(name="enablementStatus", visibility=["read", "create", "update", "delete", "query"])
    )
    """Indicates whether the service is enabled. Required. Is one of the following types:
     Literal[\"Enabled\"], Literal[\"InProgress\"], Literal[\"Failed\"], Literal[\"Disabled\"], str"""

    @overload
    def __init__(
        self,
        *,
        enablement_status: Union[
            Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str
        ],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DesiredConfiguration(_Model):
    """Desired configuration input by the user.

    :ivar change_tracking_and_inventory: Configuration for the Change Tracking and Inventory
     service. Required.
    :vartype change_tracking_and_inventory:
     ~azure.mgmt.managedops.models.ChangeTrackingConfiguration
    :ivar azure_monitor_insights: Configuration for the Azure Monitor Insights service. Required.
    :vartype azure_monitor_insights: ~azure.mgmt.managedops.models.AzureMonitorConfiguration
    :ivar user_assigned_managed_identity_id: User assigned Managed Identity used to perform
     operations on machines managed by Ops360. Required.
    :vartype user_assigned_managed_identity_id: str
    :ivar defender_for_servers: Desired enablement state of the Defender For Servers service. Is
     one of the following types: Literal["Enable"], Literal["Disable"], str
    :vartype defender_for_servers: str or str or str
    :ivar defender_cspm: Desired enablement state of the Defender Cloud Security Posture Management
     (CSPM) service. Is one of the following types: Literal["Enable"], Literal["Disable"], str
    :vartype defender_cspm: str or str or str
    """

    change_tracking_and_inventory: "_models.ChangeTrackingConfiguration" = rest_field(
        name="changeTrackingAndInventory", visibility=["read", "create"]
    )
    """Configuration for the Change Tracking and Inventory service. Required."""
    azure_monitor_insights: "_models.AzureMonitorConfiguration" = rest_field(
        name="azureMonitorInsights", visibility=["read", "create"]
    )
    """Configuration for the Azure Monitor Insights service. Required."""
    user_assigned_managed_identity_id: str = rest_field(
        name="userAssignedManagedIdentityId", visibility=["read", "create"]
    )
    """User assigned Managed Identity used to perform operations on machines managed by Ops360.
     Required."""
    defender_for_servers: Optional[Union[Literal["Enable"], Literal["Disable"], str]] = rest_field(
        name="defenderForServers", visibility=["read", "create", "update"]
    )
    """Desired enablement state of the Defender For Servers service. Is one of the following types:
     Literal[\"Enable\"], Literal[\"Disable\"], str"""
    defender_cspm: Optional[Union[Literal["Enable"], Literal["Disable"], str]] = rest_field(
        name="defenderCspm", visibility=["read", "create", "update"]
    )
    """Desired enablement state of the Defender Cloud Security Posture Management (CSPM) service. Is
     one of the following types: Literal[\"Enable\"], Literal[\"Disable\"], str"""

    @overload
    def __init__(
        self,
        *,
        change_tracking_and_inventory: "_models.ChangeTrackingConfiguration",
        azure_monitor_insights: "_models.AzureMonitorConfiguration",
        user_assigned_managed_identity_id: str,
        defender_for_servers: Optional[Union[Literal["Enable"], Literal["Disable"], str]] = None,
        defender_cspm: Optional[Union[Literal["Enable"], Literal["Disable"], str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DesiredConfigurationUpdate(_Model):
    """Updatable parameters in the Desired configuration input.

    :ivar defender_for_servers: Desired enablement state of the Defender For Servers service. Is
     one of the following types: Literal["Enable"], Literal["Disable"], str
    :vartype defender_for_servers: str or str or str
    :ivar defender_cspm: Desired enablement state of the Defender Cloud Security Posture Management
     (CSPM) service. Is one of the following types: Literal["Enable"], Literal["Disable"], str
    :vartype defender_cspm: str or str or str
    """

    defender_for_servers: Optional[Union[Literal["Enable"], Literal["Disable"], str]] = rest_field(
        name="defenderForServers", visibility=["read", "create", "update"]
    )
    """Desired enablement state of the Defender For Servers service. Is one of the following types:
     Literal[\"Enable\"], Literal[\"Disable\"], str"""
    defender_cspm: Optional[Union[Literal["Enable"], Literal["Disable"], str]] = rest_field(
        name="defenderCspm", visibility=["read", "create", "update"]
    )
    """Desired enablement state of the Defender Cloud Security Posture Management (CSPM) service. Is
     one of the following types: Literal[\"Enable\"], Literal[\"Disable\"], str"""

    @overload
    def __init__(
        self,
        *,
        defender_for_servers: Optional[Union[Literal["Enable"], Literal["Disable"], str]] = None,
        defender_cspm: Optional[Union[Literal["Enable"], Literal["Disable"], str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.managedops.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.managedops.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.managedops.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GuestConfigurationInformation(_Model):
    """Azure Policy and Machine Configuration service information.

    :ivar enablement_status: Indicates whether the service is enabled. Required. Is one of the
     following types: Literal["Enabled"], Literal["InProgress"], Literal["Failed"],
     Literal["Disabled"], str
    :vartype enablement_status: str or str or str or str or str
    """

    enablement_status: Union[Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str] = (
        rest_field(name="enablementStatus", visibility=["read", "create", "update", "delete", "query"])
    )
    """Indicates whether the service is enabled. Required. Is one of the following types:
     Literal[\"Enabled\"], Literal[\"InProgress\"], Literal[\"Failed\"], Literal[\"Disabled\"], str"""

    @overload
    def __init__(
        self,
        *,
        enablement_status: Union[
            Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str
        ],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managedops.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managedops.models.SystemData
    """


class ManagedOp(ProxyResource):
    """The Managed Operations resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managedops.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.managedops.models.ManagedOpsProperties
    """

    properties: Optional["_models.ManagedOpsProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ManagedOpsProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedOpsProperties(_Model):
    """Properties of the ManagedOps resource.

    :ivar sku: Product plan details of this resource.
    :vartype sku: ~azure.mgmt.managedops.models.Sku
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.managedops.models.ProvisioningState
    :ivar desired_configuration: Desired configuration input by the user. Required.
    :vartype desired_configuration: ~azure.mgmt.managedops.models.DesiredConfiguration
    :ivar services: Services provisioned by this resource.
    :vartype services: ~azure.mgmt.managedops.models.ServiceInformation
    :ivar policy_assignment_properties: Policy assignments created for managing services.
    :vartype policy_assignment_properties: ~azure.mgmt.managedops.models.PolicyAssignmentProperties
    """

    sku: Optional["_models.Sku"] = rest_field(visibility=["read"])
    """Product plan details of this resource."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", and \"Deleting\"."""
    desired_configuration: "_models.DesiredConfiguration" = rest_field(
        name="desiredConfiguration", visibility=["read", "create", "update"]
    )
    """Desired configuration input by the user. Required."""
    services: Optional["_models.ServiceInformation"] = rest_field(visibility=["read"])
    """Services provisioned by this resource."""
    policy_assignment_properties: Optional["_models.PolicyAssignmentProperties"] = rest_field(
        name="policyAssignmentProperties", visibility=["read"]
    )
    """Policy assignments created for managing services."""

    @overload
    def __init__(
        self,
        *,
        desired_configuration: "_models.DesiredConfiguration",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedOpUpdate(_Model):
    """ManagedOps model for update operations.

    :ivar properties: Updatable properties in the ManagedOps resource.
    :vartype properties: ~azure.mgmt.managedops.models.ManagedOpUpdateProperties
    """

    properties: Optional["_models.ManagedOpUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Updatable properties in the ManagedOps resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ManagedOpUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedOpUpdateProperties(_Model):
    """Updatable properties in the ManagedOps resource.

    :ivar desired_configuration: Desired configuration input by the user.
    :vartype desired_configuration: ~azure.mgmt.managedops.models.DesiredConfigurationUpdate
    """

    desired_configuration: Optional["_models.DesiredConfigurationUpdate"] = rest_field(
        name="desiredConfiguration", visibility=["read", "create", "update"]
    )
    """Desired configuration input by the user."""

    @overload
    def __init__(
        self,
        *,
        desired_configuration: Optional["_models.DesiredConfigurationUpdate"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.managedops.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.managedops.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.managedops.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for an operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PolicyAssignmentProperties(_Model):
    """Policy assignments created for managing services.

    :ivar policy_initiative_assignment_id: Policy initiative assignment ID. Required.
    :vartype policy_initiative_assignment_id: str
    """

    policy_initiative_assignment_id: str = rest_field(
        name="policyInitiativeAssignmentId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy initiative assignment ID. Required."""

    @overload
    def __init__(
        self,
        *,
        policy_initiative_assignment_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceInformation(_Model):
    """Services provisioned by this resource.

    :ivar change_tracking_and_inventory: Change Tracking and Inventory service information.
    :vartype change_tracking_and_inventory: ~azure.mgmt.managedops.models.ChangeTrackingInformation
    :ivar azure_monitor_insights: Azure Monitor Insights service information.
    :vartype azure_monitor_insights: ~azure.mgmt.managedops.models.AzureMonitorInformation
    :ivar azure_update_manager: Azure Update Manager service information.
    :vartype azure_update_manager: ~azure.mgmt.managedops.models.UpdateManagerInformation
    :ivar azure_policy_and_machine_configuration: Azure Policy and Machine Configuration service
     information.
    :vartype azure_policy_and_machine_configuration:
     ~azure.mgmt.managedops.models.GuestConfigurationInformation
    :ivar defender_for_servers: Defender for Servers service information.
    :vartype defender_for_servers: ~azure.mgmt.managedops.models.DefenderForServersInformation
    :ivar defender_cspm: Defender for Cloud's Cloud security posture management (CSPM) service
     information.
    :vartype defender_cspm: ~azure.mgmt.managedops.models.DefenderCspmInformation
    """

    change_tracking_and_inventory: Optional["_models.ChangeTrackingInformation"] = rest_field(
        name="changeTrackingAndInventory", visibility=["read"]
    )
    """Change Tracking and Inventory service information."""
    azure_monitor_insights: Optional["_models.AzureMonitorInformation"] = rest_field(
        name="azureMonitorInsights", visibility=["read"]
    )
    """Azure Monitor Insights service information."""
    azure_update_manager: Optional["_models.UpdateManagerInformation"] = rest_field(
        name="azureUpdateManager", visibility=["read"]
    )
    """Azure Update Manager service information."""
    azure_policy_and_machine_configuration: Optional["_models.GuestConfigurationInformation"] = rest_field(
        name="azurePolicyAndMachineConfiguration", visibility=["read"]
    )
    """Azure Policy and Machine Configuration service information."""
    defender_for_servers: Optional["_models.DefenderForServersInformation"] = rest_field(
        name="defenderForServers", visibility=["read"]
    )
    """Defender for Servers service information."""
    defender_cspm: Optional["_models.DefenderCspmInformation"] = rest_field(name="defenderCspm", visibility=["read"])
    """Defender for Cloud's Cloud security posture management (CSPM) service information."""


class Sku(_Model):
    """Specifies the service plan for this resource.

    :ivar name: Name of the SKU. Required.
    :vartype name: str
    :ivar tier: Pricing tier of the SKU. Required.
    :vartype tier: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the SKU. Required."""
    tier: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Pricing tier of the SKU. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        tier: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.managedops.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.managedops.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateManagerInformation(_Model):
    """Azure Update Manager service information.

    :ivar enablement_status: Indicates whether the service is enabled. Required. Is one of the
     following types: Literal["Enabled"], Literal["InProgress"], Literal["Failed"],
     Literal["Disabled"], str
    :vartype enablement_status: str or str or str or str or str
    """

    enablement_status: Union[Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str] = (
        rest_field(name="enablementStatus", visibility=["read", "create", "update", "delete", "query"])
    )
    """Indicates whether the service is enabled. Required. Is one of the following types:
     Literal[\"Enabled\"], Literal[\"InProgress\"], Literal[\"Failed\"], Literal[\"Disabled\"], str"""

    @overload
    def __init__(
        self,
        *,
        enablement_status: Union[
            Literal["Enabled"], Literal["InProgress"], Literal["Failed"], Literal["Disabled"], str
        ],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
