# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.postgresqlflexibleservers import PostgreSQLManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-postgresqlflexibleservers
# USAGE
    python servers_create_with_microsoft_entra_enabled_in_your_own_virtual_network_without_high_availability.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = PostgreSQLManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.servers.begin_create_or_update(
        resource_group_name="exampleresourcegroup",
        server_name="exampleserver",
        parameters={
            "location": "eastus",
            "properties": {
                "administratorLogin": "exampleadministratorlogin",
                "administratorLoginPassword": "examplepassword",
                "authConfig": {
                    "activeDirectoryAuth": "Enabled",
                    "passwordAuth": "Enabled",
                    "tenantId": "tttttt-tttt-tttt-tttt-tttttttttttt",
                },
                "availabilityZone": "1",
                "backup": {"backupRetentionDays": 7, "geoRedundantBackup": "Disabled"},
                "createMode": "Create",
                "dataEncryption": {"type": "SystemManaged"},
                "highAvailability": {"mode": "Disabled"},
                "network": {
                    "delegatedSubnetResourceId": "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/exampleresourcegroup/providers/Microsoft.Network/virtualNetworks/examplevirtualnetwork/subnets/examplesubnet",
                    "privateDnsZoneArmResourceId": "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/exampleresourcegroup/providers/Microsoft.Network/privateDnsZones/exampleprivatednszone.postgres.database.azure.com",
                },
                "storage": {"autoGrow": "Disabled", "storageSizeGB": 512, "tier": "P20"},
                "version": "17",
            },
            "sku": {"name": "Standard_D4ds_v5", "tier": "GeneralPurpose"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2026-01-01-preview/ServersCreateWithMicrosoftEntraEnabledInYourOwnVirtualNetworkWithoutHighAvailability.json
if __name__ == "__main__":
    main()
