# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.deploymentstacks import DeploymentStacksClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDeploymentStacksDeploymentStacksWhatIfResultsAtResourceGroupOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DeploymentStacksClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_deployment_stacks_what_if_results_at_resource_group_get(self, resource_group):
        response = self.client.deployment_stacks_what_if_results_at_resource_group.get(
            resource_group_name=resource_group.name,
            deployment_stacks_what_if_result_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_deployment_stacks_what_if_results_at_resource_group_list(self, resource_group):
        response = self.client.deployment_stacks_what_if_results_at_resource_group.list(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_deployment_stacks_what_if_results_at_resource_group_begin_create_or_update(self, resource_group):
        response = self.client.deployment_stacks_what_if_results_at_resource_group.begin_create_or_update(
            resource_group_name=resource_group.name,
            deployment_stacks_what_if_result_name="str",
            resource={
                "id": "str",
                "location": "str",
                "name": "str",
                "properties": {
                    "actionOnUnmanage": {
                        "resources": "str",
                        "managementGroups": "str",
                        "resourceGroups": "str",
                        "resourcesWithoutDeleteSupport": "str",
                    },
                    "denySettings": {
                        "mode": "str",
                        "applyToChildScopes": bool,
                        "excludedActions": ["str"],
                        "excludedPrincipals": ["str"],
                    },
                    "deploymentStackResourceId": "str",
                    "retentionInterval": "1 day, 0:00:00",
                    "changes": {
                        "denySettingsChange": {
                            "after": {
                                "mode": "str",
                                "applyToChildScopes": bool,
                                "excludedActions": ["str"],
                                "excludedPrincipals": ["str"],
                            },
                            "before": {
                                "mode": "str",
                                "applyToChildScopes": bool,
                                "excludedActions": ["str"],
                                "excludedPrincipals": ["str"],
                            },
                            "delta": [
                                {"changeType": "str", "path": "str", "after": {}, "before": {}, "children": [...]}
                            ],
                        },
                        "resourceChanges": [
                            {
                                "changeCertainty": "str",
                                "changeType": "str",
                                "apiVersion": "str",
                                "denyStatusChange": {"after": "str", "before": "str"},
                                "deploymentId": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "managementStatusChange": {"after": "str", "before": "str"},
                                "resourceConfigurationChanges": {
                                    "after": {"str": {}},
                                    "before": {"str": {}},
                                    "delta": [
                                        {
                                            "changeType": "str",
                                            "path": "str",
                                            "after": {},
                                            "before": {},
                                            "children": [...],
                                        }
                                    ],
                                },
                                "symbolicName": "str",
                                "type": "str",
                                "unsupportedReason": "str",
                            }
                        ],
                        "deploymentScopeChange": {"after": "str", "before": "str"},
                    },
                    "correlationId": "str",
                    "debugSetting": {"detailLevel": "str"},
                    "deploymentScope": "str",
                    "deploymentStackLastModified": "2020-02-20 00:00:00",
                    "description": "str",
                    "diagnostics": [
                        {
                            "code": "str",
                            "level": "str",
                            "message": "str",
                            "additionalInfo": [{"info": {}, "type": "str"}],
                            "target": "str",
                        }
                    ],
                    "error": {
                        "additionalInfo": [{"info": {}, "type": "str"}],
                        "code": "str",
                        "details": [...],
                        "message": "str",
                        "target": "str",
                    },
                    "extensionConfigs": {"str": {}},
                    "externalInputDefinitions": {"str": {"kind": "str", "config": {}}},
                    "externalInputs": {"str": {"value": {}}},
                    "parameters": {
                        "str": {
                            "expression": "str",
                            "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                            "type": "str",
                            "value": {},
                        }
                    },
                    "parametersLink": {"uri": "str", "contentVersion": "str"},
                    "provisioningState": "str",
                    "template": {"str": {}},
                    "templateLink": {
                        "contentVersion": "str",
                        "id": "str",
                        "queryString": "str",
                        "relativePath": "str",
                        "uri": "str",
                    },
                    "validationLevel": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_deployment_stacks_what_if_results_at_resource_group_delete(self, resource_group):
        response = self.client.deployment_stacks_what_if_results_at_resource_group.delete(
            resource_group_name=resource_group.name,
            deployment_stacks_what_if_result_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_deployment_stacks_what_if_results_at_resource_group_begin_what_if(self, resource_group):
        response = self.client.deployment_stacks_what_if_results_at_resource_group.begin_what_if(
            resource_group_name=resource_group.name,
            deployment_stacks_what_if_result_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
