% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A1-R1C1-regex-utils.R
\name{is_A1}
\alias{is_A1}
\alias{is_R1C1}
\title{Test cell reference strings}
\usage{
is_A1(x)

is_R1C1(x)
}
\arguments{
\item{x}{character vector of cell reference strings}
}
\value{
a logical vector
}
\description{
Test cell reference strings for a specific format.
}
\section{Functions}{
\itemize{
\item \code{is_A1}: A1 format, case insenstive; relative, absolute, or mixed

\item \code{is_R1C1}: R1C1 format; relative, absolute, or mixed
}}
\examples{
is_A1("A1")
is_R1C1("A1")
is_R1C1("R4C12")

x <- c("A1", "$A4", "$b$12", "RC1", "R[-4]C9", "R5C3")
data.frame(x, is_A1(x), is_R1C1(x))
}

