% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectations.R
\name{expect_equal_to_reference}
\alias{expect_equal_to_reference}
\alias{expect_equivalent_to_reference}
\title{Compare object with object stored in a file}
\usage{
expect_equal_to_reference(current, file, ...)

expect_equivalent_to_reference(current, file, ...)
}
\arguments{
\item{current}{\code{[R object or expression]} Outcome or expression under 
scrutiny.}

\item{file}{\code{[character]} File where the \code{target} is stored. If 
\code{file} does not exist, \code{current} will be stored there.}

\item{...}{passed to \code{\link{expect_equal}}, respectively \code{\link{expect_equivalent}}.}
}
\description{
Compares the current value with a value stored to file with
\code{\link{saveRDS}}.  If the  file does not exist, the current value is
stored into file, and the test returns \code{expect_null(NULL)}.
}
\note{
Be aware that on CRAN it is not allowed to write data to user space. So make
sure that the file is either stored with your tests, or generated with
\code{\link{tempfile}}, or the test is skipped on CRAN, using
\code{\link{at_home}}.

\code{\link{build_install_test}} clones the package and
builds and tests it in a separate R session in the background. This means
that if you create a file located at \code{tempfile()} during the run, this
file is destroyed when the separate R session is closed.
}
\examples{
filename <- tempfile()
# this gives TRUE: the file does not exist, but is created now.
expect_equal_to_reference(1, file=filename)
# this gives TRUE: the file now exists, and its contents is equal
# to the current value
expect_equal_to_reference(1, file=filename)
# this gives FALSE: the file exists, but is contents is not equal
# to the current value
expect_equal_to_reference(2, file=filename)

}
\seealso{
Other test-functions: 
\code{\link{expect_equal}()},
\code{\link{expect_length}()},
\code{\link{expect_match}()},
\code{\link{ignore}()}
}
\concept{test-functions}
