// SPDX-FileCopyrightText: Heiko Schaefer <heiko@schaefer.name>
// SPDX-License-Identifier: MIT OR Apache-2.0

use std::time::SystemTime;

use pgp::packet::SignatureType;
use pgp::Signature;
use rpgpie::certificate::Certificate;
use rpgpie::message::MessageResult;
use rpgpie::ComponentKeyPub;

pub(crate) fn to_verification(
    signature: &Signature,
    cert: &Certificate,
    key: &ComponentKeyPub,
    source: Option<&str>,
) -> sop::ops::Verification {
    let ct: SystemTime = (*signature.created().expect("FIXME")).into();

    let key_fp = hex::encode(key.fingerprint().as_bytes());
    let cert_fp = hex::encode(cert.fingerprint().as_bytes());

    let mode = match signature.typ() {
        SignatureType::Binary => sop::ops::SignatureMode::Binary,
        SignatureType::Text => sop::ops::SignatureMode::Text,
        _ => panic!("unexpected data signature type"),
    };

    let mut ver = sop::ops::Verification::new(ct, key_fp, cert_fp, mode, None).expect("FIXME");

    if let Some(source) = source {
        ver.add_signer(source);
    }

    ver
}

pub(crate) fn result_to_verifications(mr: &MessageResult) -> Vec<sop::ops::Verification> {
    mr.validated
        .iter()
        // FIXME: add source information if available
        .map(|(cert, key, sig)| to_verification(sig, cert, key, None))
        .collect()
}
