---
myst:
  html_meta:
    keywords: LaTeX, distributions, éditeurs, éditeur LaTeX pour Windows, 
              éditeur LaTeX pour Macintosh
---

# Quels sont les éditeurs et shells adaptés à TeX ?

Il existe de bons environnements et éditeurs TeX pour la plupart des systèmes d'exploitation.
Certains sont décrits ci-dessous, mais il ne s'agit que d'une sélection.

## Unix/Linux

Plusieurs options s'offrent à vous :

- [GNU emacs](http://www.gnu.org/software/emacs/emacs.html) et [XEmacs](http://www.xemacs.org/) 
  sont pris en charge par l'ensemble AUC-TeX (disponible auprès du CTAN). 
  AUC-TeX fournit des éléments de menu et des séquences de contrôle pour les constructions courantes, 
  vérifie la syntaxe, présente joliment les balises, vous permet d'appeler TeX 
  et les pilotes à partir de l'éditeur, et tout ce à quoi vous pouvez penser. 
  Complexe, mais très puissant ;
- [vim](http://vim.sourceforge.net) est également largement configurable. 
  De nombreux plugins sont disponibles pour répondre aux besoins des utilisateurs de (La)TeX, 
  notamment la coloration syntaxique, l'appel de programmes TeX, l'insertion 
  et la complétion automatiques de structures (La)TeX courantes ainsi que la consultation d'aide.
  Les scripts `auctex.vim` et `bibtex.vim` semblent être les recommandations les plus courantes ;
- l'éditeur [NEdit](http://nedit.org/) est également libre et programmable. 
  Il est disponible pour les systèmes Unix. Un ensemble d'extensions AUC-TeX pour `NEdit` 
  est disponible auprès du CTAN ;
- `LaTeX4Jed` fournit un support LaTeX amélioré pour l'éditeur [jed](http://www.jedsoft.org/jed/). 
  `LaTeX4Jed` est similaire à AUC-TeX : menus, raccourcis, modèles, coloration syntaxique, 
  aperçu du document, débogage intégré, complétion de symboles, intégration complète 
  avec des programmes externes, et plus encore. Il a été conçu pour les débutants 
  comme pour les utilisateurs avancés de LaTeX ;
- L'éditeur [Kile](http://kile.sourceforge.net/), fourni avec le gestionnaire de fenêtres KDE, 
  offre des fonctionnalités par interface graphique, d'une manière similaire à `Winedt` 
  (voir ci-dessous) ;
- Le TUG finance le développement d'un éditeur et d'un interpréteur de commandes multiplateforme, 
  sur le modèle de l'excellent TeXshop pour Macintosh. 
  Le résultat, [TeXworks](http://www.tug.org/texworks/), est recommandé : 
  si vous cherchez un environnement de développement (La)TeX, il pourrait vous convenir ; 
- une autre alternative est [TeXstudio](http://texstudio.sourceforge.net/).


## Windows

Là encore, plusieurs options s'offrent à vous :

- `emacs`, `vim`, `TeXworks` et `TeXstudio`, cités ci-dessus sont disponibles 
  pour les systèmes Windows ;
- [WinEdt](https://www.winedt.com/), un shareware, est également très apprécié. 
  Il fournit également un systèpme de ligne de commande pour l'utilisation de TeX 
  et autres programmes connexes, ainsi qu'un éditeur puissant et bien configuré. 
  L'éditeur peut générer sa sortie en UTF-8 (dans une certaine mesure), 
  ce qui est utile pour travailler avec [XeTeX](/1_generalites/glossaire/xetex) 
  et d'autres applications de "nouvelle génération" ;
- `TeXnicCenter` est un système de développement (gratuit) orienté TeX, 
  qui réunit une plate-forme puissante pour exécuter (La)TeX et assimilés 
  avec un éditeur configurable.


## macOS

Voici les principaux logiciels sur ce sujet :

- `vim` est disponible sur les systèmes Macintosh ;
- l'outil gratuit de choix semble être [TeXshop](http://pages.uoregon.edu/koch/texshop/index.html), 
  qui combine un éditeur et un interpréteur de commandes avec une philosophie cohérente 
  de traitement de (La)TeX dans l'environnement OS X. TeXShop est distribué 
  dans le cadre du système MacTeX et sera donc disponible d'emblée sur les machines 
  sur lesquelles MacTeX a été installé ;
- le logiciel commercial `Textures` fournit un excellent environnement Macintosh 
  intégré avec son propre éditeur. 
- plus puissant encore (en tant qu'éditeur) est le shareware `Alpha` 
  qui est suffisamment extensible pour vous permettre d'effectuer presque n'importe 
  quel travail lié à TeX. Il fonctionne également très bien avec OzTeX. 
  Depuis la version 2.2.0 (au moins), `Textures` fonctionne sous macOS/X.


## OS/2, Atari, Amiga, NeXT...

`epmtex` offre un système de ligne de commande spécifique à OS/2.

Les utilisateurs d'Atari, d'Amiga et de NeXT disposent également d'environnements intéressants. 
Les utilisateurs de LaTeX qui recherchent des fonctionnalités similaires 
à celles de `make` devraient consulter la réponse à la question 
"[](/2_programmation/compilation/ecrire_un_makefile_pour_compiler_mon_document_latex)".

Bien que de nombreux éditeurs orientés (La)TeX permettent de travailler sur des fichiers BibTeX, 
il existe de nombreux systèmes qui fournissent un accès spécifique "de type base de données" 
à vos fichiers BibTeX --- consultez ici la question 
"[](/3_composition/annexes/bibliographie/construire_une_bibliographie)".


:::{sources}
[TeX-friendly editors and shells](faquk:FAQ-editors)
:::
