#########################################################################################
# Package        HiPi::Graphics::BitmapFont::SansEPD50
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::SansEPD50;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 50;
my $line_spacing = 0;
my $name = 'Sans 50';
my $space_width = 14;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 4, 
        'xoffset'  => 6, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 12, 
        'xoffset'  => 4, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 29, 
        'xoffset'  => 3, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0E, 0x07, 0x80, ##              000      0000    
            0x00, 0x0E, 0x07, 0x80, ##              000      0000    
            0x00, 0x1E, 0x07, 0x00, ##             0000      000     
            0x00, 0x1C, 0x07, 0x00, ##             000       000     
            0x00, 0x1C, 0x0F, 0x00, ##             000      0000     
            0x00, 0x1C, 0x0F, 0x00, ##             000      0000     
            0x00, 0x3C, 0x0E, 0x00, ##            0000      000      
            0x00, 0x38, 0x0E, 0x00, ##            000       000      
            0x00, 0x38, 0x1E, 0x00, ##            000      0000      
            0x3F, 0xFF, 0xFF, 0xF8, ##    000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xF8, ##    000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xF8, ##    000000000000000000000000000
            0x00, 0x70, 0x3C, 0x00, ##           000      0000       
            0x00, 0xF0, 0x3C, 0x00, ##          0000      0000       
            0x00, 0xF0, 0x38, 0x00, ##          0000      000        
            0x00, 0xE0, 0x38, 0x00, ##          000       000        
            0x00, 0xE0, 0x78, 0x00, ##          000      0000        
            0x01, 0xE0, 0x78, 0x00, ##         0000      0000        
            0x01, 0xE0, 0x70, 0x00, ##         0000      000         
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000  
            0x03, 0xC0, 0xE0, 0x00, ##        0000      000          
            0x03, 0x80, 0xE0, 0x00, ##        000       000          
            0x03, 0x81, 0xE0, 0x00, ##        000      0000          
            0x07, 0x81, 0xE0, 0x00, ##       0000      0000          
            0x07, 0x81, 0xC0, 0x00, ##       0000      000           
            0x07, 0x01, 0xC0, 0x00, ##       000       000           
            0x07, 0x03, 0xC0, 0x00, ##       000      0000           
            0x0F, 0x03, 0xC0, 0x00, ##      0000      0000           
            0x0F, 0x03, 0x80, 0x00, ##      0000      000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x07, 0xFF, 0x00, ##       00000000000    
            0x1F, 0xFF, 0xC0, ##     000000000000000  
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x7E, 0x61, 0xC0, ##   000000  00    000  
            0x78, 0x60, 0x40, ##   0000    00      0  
            0xF0, 0x60, 0x00, ##  0000     00         
            0xF0, 0x60, 0x00, ##  0000     00         
            0xF0, 0x60, 0x00, ##  0000     00         
            0xF0, 0x60, 0x00, ##  0000     00         
            0xF8, 0x60, 0x00, ##  00000    00         
            0x7C, 0x60, 0x00, ##   00000   00         
            0x7F, 0x60, 0x00, ##   0000000 00         
            0x3F, 0xF8, 0x00, ##    00000000000       
            0x1F, 0xFF, 0x00, ##     0000000000000    
            0x03, 0xFF, 0x80, ##        00000000000   
            0x00, 0x7F, 0xC0, ##           000000000  
            0x00, 0x67, 0xE0, ##           00  000000 
            0x00, 0x61, 0xF0, ##           00    00000
            0x00, 0x60, 0xF0, ##           00     0000
            0x00, 0x60, 0xF0, ##           00     0000
            0x00, 0x60, 0xF0, ##           00     0000
            0x00, 0x60, 0xF0, ##           00     0000
            0x00, 0x61, 0xF0, ##           00    00000
            0xC0, 0x61, 0xE0, ##  00       00    0000 
            0xF8, 0x67, 0xE0, ##  00000    00  000000 
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0x7F, 0xFF, 0x80, ##   0000000000000000   
            0x0F, 0xFE, 0x00, ##      00000000000     
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 36, 
        'xoffset'  => 2, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x38, 0x00, ##                            000       
            0x0F, 0xE0, 0x00, 0x78, 0x00, ##      0000000              0000       
            0x3F, 0xF8, 0x00, 0x70, 0x00, ##    00000000000            000        
            0x7F, 0xFC, 0x00, 0xE0, 0x00, ##   0000000000000          000         
            0x78, 0x3C, 0x00, 0xE0, 0x00, ##   0000     0000          000         
            0xF8, 0x3E, 0x01, 0xC0, 0x00, ##  00000     00000        000          
            0xF0, 0x1E, 0x03, 0xC0, 0x00, ##  0000       0000       0000          
            0xF0, 0x1E, 0x03, 0x80, 0x00, ##  0000       0000       000           
            0xF0, 0x1E, 0x07, 0x00, 0x00, ##  0000       0000      000            
            0xF0, 0x1E, 0x07, 0x00, 0x00, ##  0000       0000      000            
            0xF0, 0x1E, 0x0E, 0x00, 0x00, ##  0000       0000     000             
            0xF0, 0x1E, 0x1E, 0x00, 0x00, ##  0000       0000    0000             
            0x78, 0x3C, 0x1C, 0x00, 0x00, ##   0000     0000     000              
            0x7C, 0x7C, 0x38, 0x00, 0x00, ##   00000   00000    000               
            0x3F, 0xF8, 0x38, 0x00, 0x00, ##    00000000000     000               
            0x1F, 0xF0, 0x70, 0x3E, 0x00, ##     000000000     000      00000     
            0x07, 0xC0, 0xF0, 0xFF, 0x80, ##       00000      0000    000000000   
            0x00, 0x00, 0xE1, 0xFF, 0xC0, ##                  000    00000000000  
            0x00, 0x01, 0xC3, 0xE3, 0xE0, ##                 000    00000   00000 
            0x00, 0x01, 0xC3, 0xC1, 0xE0, ##                 000    0000     0000 
            0x00, 0x03, 0x87, 0x80, 0xF0, ##                000    0000       0000
            0x00, 0x07, 0x87, 0x80, 0xF0, ##               0000    0000       0000
            0x00, 0x07, 0x07, 0x80, 0xF0, ##               000     0000       0000
            0x00, 0x0E, 0x07, 0x80, 0xF0, ##              000      0000       0000
            0x00, 0x0E, 0x07, 0x80, 0xF0, ##              000      0000       0000
            0x00, 0x1C, 0x07, 0x80, 0xF0, ##             000       0000       0000
            0x00, 0x3C, 0x07, 0x80, 0xF0, ##            0000       0000       0000
            0x00, 0x38, 0x03, 0xC1, 0xE0, ##            000         0000     0000 
            0x00, 0x70, 0x03, 0xC1, 0xE0, ##           000          0000     0000 
            0x00, 0x70, 0x03, 0xFF, 0xC0, ##           000          000000000000  
            0x00, 0xE0, 0x01, 0xFF, 0xC0, ##          000            00000000000  
            0x01, 0xE0, 0x00, 0x7F, 0x00, ##         0000              0000000    
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 29, 
        'xoffset'  => 3, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0xFF, 0xC0, 0x00, ##          0000000000           
            0x03, 0xFF, 0xE0, 0x00, ##        0000000000000          
            0x07, 0xFF, 0xE0, 0x00, ##       00000000000000          
            0x07, 0xC0, 0x60, 0x00, ##       00000       00          
            0x0F, 0x80, 0x00, 0x00, ##      00000                    
            0x0F, 0x00, 0x00, 0x00, ##      0000                     
            0x0F, 0x00, 0x00, 0x00, ##      0000                     
            0x0F, 0x00, 0x00, 0x00, ##      0000                     
            0x0F, 0x00, 0x00, 0x00, ##      0000                     
            0x07, 0x80, 0x00, 0x00, ##       0000                    
            0x07, 0xC0, 0x00, 0x00, ##       00000                   
            0x03, 0xE0, 0x00, 0x00, ##        00000                  
            0x07, 0xF0, 0x00, 0x00, ##       0000000                 
            0x0F, 0xF8, 0x00, 0x00, ##      000000000                
            0x1F, 0xFC, 0x00, 0xF0, ##     00000000000          0000 
            0x3E, 0x7C, 0x00, 0xF0, ##    00000  00000          0000 
            0x7C, 0x3E, 0x00, 0xF0, ##   00000    00000         0000 
            0x78, 0x1F, 0x00, 0xE0, ##   0000      00000        000  
            0xF8, 0x0F, 0x81, 0xE0, ##  00000       00000      0000  
            0xF0, 0x07, 0xC1, 0xE0, ##  0000         00000     0000  
            0xF0, 0x03, 0xE1, 0xC0, ##  0000          00000    000   
            0xF0, 0x01, 0xF3, 0xC0, ##  0000           00000  0000   
            0xF0, 0x00, 0xFF, 0x80, ##  0000            000000000    
            0xF0, 0x00, 0x7F, 0x80, ##  0000             00000000    
            0xF8, 0x00, 0x3F, 0x00, ##  00000             000000     
            0x78, 0x00, 0x1F, 0x00, ##   0000              00000     
            0x7C, 0x00, 0x3F, 0x80, ##   00000            0000000    
            0x3F, 0x00, 0xFF, 0xC0, ##    000000        0000000000   
            0x1F, 0xFF, 0xFF, 0xE0, ##     000000000000000000000000  
            0x0F, 0xFF, 0xE1, 0xF0, ##      000000000000000    00000 
            0x03, 0xFF, 0x80, 0xF8, ##        00000000000       00000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 4, 
        'xoffset'  => 4, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 10, 
        'xoffset'  => 4, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x80, ##        000 
            0x07, 0x80, ##       0000 
            0x07, 0x00, ##       000  
            0x0F, 0x00, ##      0000  
            0x0E, 0x00, ##      000   
            0x1E, 0x00, ##     0000   
            0x1C, 0x00, ##     000    
            0x3C, 0x00, ##    0000    
            0x3C, 0x00, ##    0000    
            0x38, 0x00, ##    000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0x70, 0x00, ##   000      
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x38, 0x00, ##    000     
            0x3C, 0x00, ##    0000    
            0x3C, 0x00, ##    0000    
            0x1C, 0x00, ##     000    
            0x1E, 0x00, ##     0000   
            0x0E, 0x00, ##      000   
            0x0F, 0x00, ##      0000  
            0x07, 0x00, ##       000  
            0x07, 0x80, ##       0000 
            0x03, 0x80, ##        000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 10, 
        'xoffset'  => 3, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x70, 0x00, ##   000      
            0x78, 0x00, ##   0000     
            0x38, 0x00, ##    000     
            0x3C, 0x00, ##    0000    
            0x1C, 0x00, ##     000    
            0x1E, 0x00, ##     0000   
            0x0E, 0x00, ##      000   
            0x0F, 0x00, ##      0000  
            0x0F, 0x00, ##      0000  
            0x07, 0x00, ##       000  
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x03, 0x80, ##        000 
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0x80, ##        000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x00, ##       000  
            0x0F, 0x00, ##      0000  
            0x0F, 0x00, ##      0000  
            0x0E, 0x00, ##      000   
            0x1E, 0x00, ##     0000   
            0x1C, 0x00, ##     000    
            0x3C, 0x00, ##    0000    
            0x38, 0x00, ##    000     
            0x78, 0x00, ##   0000     
            0x70, 0x00, ##   000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 18, 
        'xoffset'  => 2, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0xE0, 0xC1, 0xC0, ##  000     00     000
            0xF0, 0xC3, 0xC0, ##  0000    00    0000
            0x3C, 0xCF, 0x00, ##    0000  00  0000  
            0x1F, 0xFE, 0x00, ##     000000000000   
            0x07, 0xF8, 0x00, ##       00000000     
            0x01, 0xE0, 0x00, ##         0000       
            0x07, 0xF8, 0x00, ##       00000000     
            0x1F, 0xFE, 0x00, ##     000000000000   
            0x3C, 0xCF, 0x00, ##    0000  00  0000  
            0xF0, 0xC3, 0xC0, ##  0000    00    0000
            0xE0, 0xC1, 0xC0, ##  000     00     000
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0xC0, 0x00, ##          00        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 6, 
        'xoffset'  => 3, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x78, ##   0000 
            0x78, ##   0000 
            0x70, ##   000  
            0x70, ##   000  
            0xE0, ##  000   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 4, 
        'xoffset'  => 5, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x1C, ##             000
            0x00, 0x3C, ##            0000
            0x00, 0x3C, ##            0000
            0x00, 0x38, ##            000 
            0x00, 0x38, ##            000 
            0x00, 0x78, ##           0000 
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x00, 0xF0, ##          0000  
            0x00, 0xF0, ##          0000  
            0x00, 0xE0, ##          000   
            0x01, 0xE0, ##         0000   
            0x01, 0xE0, ##         0000   
            0x01, 0xC0, ##         000    
            0x03, 0xC0, ##        0000    
            0x03, 0xC0, ##        0000    
            0x03, 0x80, ##        000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x0F, 0x00, ##      0000      
            0x0E, 0x00, ##      000       
            0x0E, 0x00, ##      000       
            0x1E, 0x00, ##     0000       
            0x1E, 0x00, ##     0000       
            0x1C, 0x00, ##     000        
            0x3C, 0x00, ##    0000        
            0x3C, 0x00, ##    0000        
            0x38, 0x00, ##    000         
            0x78, 0x00, ##   0000         
            0x78, 0x00, ##   0000         
            0x70, 0x00, ##   000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 22, 
        'xoffset'  => 3, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x07, 0xFF, 0x80, ##       000000000000     
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0x70, 0x00, 0x78, ##   000             0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x07, 0xFF, 0x80, ##       000000000000     
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 18, 
        'xoffset'  => 5, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0xE0, 0x00, ##       000000       
            0xFF, 0xE0, 0x00, ##  00000000000       
            0xFF, 0xE0, 0x00, ##  00000000000       
            0xFF, 0xE0, 0x00, ##  00000000000       
            0xF1, 0xE0, 0x00, ##  0000   0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0x01, 0xE0, 0x00, ##         0000       
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x3F, 0xFE, 0x00, ##    0000000000000     
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0xF0, 0x07, 0xC0, ##  0000         00000  
            0xC0, 0x01, 0xE0, ##  00             0000 
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x03, 0xE0, ##                00000 
            0x00, 0x07, 0xC0, ##               00000  
            0x00, 0x0F, 0x80, ##              00000   
            0x00, 0x1F, 0x00, ##             00000    
            0x00, 0x3F, 0x00, ##            000000    
            0x00, 0x7E, 0x00, ##           000000     
            0x00, 0xFC, 0x00, ##          000000      
            0x01, 0xF8, 0x00, ##         000000       
            0x03, 0xF0, 0x00, ##        000000        
            0x07, 0xE0, 0x00, ##       000000         
            0x0F, 0xC0, 0x00, ##      000000          
            0x1F, 0x80, 0x00, ##     000000           
            0x3F, 0x00, 0x00, ##    000000            
            0x7E, 0x00, 0x00, ##   000000             
            0xFC, 0x00, 0x00, ##  000000              
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x7F, 0xFC, 0x00, ##   0000000000000      
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFF, 0x80, ##  00000000000000000   
            0xC0, 0x07, 0xC0, ##  00           00000  
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x0F, 0x80, ##              00000   
            0x07, 0xFE, 0x00, ##       0000000000     
            0x07, 0xFC, 0x00, ##       000000000      
            0x07, 0xFF, 0x00, ##       00000000000    
            0x00, 0x0F, 0xC0, ##              000000  
            0x00, 0x03, 0xE0, ##                00000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x03, 0xE0, ##                00000 
            0xC0, 0x07, 0xC0, ##  00           00000  
            0xFF, 0xFF, 0x80, ##  00000000000000000   
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0x7F, 0xFC, 0x00, ##   0000000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 23, 
        'xoffset'  => 2, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xC0, ##               00000     
            0x00, 0x0F, 0xC0, ##              000000     
            0x00, 0x1F, 0xC0, ##             0000000     
            0x00, 0x1F, 0xC0, ##             0000000     
            0x00, 0x3B, 0xC0, ##            000 0000     
            0x00, 0x7B, 0xC0, ##           0000 0000     
            0x00, 0x73, 0xC0, ##           000  0000     
            0x00, 0xF3, 0xC0, ##          0000  0000     
            0x01, 0xE3, 0xC0, ##         0000   0000     
            0x01, 0xC3, 0xC0, ##         000    0000     
            0x03, 0xC3, 0xC0, ##        0000    0000     
            0x07, 0x83, 0xC0, ##       0000     0000     
            0x07, 0x03, 0xC0, ##       000      0000     
            0x0F, 0x03, 0xC0, ##      0000      0000     
            0x1E, 0x03, 0xC0, ##     0000       0000     
            0x1C, 0x03, 0xC0, ##     000        0000     
            0x3C, 0x03, 0xC0, ##    0000        0000     
            0x78, 0x03, 0xC0, ##   0000         0000     
            0x70, 0x03, 0xC0, ##   000          0000     
            0xF0, 0x03, 0xC0, ##  0000          0000     
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0x00, 0x03, 0xC0, ##                0000     
            0x00, 0x03, 0xC0, ##                0000     
            0x00, 0x03, 0xC0, ##                0000     
            0x00, 0x03, 0xC0, ##                0000     
            0x00, 0x03, 0xC0, ##                0000     
            0x00, 0x03, 0xC0, ##                0000     
            0x00, 0x03, 0xC0, ##                0000     
            0x00, 0x03, 0xC0, ##                0000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xC0, ##   00000000000000000  
            0x7F, 0xFF, 0xC0, ##   00000000000000000  
            0x7F, 0xFF, 0xC0, ##   00000000000000000  
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x78, 0x00, 0x00, ##   0000               
            0x7F, 0xF8, 0x00, ##   000000000000       
            0x7F, 0xFE, 0x00, ##   00000000000000     
            0x7F, 0xFF, 0x80, ##   0000000000000000   
            0x70, 0x1F, 0xC0, ##   000       0000000  
            0x00, 0x07, 0xC0, ##               00000  
            0x00, 0x03, 0xE0, ##                00000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x03, 0xE0, ##                00000 
            0xC0, 0x0F, 0xC0, ##  00          000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000   
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFC, 0x00, ##  00000000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 22, 
        'xoffset'  => 3, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0x00, 0xFF, 0xF0, ##          000000000000  
            0x03, 0xFF, 0xF0, ##        00000000000000  
            0x07, 0xFF, 0xF0, ##       000000000000000  
            0x0F, 0x80, 0x10, ##      00000          0  
            0x1E, 0x00, 0x00, ##     0000               
            0x3C, 0x00, 0x00, ##    0000                
            0x38, 0x00, 0x00, ##    000                 
            0x78, 0x00, 0x00, ##   0000                 
            0x78, 0x00, 0x00, ##   0000                 
            0x70, 0x00, 0x00, ##   000                  
            0xF0, 0xFE, 0x00, ##  0000    0000000       
            0xF3, 0xFF, 0x80, ##  0000  00000000000     
            0xF7, 0xFF, 0xE0, ##  0000 00000000000000   
            0xFF, 0x83, 0xF0, ##  000000000     000000  
            0xFE, 0x00, 0xF0, ##  0000000         0000  
            0xFC, 0x00, 0xF8, ##  000000          00000 
            0xF8, 0x00, 0x78, ##  00000            0000 
            0xF8, 0x00, 0x3C, ##  00000             0000
            0xF8, 0x00, 0x3C, ##  00000             0000
            0xF8, 0x00, 0x3C, ##  00000             0000
            0xF8, 0x00, 0x3C, ##  00000             0000
            0x78, 0x00, 0x3C, ##   0000             0000
            0x78, 0x00, 0x3C, ##   0000             0000
            0x78, 0x00, 0x3C, ##   0000             0000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0x78, ##    0000           0000 
            0x3C, 0x00, 0xF8, ##    0000          00000 
            0x1F, 0x01, 0xF0, ##     00000       00000  
            0x0F, 0xFF, 0xE0, ##      000000000000000   
            0x07, 0xFF, 0xC0, ##       0000000000000    
            0x01, 0xFF, 0x00, ##         000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x03, 0xE0, ##                00000 
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x07, 0xC0, ##               00000  
            0x00, 0x07, 0x80, ##               0000   
            0x00, 0x0F, 0x80, ##              00000   
            0x00, 0x0F, 0x80, ##              00000   
            0x00, 0x0F, 0x00, ##              0000    
            0x00, 0x1F, 0x00, ##             00000    
            0x00, 0x1E, 0x00, ##             0000     
            0x00, 0x1E, 0x00, ##             0000     
            0x00, 0x3E, 0x00, ##            00000     
            0x00, 0x3C, 0x00, ##            0000      
            0x00, 0x7C, 0x00, ##           00000      
            0x00, 0x7C, 0x00, ##           00000      
            0x00, 0x78, 0x00, ##           0000       
            0x00, 0xF8, 0x00, ##          00000       
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xF0, 0x00, ##         00000        
            0x01, 0xE0, 0x00, ##         0000         
            0x03, 0xE0, 0x00, ##        00000         
            0x03, 0xC0, 0x00, ##        0000          
            0x03, 0xC0, 0x00, ##        0000          
            0x07, 0xC0, 0x00, ##       00000          
            0x07, 0x80, 0x00, ##       0000           
            0x0F, 0x80, 0x00, ##      00000           
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0x03, 0xFF, 0x00, ##        0000000000     
            0x0F, 0xFF, 0xC0, ##      00000000000000   
            0x1F, 0xFF, 0xE0, ##     0000000000000000  
            0x3E, 0x01, 0xF0, ##    00000        00000 
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x78, 0x00, 0x78, ##   0000            0000
            0x78, 0x00, 0x78, ##   0000            0000
            0x78, 0x00, 0x78, ##   0000            0000
            0x78, 0x00, 0x78, ##   0000            0000
            0x78, 0x00, 0x78, ##   0000            0000
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x1F, 0x03, 0xE0, ##     00000      00000  
            0x0F, 0xFF, 0xC0, ##      00000000000000   
            0x01, 0xFF, 0x00, ##         000000000     
            0x0F, 0xFF, 0xC0, ##      00000000000000   
            0x1F, 0x07, 0xE0, ##     00000     000000  
            0x3C, 0x01, 0xF0, ##    0000         00000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF8, 0x00, 0xF8, ##  00000           00000
            0x78, 0x00, 0xF0, ##   0000           0000 
            0x7E, 0x03, 0xF0, ##   000000       000000 
            0x3F, 0xFF, 0xE0, ##    00000000000000000  
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x07, 0xFF, 0x00, ##       00000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0x07, 0xFE, 0x00, ##       0000000000      
            0x0F, 0xFF, 0x00, ##      000000000000     
            0x1F, 0xFF, 0x80, ##     00000000000000    
            0x3E, 0x03, 0xC0, ##    00000       0000   
            0x7C, 0x01, 0xE0, ##   00000         0000  
            0x78, 0x01, 0xE0, ##   0000          0000  
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xF0, 0x00, 0xF0, ##  0000            0000 
            0xF0, 0x00, 0xF0, ##  0000            0000 
            0xF0, 0x00, 0xF0, ##  0000            0000 
            0xF0, 0x00, 0xF8, ##  0000            00000
            0xF0, 0x00, 0xF8, ##  0000            00000
            0xF0, 0x00, 0xF8, ##  0000            00000
            0xF8, 0x00, 0xF8, ##  00000           00000
            0x78, 0x01, 0xF8, ##   0000          000000
            0x7C, 0x03, 0xF8, ##   00000        0000000
            0x3F, 0x07, 0xF8, ##    000000     00000000
            0x1F, 0xFF, 0x78, ##     0000000000000 0000
            0x0F, 0xFE, 0x78, ##      00000000000  0000
            0x03, 0xF8, 0x78, ##        0000000    0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0xF0, ##                  0000 
            0x00, 0x00, 0xF0, ##                  0000 
            0x00, 0x00, 0xF0, ##                  0000 
            0x00, 0x01, 0xE0, ##                 0000  
            0x00, 0x01, 0xE0, ##                 0000  
            0x00, 0x03, 0xC0, ##                0000   
            0x20, 0x07, 0x80, ##    0          0000    
            0x3F, 0xFF, 0x00, ##    00000000000000     
            0x3F, 0xFE, 0x00, ##    0000000000000      
            0x3F, 0xF8, 0x00, ##    00000000000        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 4, 
        'xoffset'  => 5, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 6, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x3C, ##    0000
            0x78, ##   0000 
            0x78, ##   0000 
            0x70, ##   000  
            0x70, ##   000  
            0xE0, ##  000   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x20, ##                            0
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000
            0x00, 0x00, 0x3F, 0xE0, ##                    000000000
            0x00, 0x01, 0xFF, 0x80, ##                 0000000000  
            0x00, 0x0F, 0xFC, 0x00, ##              0000000000     
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000       
            0x03, 0xFF, 0x80, 0x00, ##        00000000000          
            0x0F, 0xFC, 0x00, 0x00, ##      0000000000             
            0x7F, 0xE0, 0x00, 0x00, ##   0000000000                
            0xFF, 0x00, 0x00, 0x00, ##  00000000                   
            0xF8, 0x00, 0x00, 0x00, ##  00000                      
            0xFF, 0x00, 0x00, 0x00, ##  00000000                   
            0x7F, 0xE0, 0x00, 0x00, ##   0000000000                
            0x1F, 0xFC, 0x00, 0x00, ##     00000000000             
            0x03, 0xFF, 0x00, 0x00, ##        0000000000           
            0x00, 0x7F, 0xE0, 0x00, ##           0000000000        
            0x00, 0x0F, 0xFC, 0x00, ##              0000000000     
            0x00, 0x03, 0xFF, 0x80, ##                00000000000  
            0x00, 0x00, 0x7F, 0xE0, ##                   0000000000
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x00, 0x20, ##                            0
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x80, 0x00, 0x00, 0x00, ##  0                          
            0xF0, 0x00, 0x00, 0x00, ##  0000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                    
            0xFF, 0x80, 0x00, 0x00, ##  000000000                  
            0x3F, 0xF0, 0x00, 0x00, ##    0000000000               
            0x07, 0xFE, 0x00, 0x00, ##       0000000000            
            0x01, 0xFF, 0xC0, 0x00, ##         00000000000         
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000      
            0x00, 0x07, 0xFE, 0x00, ##               0000000000    
            0x00, 0x00, 0xFF, 0xC0, ##                  0000000000 
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x07, 0xE0, ##                       000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0xFF, 0xC0, ##                  0000000000 
            0x00, 0x07, 0xFF, 0x00, ##               00000000000   
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000      
            0x00, 0xFF, 0xC0, 0x00, ##          0000000000         
            0x07, 0xFE, 0x00, 0x00, ##       0000000000            
            0x3F, 0xF8, 0x00, 0x00, ##    00000000000              
            0xFF, 0xC0, 0x00, 0x00, ##  0000000000                 
            0xFE, 0x00, 0x00, 0x00, ##  0000000                    
            0xF0, 0x00, 0x00, 0x00, ##  0000                       
            0x80, 0x00, 0x00, 0x00, ##  0                          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 16, 
        'xoffset'  => 3, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##                  
            0x3F, 0xF0, ##    0000000000    
            0xFF, 0xFC, ##  00000000000000  
            0xFF, 0xFE, ##  000000000000000 
            0xE0, 0x3E, ##  000       00000 
            0x80, 0x1F, ##  0          00000
            0x00, 0x0F, ##              0000
            0x00, 0x0F, ##              0000
            0x00, 0x0F, ##              0000
            0x00, 0x0F, ##              0000
            0x00, 0x1E, ##             0000 
            0x00, 0x3E, ##            00000 
            0x00, 0x7C, ##           00000  
            0x00, 0xF8, ##          00000   
            0x01, 0xF0, ##         00000    
            0x03, 0xE0, ##        00000     
            0x03, 0xE0, ##        00000     
            0x07, 0xC0, ##       00000      
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x07, 0x80, ##       0000       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 37, 
        'xoffset'  => 3, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0x00, 0x00, ##                 000000000             
            0x00, 0x0F, 0xFF, 0xE0, 0x00, ##              000000000000000          
            0x00, 0x7F, 0xFF, 0xF8, 0x00, ##           00000000000000000000        
            0x00, 0xFE, 0x01, 0xFC, 0x00, ##          0000000        0000000       
            0x01, 0xF0, 0x00, 0x3E, 0x00, ##         00000              00000      
            0x03, 0xC0, 0x00, 0x0F, 0x00, ##        0000                  0000     
            0x07, 0x80, 0x00, 0x07, 0x80, ##       0000                    0000    
            0x0F, 0x00, 0x00, 0x03, 0xC0, ##      0000                      0000   
            0x1E, 0x00, 0x00, 0x01, 0xE0, ##     0000                        0000  
            0x3C, 0x00, 0x00, 0x00, 0xE0, ##    0000                          000  
            0x38, 0x03, 0xF8, 0x00, 0xF0, ##    000         0000000           0000 
            0x78, 0x07, 0xFE, 0xF0, 0x70, ##   0000        0000000000 0000     000 
            0x70, 0x1F, 0xFF, 0xF0, 0x70, ##   000       00000000000000000     000 
            0x70, 0x1F, 0x07, 0xF0, 0x38, ##   000       00000     0000000      000
            0x70, 0x3E, 0x03, 0xF0, 0x38, ##   000      00000       000000      000
            0xE0, 0x3C, 0x01, 0xF0, 0x38, ##  000       0000         00000      000
            0xE0, 0x78, 0x01, 0xF0, 0x38, ##  000      0000          00000      000
            0xE0, 0x78, 0x00, 0xF0, 0x38, ##  000      0000           0000      000
            0xE0, 0x78, 0x00, 0xF0, 0x38, ##  000      0000           0000      000
            0xE0, 0x78, 0x00, 0xF0, 0x38, ##  000      0000           0000      000
            0xE0, 0x78, 0x00, 0xF0, 0x38, ##  000      0000           0000      000
            0xE0, 0x78, 0x00, 0xF0, 0x70, ##  000      0000           0000     000 
            0xE0, 0x78, 0x00, 0xF0, 0x70, ##  000      0000           0000     000 
            0xF0, 0x3C, 0x01, 0xF0, 0xE0, ##  0000      0000         00000    000  
            0x70, 0x3E, 0x03, 0xF1, 0xE0, ##   000      00000       000000   0000  
            0x70, 0x1F, 0x07, 0xF3, 0xC0, ##   000       00000     0000000  0000   
            0x78, 0x1F, 0xFF, 0xFF, 0x80, ##   0000      0000000000000000000000    
            0x38, 0x07, 0xFE, 0xFE, 0x00, ##    000        0000000000 0000000      
            0x3C, 0x03, 0xF8, 0xF8, 0x00, ##    0000        0000000   00000        
            0x1E, 0x00, 0x00, 0x00, 0x00, ##     0000                              
            0x0F, 0x00, 0x00, 0x00, 0x00, ##      0000                             
            0x0F, 0x80, 0x00, 0x00, 0x00, ##      00000                            
            0x07, 0xC0, 0x00, 0x0C, 0x00, ##       00000                  00       
            0x03, 0xF0, 0x00, 0x3E, 0x00, ##        000000              00000      
            0x00, 0xFE, 0x01, 0xFC, 0x00, ##          0000000        0000000       
            0x00, 0x7F, 0xFF, 0xF8, 0x00, ##           00000000000000000000        
            0x00, 0x1F, 0xFF, 0xE0, 0x00, ##             0000000000000000          
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000              
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 29, 
        'xoffset'  => 0, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0x80, 0x00, ##              00000            
            0x00, 0x0F, 0xC0, 0x00, ##              000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xE0, 0x00, ##             00000000          
            0x00, 0x3D, 0xE0, 0x00, ##            0000 0000          
            0x00, 0x3D, 0xF0, 0x00, ##            0000 00000         
            0x00, 0x7C, 0xF0, 0x00, ##           00000  0000         
            0x00, 0x78, 0xF0, 0x00, ##           0000   0000         
            0x00, 0x78, 0x78, 0x00, ##           0000    0000        
            0x00, 0xF0, 0x78, 0x00, ##          0000     0000        
            0x00, 0xF0, 0x7C, 0x00, ##          0000     00000       
            0x01, 0xF0, 0x3C, 0x00, ##         00000      0000       
            0x01, 0xE0, 0x3C, 0x00, ##         0000       0000       
            0x01, 0xE0, 0x3E, 0x00, ##         0000       00000      
            0x03, 0xE0, 0x1E, 0x00, ##        00000        0000      
            0x03, 0xC0, 0x1E, 0x00, ##        0000         0000      
            0x03, 0xC0, 0x0F, 0x00, ##        0000          0000     
            0x07, 0xC0, 0x0F, 0x00, ##       00000          0000     
            0x07, 0x80, 0x0F, 0x80, ##       0000           00000    
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000    
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000    
            0x0F, 0xFF, 0xFF, 0xC0, ##      0000000000000000000000   
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x1E, 0x00, 0x03, 0xE0, ##     0000               00000  
            0x3E, 0x00, 0x01, 0xE0, ##    00000                0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xF0, ##    0000                 00000 
            0x7C, 0x00, 0x00, 0xF0, ##   00000                  0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF8, ##   0000                   00000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 22, 
        'xoffset'  => 4, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFE, 0x00, ##  000000000000000       
            0xFF, 0xFF, 0xC0, ##  000000000000000000    
            0xFF, 0xFF, 0xE0, ##  0000000000000000000   
            0xF0, 0x03, 0xF0, ##  0000          000000  
            0xF0, 0x00, 0xF0, ##  0000            0000  
            0xF0, 0x00, 0xF8, ##  0000            00000 
            0xF0, 0x00, 0x78, ##  0000             0000 
            0xF0, 0x00, 0x78, ##  0000             0000 
            0xF0, 0x00, 0x78, ##  0000             0000 
            0xF0, 0x00, 0x78, ##  0000             0000 
            0xF0, 0x00, 0xF8, ##  0000            00000 
            0xF0, 0x00, 0xF0, ##  0000            0000  
            0xF0, 0x03, 0xE0, ##  0000          00000   
            0xFF, 0xFF, 0xC0, ##  000000000000000000    
            0xFF, 0xFF, 0x00, ##  0000000000000000      
            0xFF, 0xFF, 0xE0, ##  0000000000000000000   
            0xF0, 0x03, 0xF0, ##  0000          000000  
            0xF0, 0x00, 0xF8, ##  0000            00000 
            0xF0, 0x00, 0x78, ##  0000             0000 
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x78, ##  0000             0000 
            0xF0, 0x00, 0xF8, ##  0000            00000 
            0xF0, 0x03, 0xF0, ##  0000          000000  
            0xFF, 0xFF, 0xE0, ##  0000000000000000000   
            0xFF, 0xFF, 0xC0, ##  000000000000000000    
            0xFF, 0xFE, 0x00, ##  000000000000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 26, 
        'xoffset'  => 2, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000    
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000  
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000
            0x0F, 0xC0, 0x07, 0xC0, ##      000000           00000
            0x1F, 0x00, 0x01, 0xC0, ##     00000               000
            0x1E, 0x00, 0x00, 0xC0, ##     0000                 00
            0x3C, 0x00, 0x00, 0x40, ##    0000                   0
            0x3C, 0x00, 0x00, 0x00, ##    0000                    
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0x3C, 0x00, 0x00, 0x00, ##    0000                    
            0x3C, 0x00, 0x00, 0x40, ##    0000                   0
            0x1E, 0x00, 0x00, 0xC0, ##     0000                 00
            0x1F, 0x00, 0x01, 0xC0, ##     00000               000
            0x0F, 0xC0, 0x07, 0xC0, ##      000000           00000
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000  
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000    
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 26, 
        'xoffset'  => 4, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFC, 0x00, 0x00, ##  00000000000000            
            0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000        
            0xFF, 0xFF, 0xF0, 0x00, ##  00000000000000000000      
            0xF0, 0x03, 0xF8, 0x00, ##  0000          0000000     
            0xF0, 0x00, 0x7C, 0x00, ##  0000             00000    
            0xF0, 0x00, 0x3E, 0x00, ##  0000              00000   
            0xF0, 0x00, 0x1F, 0x00, ##  0000               00000  
            0xF0, 0x00, 0x0F, 0x00, ##  0000                0000  
            0xF0, 0x00, 0x07, 0x80, ##  0000                 0000 
            0xF0, 0x00, 0x07, 0x80, ##  0000                 0000 
            0xF0, 0x00, 0x07, 0x80, ##  0000                 0000 
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0xF0, 0x00, 0x07, 0x80, ##  0000                 0000 
            0xF0, 0x00, 0x07, 0x80, ##  0000                 0000 
            0xF0, 0x00, 0x07, 0x80, ##  0000                 0000 
            0xF0, 0x00, 0x0F, 0x80, ##  0000                00000 
            0xF0, 0x00, 0x1F, 0x00, ##  0000               00000  
            0xF0, 0x00, 0x3E, 0x00, ##  0000              00000   
            0xF0, 0x00, 0x7E, 0x00, ##  0000             000000   
            0xF0, 0x03, 0xF8, 0x00, ##  0000          0000000     
            0xFF, 0xFF, 0xF0, 0x00, ##  00000000000000000000      
            0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000        
            0xFF, 0xFC, 0x00, 0x00, ##  00000000000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xFF, 0xFF, 0x80, ##  00000000000000000 
            0xFF, 0xFF, 0x80, ##  00000000000000000 
            0xFF, 0xFF, 0x80, ##  00000000000000000 
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 27, 
        'xoffset'  => 2, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000     
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000  
            0x07, 0xFF, 0xFF, 0xC0, ##       000000000000000000000 
            0x0F, 0xC0, 0x07, 0xC0, ##      000000           00000 
            0x1F, 0x00, 0x01, 0xC0, ##     00000               000 
            0x1E, 0x00, 0x00, 0x40, ##     0000                  0 
            0x3C, 0x00, 0x00, 0x00, ##    0000                     
            0x3C, 0x00, 0x00, 0x00, ##    0000                     
            0x78, 0x00, 0x00, 0x00, ##   0000                      
            0x78, 0x00, 0x00, 0x00, ##   0000                      
            0x78, 0x00, 0x00, 0x00, ##   0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                       
            0xF0, 0x00, 0x00, 0x00, ##  0000                       
            0xF0, 0x00, 0x00, 0x00, ##  0000                       
            0xF0, 0x00, 0x00, 0x00, ##  0000                       
            0xF0, 0x00, 0xFF, 0xE0, ##  0000            00000000000
            0xF0, 0x00, 0xFF, 0xE0, ##  0000            00000000000
            0xF0, 0x00, 0xFF, 0xE0, ##  0000            00000000000
            0xF0, 0x00, 0x01, 0xE0, ##  0000                   0000
            0xF0, 0x00, 0x01, 0xE0, ##  0000                   0000
            0x78, 0x00, 0x01, 0xE0, ##   0000                  0000
            0x78, 0x00, 0x01, 0xE0, ##   0000                  0000
            0x78, 0x00, 0x01, 0xE0, ##   0000                  0000
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000
            0x1E, 0x00, 0x01, 0xE0, ##     0000                0000
            0x1F, 0x00, 0x01, 0xE0, ##     00000               0000
            0x0F, 0xC0, 0x03, 0xE0, ##      000000            00000
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000  
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000     
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 24, 
        'xoffset'  => 4, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 4, 
        'xoffset'  => 4, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 10, 
        'xoffset'  => -2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x1F, 0x80, ##     000000 
            0xFF, 0x00, ##  00000000  
            0xFE, 0x00, ##  0000000   
            0xF8, 0x00, ##  00000     
            0x00, 0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 25, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x3E, 0x00, ##  0000              00000  
            0xF0, 0x00, 0xFC, 0x00, ##  0000            000000   
            0xF0, 0x01, 0xF8, 0x00, ##  0000           000000    
            0xF0, 0x03, 0xF0, 0x00, ##  0000          000000     
            0xF0, 0x07, 0xE0, 0x00, ##  0000         000000      
            0xF0, 0x0F, 0xC0, 0x00, ##  0000        000000       
            0xF0, 0x1F, 0x80, 0x00, ##  0000       000000        
            0xF0, 0x3E, 0x00, 0x00, ##  0000      00000          
            0xF0, 0x7C, 0x00, 0x00, ##  0000     00000           
            0xF0, 0xF8, 0x00, 0x00, ##  0000    00000            
            0xF1, 0xF0, 0x00, 0x00, ##  0000   00000             
            0xF3, 0xE0, 0x00, 0x00, ##  0000  00000              
            0xF7, 0xC0, 0x00, 0x00, ##  0000 00000               
            0xFF, 0x80, 0x00, 0x00, ##  000000000                
            0xFF, 0x00, 0x00, 0x00, ##  00000000                 
            0xFF, 0x80, 0x00, 0x00, ##  000000000                
            0xFF, 0xC0, 0x00, 0x00, ##  0000000000               
            0xF7, 0xE0, 0x00, 0x00, ##  0000 000000              
            0xF3, 0xF0, 0x00, 0x00, ##  0000  000000             
            0xF1, 0xF8, 0x00, 0x00, ##  0000   000000            
            0xF0, 0xFC, 0x00, 0x00, ##  0000    000000           
            0xF0, 0x7E, 0x00, 0x00, ##  0000     000000          
            0xF0, 0x3F, 0x00, 0x00, ##  0000      000000         
            0xF0, 0x1F, 0x80, 0x00, ##  0000       000000        
            0xF0, 0x0F, 0xC0, 0x00, ##  0000        000000       
            0xF0, 0x03, 0xE0, 0x00, ##  0000          00000      
            0xF0, 0x01, 0xF0, 0x00, ##  0000           00000     
            0xF0, 0x00, 0xF8, 0x00, ##  0000            00000    
            0xF0, 0x00, 0x7C, 0x00, ##  0000             00000   
            0xF0, 0x00, 0x3E, 0x00, ##  0000              00000  
            0xF0, 0x00, 0x1F, 0x00, ##  0000               00000 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 29, 
        'xoffset'  => 4, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFE, 0x00, 0x03, 0xF8, ##  0000000               0000000
            0xFE, 0x00, 0x03, 0xF8, ##  0000000               0000000
            0xFF, 0x00, 0x07, 0xF8, ##  00000000             00000000
            0xFF, 0x00, 0x07, 0xF8, ##  00000000             00000000
            0xF7, 0x00, 0x07, 0x78, ##  0000 000             000 0000
            0xF7, 0x80, 0x0F, 0x78, ##  0000 0000           0000 0000
            0xF7, 0x80, 0x0F, 0x78, ##  0000 0000           0000 0000
            0xF3, 0xC0, 0x1E, 0x78, ##  0000  0000         0000  0000
            0xF3, 0xC0, 0x1E, 0x78, ##  0000  0000         0000  0000
            0xF1, 0xC0, 0x1C, 0x78, ##  0000   000         000   0000
            0xF1, 0xE0, 0x3C, 0x78, ##  0000   0000       0000   0000
            0xF1, 0xE0, 0x3C, 0x78, ##  0000   0000       0000   0000
            0xF0, 0xF0, 0x78, 0x78, ##  0000    0000     0000    0000
            0xF0, 0xF0, 0x78, 0x78, ##  0000    0000     0000    0000
            0xF0, 0x70, 0x70, 0x78, ##  0000     000     000     0000
            0xF0, 0x78, 0xF0, 0x78, ##  0000     0000   0000     0000
            0xF0, 0x78, 0xF0, 0x78, ##  0000     0000   0000     0000
            0xF0, 0x39, 0xE0, 0x78, ##  0000      000  0000      0000
            0xF0, 0x3D, 0xE0, 0x78, ##  0000      0000 0000      0000
            0xF0, 0x1D, 0xC0, 0x78, ##  0000       000 000       0000
            0xF0, 0x1F, 0xC0, 0x78, ##  0000       0000000       0000
            0xF0, 0x1F, 0xC0, 0x78, ##  0000       0000000       0000
            0xF0, 0x0F, 0x80, 0x78, ##  0000        00000        0000
            0xF0, 0x0F, 0x80, 0x78, ##  0000        00000        0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 24, 
        'xoffset'  => 4, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x0F, ##  000000              0000
            0xFC, 0x00, 0x0F, ##  000000              0000
            0xFE, 0x00, 0x0F, ##  0000000             0000
            0xFF, 0x00, 0x0F, ##  00000000            0000
            0xFF, 0x00, 0x0F, ##  00000000            0000
            0xFF, 0x80, 0x0F, ##  000000000           0000
            0xF7, 0x80, 0x0F, ##  0000 0000           0000
            0xF7, 0xC0, 0x0F, ##  0000 00000          0000
            0xF3, 0xC0, 0x0F, ##  0000  0000          0000
            0xF3, 0xE0, 0x0F, ##  0000  00000         0000
            0xF1, 0xE0, 0x0F, ##  0000   0000         0000
            0xF0, 0xF0, 0x0F, ##  0000    0000        0000
            0xF0, 0xF8, 0x0F, ##  0000    00000       0000
            0xF0, 0x78, 0x0F, ##  0000     0000       0000
            0xF0, 0x7C, 0x0F, ##  0000     00000      0000
            0xF0, 0x3C, 0x0F, ##  0000      0000      0000
            0xF0, 0x3E, 0x0F, ##  0000      00000     0000
            0xF0, 0x1E, 0x0F, ##  0000       0000     0000
            0xF0, 0x1F, 0x0F, ##  0000       00000    0000
            0xF0, 0x0F, 0x0F, ##  0000        0000    0000
            0xF0, 0x07, 0x8F, ##  0000         0000   0000
            0xF0, 0x07, 0xCF, ##  0000         00000  0000
            0xF0, 0x03, 0xCF, ##  0000          0000  0000
            0xF0, 0x03, 0xEF, ##  0000          00000 0000
            0xF0, 0x01, 0xEF, ##  0000           0000 0000
            0xF0, 0x01, 0xFF, ##  0000           000000000
            0xF0, 0x00, 0xFF, ##  0000            00000000
            0xF0, 0x00, 0xFF, ##  0000            00000000
            0xF0, 0x00, 0x7F, ##  0000             0000000
            0xF0, 0x00, 0x3F, ##  0000              000000
            0xF0, 0x00, 0x3F, ##  0000              000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 29, 
        'xoffset'  => 2, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFC, 0x00, ##  00000000000000      
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0xF0, 0x07, 0xC0, ##  0000         00000  
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x07, 0xC0, ##  0000         00000  
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFC, 0x00, ##  00000000000000      
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 29, 
        'xoffset'  => 2, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0x78, 0x00, 0x00, 0xF8, ##   0000                   00000
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x3C, 0x00, 0x01, 0xF0, ##    0000                 00000 
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x1E, 0x00, 0x03, 0xE0, ##     0000               00000  
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x01, 0xFF, 0xFE, 0x00, ##         0000000000000000      
            0x00, 0x7F, 0xF8, 0x00, ##           000000000000        
            0x00, 0x01, 0xFC, 0x00, ##                 0000000       
            0x00, 0x00, 0x7E, 0x00, ##                   000000      
            0x00, 0x00, 0x3F, 0x00, ##                    000000     
            0x00, 0x00, 0x1F, 0x80, ##                     000000    
            0x00, 0x00, 0x0F, 0x80, ##                      00000    
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 24, 
        'xoffset'  => 4, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFC, 0x00, ##  00000000000000          
            0xFF, 0xFF, 0x00, ##  0000000000000000        
            0xFF, 0xFF, 0xC0, ##  000000000000000000      
            0xF0, 0x07, 0xE0, ##  0000         000000     
            0xF0, 0x03, 0xE0, ##  0000          00000     
            0xF0, 0x01, 0xE0, ##  0000           0000     
            0xF0, 0x00, 0xF0, ##  0000            0000    
            0xF0, 0x00, 0xF0, ##  0000            0000    
            0xF0, 0x00, 0xF0, ##  0000            0000    
            0xF0, 0x00, 0xF0, ##  0000            0000    
            0xF0, 0x00, 0xF0, ##  0000            0000    
            0xF0, 0x00, 0xF0, ##  0000            0000    
            0xF0, 0x01, 0xE0, ##  0000           0000     
            0xF0, 0x03, 0xE0, ##  0000          00000     
            0xF0, 0x07, 0xC0, ##  0000         00000      
            0xFF, 0xFF, 0x80, ##  00000000000000000       
            0xFF, 0xFE, 0x00, ##  000000000000000         
            0xFF, 0xFF, 0x00, ##  0000000000000000        
            0xF0, 0x0F, 0x80, ##  0000        00000       
            0xF0, 0x07, 0xC0, ##  0000         00000      
            0xF0, 0x03, 0xE0, ##  0000          00000     
            0xF0, 0x01, 0xE0, ##  0000           0000     
            0xF0, 0x01, 0xF0, ##  0000           00000    
            0xF0, 0x00, 0xF0, ##  0000            0000    
            0xF0, 0x00, 0xF8, ##  0000            00000   
            0xF0, 0x00, 0x78, ##  0000             0000   
            0xF0, 0x00, 0x7C, ##  0000             00000  
            0xF0, 0x00, 0x3C, ##  0000              0000  
            0xF0, 0x00, 0x3E, ##  0000              00000 
            0xF0, 0x00, 0x1E, ##  0000               0000 
            0xF0, 0x00, 0x1F, ##  0000               00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 22, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0x07, 0xFF, 0xE0, ##       00000000000000   
            0x1F, 0xFF, 0xF0, ##     00000000000000000  
            0x3F, 0xFF, 0xF0, ##    000000000000000000  
            0x7E, 0x00, 0x70, ##   000000          000  
            0x78, 0x00, 0x00, ##   0000                 
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF8, 0x00, 0x00, ##  00000                 
            0xFE, 0x00, 0x00, ##  0000000               
            0x7F, 0xC0, 0x00, ##   000000000            
            0x3F, 0xFE, 0x00, ##    0000000000000       
            0x1F, 0xFF, 0x80, ##     00000000000000     
            0x0F, 0xFF, 0xE0, ##      000000000000000   
            0x01, 0xFF, 0xF0, ##         0000000000000  
            0x00, 0x0F, 0xF8, ##              000000000 
            0x00, 0x01, 0xF8, ##                 000000 
            0x00, 0x00, 0x7C, ##                   00000
            0x00, 0x00, 0x7C, ##                   00000
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0x3C, ##                    0000
            0x00, 0x00, 0x7C, ##                   00000
            0xC0, 0x00, 0x78, ##  00               0000 
            0xF0, 0x01, 0xF8, ##  0000           000000 
            0xFF, 0xFF, 0xF0, ##  00000000000000000000  
            0xFF, 0xFF, 0xC0, ##  000000000000000000    
            0x1F, 0xFF, 0x00, ##     0000000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 27, 
        'xoffset'  => 0, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 24, 
        'xoffset'  => 4, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x1F, ##  0000               00000
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x0F, 0xFF, 0xF0, ##      0000000000000000    
            0x03, 0xFF, 0xC0, ##        000000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 29, 
        'xoffset'  => 0, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x78, 0x00, 0x00, 0xF8, ##   0000                   00000
            0x78, 0x00, 0x00, 0xF8, ##   0000                   00000
            0x7C, 0x00, 0x00, 0xF0, ##   00000                  0000 
            0x3C, 0x00, 0x01, 0xF0, ##    0000                 00000 
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3E, 0x00, 0x01, 0xE0, ##    00000                0000  
            0x1E, 0x00, 0x03, 0xE0, ##     0000               00000  
            0x1F, 0x00, 0x03, 0xC0, ##     00000              0000   
            0x0F, 0x00, 0x07, 0xC0, ##      0000             00000   
            0x0F, 0x00, 0x07, 0x80, ##      0000             0000    
            0x0F, 0x80, 0x07, 0x80, ##      00000            0000    
            0x07, 0x80, 0x0F, 0x80, ##       0000           00000    
            0x07, 0xC0, 0x0F, 0x00, ##       00000          0000     
            0x03, 0xC0, 0x1F, 0x00, ##        0000         00000     
            0x03, 0xC0, 0x1E, 0x00, ##        0000         0000      
            0x03, 0xE0, 0x1E, 0x00, ##        00000        0000      
            0x01, 0xE0, 0x3E, 0x00, ##         0000       00000      
            0x01, 0xE0, 0x3C, 0x00, ##         0000       0000       
            0x01, 0xF0, 0x3C, 0x00, ##         00000      0000       
            0x00, 0xF0, 0x7C, 0x00, ##          0000     00000       
            0x00, 0xF8, 0x78, 0x00, ##          00000    0000        
            0x00, 0x78, 0xF8, 0x00, ##           0000   00000        
            0x00, 0x78, 0xF0, 0x00, ##           0000   0000         
            0x00, 0x7C, 0xF0, 0x00, ##           00000  0000         
            0x00, 0x3D, 0xF0, 0x00, ##            0000 00000         
            0x00, 0x3D, 0xE0, 0x00, ##            0000 0000          
            0x00, 0x1F, 0xE0, 0x00, ##             00000000          
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x0F, 0xC0, 0x00, ##              000000           
            0x00, 0x0F, 0x80, 0x00, ##              00000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 40, 
        'xoffset'  => 1, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x78, 0x00, 0x3E, 0x00, 0x0F, ##   0000             00000             0000
            0x78, 0x00, 0x7E, 0x00, 0x1F, ##   0000            000000            00000
            0x78, 0x00, 0x7E, 0x00, 0x1E, ##   0000            000000            0000 
            0x7C, 0x00, 0x7F, 0x00, 0x1E, ##   00000           0000000           0000 
            0x3C, 0x00, 0x7F, 0x00, 0x1E, ##    0000           0000000           0000 
            0x3C, 0x00, 0xF7, 0x00, 0x3E, ##    0000          0000 000          00000 
            0x3C, 0x00, 0xF7, 0x00, 0x3C, ##    0000          0000 000          0000  
            0x3E, 0x00, 0xE7, 0x80, 0x3C, ##    00000         000  0000         0000  
            0x1E, 0x00, 0xE7, 0x80, 0x3C, ##     0000         000  0000         0000  
            0x1E, 0x01, 0xE3, 0x80, 0x7C, ##     0000        0000   000        00000  
            0x1E, 0x01, 0xE3, 0x80, 0x78, ##     0000        0000   000        0000   
            0x1F, 0x01, 0xC3, 0xC0, 0x78, ##     00000       000    0000       0000   
            0x0F, 0x01, 0xC3, 0xC0, 0x78, ##      0000       000    0000       0000   
            0x0F, 0x03, 0xC1, 0xC0, 0xF8, ##      0000      0000     000      00000   
            0x0F, 0x03, 0xC1, 0xC0, 0xF0, ##      0000      0000     000      0000    
            0x0F, 0x83, 0x81, 0xE0, 0xF0, ##      00000     000      0000     0000    
            0x07, 0x83, 0x81, 0xE0, 0xF0, ##       0000     000      0000     0000    
            0x07, 0x87, 0x80, 0xE1, 0xF0, ##       0000    0000       000    00000    
            0x07, 0x87, 0x80, 0xE1, 0xE0, ##       0000    0000       000    0000     
            0x07, 0xC7, 0x00, 0xF1, 0xE0, ##       00000   000        0000   0000     
            0x03, 0xC7, 0x00, 0xF1, 0xE0, ##        0000   000        0000   0000     
            0x03, 0xCF, 0x00, 0x73, 0xE0, ##        0000  0000         000  00000     
            0x03, 0xCF, 0x00, 0x73, 0xC0, ##        0000  0000         000  0000      
            0x03, 0xEE, 0x00, 0x7B, 0xC0, ##        00000 000          0000 0000      
            0x01, 0xEE, 0x00, 0x7B, 0xC0, ##         0000 000          0000 0000      
            0x01, 0xFE, 0x00, 0x3F, 0xC0, ##         00000000           00000000      
            0x01, 0xFE, 0x00, 0x3F, 0x80, ##         00000000           0000000       
            0x01, 0xFE, 0x00, 0x3F, 0x80, ##         00000000           0000000       
            0x00, 0xFC, 0x00, 0x3F, 0x80, ##          000000            0000000       
            0x00, 0xFC, 0x00, 0x1F, 0x80, ##          000000             000000       
            0x00, 0xFC, 0x00, 0x1F, 0x00, ##          000000             00000        
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 27, 
        'xoffset'  => 1, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x3E, 0x00, 0x03, 0xC0, ##    00000               0000 
            0x1E, 0x00, 0x07, 0x80, ##     0000              0000  
            0x1F, 0x00, 0x0F, 0x80, ##     00000            00000  
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000   
            0x07, 0x80, 0x1E, 0x00, ##       0000          0000    
            0x07, 0xC0, 0x3E, 0x00, ##       00000        00000    
            0x03, 0xE0, 0x7C, 0x00, ##        00000      00000     
            0x01, 0xE0, 0x78, 0x00, ##         0000      0000      
            0x01, 0xF0, 0xF8, 0x00, ##         00000    00000      
            0x00, 0xF9, 0xF0, 0x00, ##          00000  00000       
            0x00, 0x79, 0xE0, 0x00, ##           0000  0000        
            0x00, 0x7F, 0xE0, 0x00, ##           0000000000        
            0x00, 0x3F, 0xC0, 0x00, ##            00000000         
            0x00, 0x1F, 0x80, 0x00, ##             000000          
            0x00, 0x1F, 0x80, 0x00, ##             000000          
            0x00, 0x1F, 0x80, 0x00, ##             000000          
            0x00, 0x3F, 0x80, 0x00, ##            0000000          
            0x00, 0x7F, 0xC0, 0x00, ##           000000000         
            0x00, 0x7B, 0xE0, 0x00, ##           0000 00000        
            0x00, 0xF9, 0xE0, 0x00, ##          00000  0000        
            0x01, 0xF0, 0xF0, 0x00, ##         00000    0000       
            0x01, 0xE0, 0xF8, 0x00, ##         0000     00000      
            0x03, 0xE0, 0x78, 0x00, ##        00000      0000      
            0x07, 0xC0, 0x3C, 0x00, ##       00000        0000     
            0x07, 0x80, 0x3E, 0x00, ##       0000         00000    
            0x0F, 0x80, 0x1E, 0x00, ##      00000          0000    
            0x1F, 0x00, 0x0F, 0x00, ##     00000            0000   
            0x1E, 0x00, 0x0F, 0x80, ##     0000             00000  
            0x3E, 0x00, 0x07, 0x80, ##    00000              0000  
            0x7C, 0x00, 0x03, 0xC0, ##   00000                0000 
            0x78, 0x00, 0x03, 0xE0, ##   0000                 00000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 26, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xF8, 0x00, 0x07, 0xC0, ##  00000                00000
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0x3C, 0x00, 0x0F, 0x00, ##    0000              0000  
            0x3E, 0x00, 0x1F, 0x00, ##    00000            00000  
            0x1E, 0x00, 0x1E, 0x00, ##     0000            0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000    
            0x0F, 0x80, 0x7C, 0x00, ##      00000        00000    
            0x07, 0x80, 0x78, 0x00, ##       0000        0000     
            0x03, 0xC0, 0xF0, 0x00, ##        0000      0000      
            0x03, 0xE1, 0xF0, 0x00, ##        00000    00000      
            0x01, 0xF1, 0xE0, 0x00, ##         00000   0000       
            0x00, 0xF3, 0xC0, 0x00, ##          0000  0000        
            0x00, 0xFF, 0xC0, 0x00, ##          0000000000        
            0x00, 0x7F, 0x80, 0x00, ##           00000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000          
            0x00, 0x3F, 0x00, 0x00, ##            000000          
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 26, 
        'xoffset'  => 2, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0x00, 0x00, 0x1F, 0x00, ##                     00000  
            0x00, 0x00, 0x3F, 0x00, ##                    000000  
            0x00, 0x00, 0x3E, 0x00, ##                    00000   
            0x00, 0x00, 0x7C, 0x00, ##                   00000    
            0x00, 0x00, 0xF8, 0x00, ##                  00000     
            0x00, 0x01, 0xF0, 0x00, ##                 00000      
            0x00, 0x01, 0xF0, 0x00, ##                 00000      
            0x00, 0x03, 0xE0, 0x00, ##                00000       
            0x00, 0x07, 0xC0, 0x00, ##               00000        
            0x00, 0x0F, 0x80, 0x00, ##              00000         
            0x00, 0x1F, 0x00, 0x00, ##             00000          
            0x00, 0x1F, 0x00, 0x00, ##             00000          
            0x00, 0x3E, 0x00, 0x00, ##            00000           
            0x00, 0x7C, 0x00, 0x00, ##           00000            
            0x00, 0xF8, 0x00, 0x00, ##          00000             
            0x00, 0xF0, 0x00, 0x00, ##          0000              
            0x01, 0xF0, 0x00, 0x00, ##         00000              
            0x03, 0xE0, 0x00, 0x00, ##        00000               
            0x07, 0xC0, 0x00, 0x00, ##       00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x00, 0x00, 0x00, ##      0000                  
            0x1F, 0x00, 0x00, 0x00, ##     00000                  
            0x3E, 0x00, 0x00, 0x00, ##    00000                   
            0x7C, 0x00, 0x00, 0x00, ##   00000                    
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 9, 
        'xoffset'  => 4, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xF0, 0x00, ##  0000     
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0x70, 0x00, ##   000          
            0x78, 0x00, ##   0000         
            0x78, 0x00, ##   0000         
            0x38, 0x00, ##    000         
            0x3C, 0x00, ##    0000        
            0x3C, 0x00, ##    0000        
            0x1C, 0x00, ##     000        
            0x1E, 0x00, ##     0000       
            0x1E, 0x00, ##     0000       
            0x0E, 0x00, ##      000       
            0x0E, 0x00, ##      000       
            0x0F, 0x00, ##      0000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x03, 0x80, ##        000     
            0x03, 0xC0, ##        0000    
            0x03, 0xC0, ##        0000    
            0x01, 0xC0, ##         000    
            0x01, 0xE0, ##         0000   
            0x01, 0xE0, ##         0000   
            0x00, 0xE0, ##          000   
            0x00, 0xF0, ##          0000  
            0x00, 0xF0, ##          0000  
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x00, 0x78, ##           0000 
            0x00, 0x38, ##            000 
            0x00, 0x38, ##            000 
            0x00, 0x3C, ##            0000
            0x00, 0x3C, ##            0000
            0x00, 0x1C, ##             000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 9, 
        'xoffset'  => 4, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0xFF, 0x80, ##  000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 26, 
        'xoffset'  => 5, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x3F, 0x00, 0x00, ##            000000          
            0x00, 0x7F, 0x80, 0x00, ##           00000000         
            0x00, 0xFF, 0xC0, 0x00, ##          0000000000        
            0x01, 0xF3, 0xE0, 0x00, ##         00000  00000       
            0x03, 0xE1, 0xF0, 0x00, ##        00000    00000      
            0x07, 0xC0, 0xF8, 0x00, ##       00000      00000     
            0x0F, 0x80, 0x7C, 0x00, ##      00000        00000    
            0x1F, 0x00, 0x3E, 0x00, ##     00000          00000   
            0x3E, 0x00, 0x1F, 0x00, ##    00000            00000  
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0xF0, 0x00, 0x03, 0xC0, ##  0000                  0000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 22, 
        'xoffset'  => 0, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 10, 
        'xoffset'  => 4, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x00, ##  0000      
            0x78, 0x00, ##   0000     
            0x3C, 0x00, ##    0000    
            0x1C, 0x00, ##     000    
            0x1E, 0x00, ##     0000   
            0x0F, 0x00, ##      0000  
            0x07, 0x80, ##       0000 
            0x03, 0x80, ##        000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x1F, 0xFE, 0x00, ##     000000000000     
            0x3F, 0xFF, 0x80, ##    000000000000000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x30, 0x03, 0xE0, ##    00          00000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x00, 0xE0, ##                  000 
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x03, 0xFF, 0xF0, ##        00000000000000
            0x1F, 0xFF, 0xF0, ##     00000000000000000
            0x3F, 0xFF, 0xF0, ##    000000000000000000
            0x7E, 0x00, 0xF0, ##   000000         0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x03, 0xF0, ##  00000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x7F, 0xFE, 0xF0, ##   00000000000000 0000
            0x3F, 0xFC, 0xF0, ##    000000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 21, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF1, 0xFF, 0x00, ##  0000   000000000     
            0xF3, 0xFF, 0x80, ##  0000  00000000000    
            0xF7, 0xFF, 0xC0, ##  0000 0000000000000   
            0xFE, 0x03, 0xE0, ##  0000000       00000  
            0xFC, 0x01, 0xE0, ##  000000         0000  
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0xF8, ##  0000            00000
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xFC, 0x01, 0xE0, ##  000000         0000  
            0xFE, 0x03, 0xE0, ##  0000000       00000  
            0xF7, 0xFF, 0xC0, ##  0000 0000000000000   
            0xF3, 0xFF, 0x80, ##  0000  00000000000    
            0xF1, 0xFF, 0x00, ##  0000   000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                     
            0x03, 0xFF, 0xC0, ##        000000000000 
            0x07, 0xFF, 0xE0, ##       00000000000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3F, 0x00, 0x60, ##    000000         00
            0x3C, 0x00, 0x00, ##    0000             
            0x7C, 0x00, 0x00, ##   00000             
            0x78, 0x00, 0x00, ##   0000              
            0xF8, 0x00, 0x00, ##  00000              
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF8, 0x00, 0x00, ##  00000              
            0x78, 0x00, 0x00, ##   0000              
            0x7C, 0x00, 0x00, ##   00000             
            0x3C, 0x00, 0x00, ##    0000             
            0x3F, 0x00, 0x60, ##    000000         00
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x0F, 0xFF, 0xE0, ##      000000000000000
            0x03, 0xFF, 0xC0, ##        000000000000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x07, 0xFC, 0x78, ##       000000000   0000
            0x0F, 0xFE, 0x78, ##      00000000000  0000
            0x1F, 0xFF, 0x78, ##     0000000000000 0000
            0x3E, 0x03, 0xF8, ##    00000       0000000
            0x3C, 0x01, 0xF8, ##    0000         000000
            0x78, 0x00, 0xF8, ##   0000           00000
            0x78, 0x00, 0xF8, ##   0000           00000
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0xF8, ##  0000            00000
            0x78, 0x00, 0xF8, ##   0000           00000
            0x78, 0x00, 0xF8, ##   0000           00000
            0x3C, 0x01, 0xF8, ##    0000         000000
            0x3E, 0x03, 0xF8, ##    00000       0000000
            0x1F, 0xFF, 0x78, ##     0000000000000 0000
            0x0F, 0xFE, 0x78, ##      00000000000  0000
            0x07, 0xFC, 0x78, ##       000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x80, ##        00000000000     
            0x07, 0xFF, 0xC0, ##       0000000000000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x1E, 0x01, 0xF0, ##     0000        00000  
            0x3C, 0x00, 0xF8, ##    0000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x3C, ##   0000             0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0x78, 0x00, 0x00, ##   0000                 
            0x78, 0x00, 0x00, ##   0000                 
            0x3C, 0x00, 0x00, ##    0000                
            0x1F, 0x00, 0x38, ##     00000          000 
            0x1F, 0xFF, 0xF8, ##     000000000000000000 
            0x07, 0xFF, 0xF8, ##       0000000000000000 
            0x01, 0xFF, 0xE0, ##         000000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xFE, ##          0000000
            0x03, 0xFE, ##        000000000
            0x07, 0xFE, ##       0000000000
            0x07, 0x80, ##       0000      
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0xFF, 0xFC, ##  00000000000000 
            0xFF, 0xFC, ##  00000000000000 
            0xFF, 0xFC, ##  00000000000000 
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x0F, 0x00, ##      0000       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0x07, 0xFC, 0x78, ##       000000000   0000
            0x0F, 0xFE, 0x78, ##      00000000000  0000
            0x1F, 0xFF, 0x78, ##     0000000000000 0000
            0x3E, 0x03, 0xF8, ##    00000       0000000
            0x7C, 0x01, 0xF8, ##   00000         000000
            0x78, 0x00, 0xF8, ##   0000           00000
            0x78, 0x00, 0xF8, ##   0000           00000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF8, 0x00, 0xF8, ##  00000           00000
            0x78, 0x00, 0xF8, ##   0000           00000
            0x7C, 0x01, 0xF8, ##   00000         000000
            0x3C, 0x01, 0xF8, ##    0000         000000
            0x3F, 0x07, 0xF8, ##    000000     00000000
            0x1F, 0xFF, 0x78, ##     0000000000000 0000
            0x0F, 0xFE, 0x78, ##      00000000000  0000
            0x03, 0xF8, 0x78, ##        0000000    0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0xF0, ##                  0000 
            0x00, 0x00, 0xF0, ##                  0000 
            0x10, 0x01, 0xF0, ##     0           00000 
            0x1C, 0x07, 0xE0, ##     000       000000  
            0x1F, 0xFF, 0xC0, ##     000000000000000   
            0x1F, 0xFF, 0x80, ##     00000000000000    
            0x07, 0xFC, 0x00, ##       000000000       
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF1, 0xFF, 0x00, ##  0000   000000000    
            0xF3, 0xFF, 0x80, ##  0000  00000000000   
            0xF7, 0xFF, 0xC0, ##  0000 0000000000000  
            0xFE, 0x03, 0xE0, ##  0000000       00000 
            0xFC, 0x01, 0xE0, ##  000000         0000 
            0xF8, 0x01, 0xF0, ##  00000          00000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 4, 
        'xoffset'  => 4, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 9, 
        'xoffset'  => -1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x07, 0x80, ##       0000
            0x0F, 0x80, ##      00000
            0x0F, 0x00, ##      0000 
            0xFF, 0x00, ##  00000000 
            0xFE, 0x00, ##  0000000  
            0xF8, 0x00, ##  00000    
            0x00, 0x00, ##  
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 21, 
        'xoffset'  => 4, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x01, 0xF0, ##  0000           00000 
            0xF0, 0x03, 0xE0, ##  0000          00000  
            0xF0, 0x07, 0xC0, ##  0000         00000   
            0xF0, 0x1F, 0x00, ##  0000       00000     
            0xF0, 0x3E, 0x00, ##  0000      00000      
            0xF0, 0x7C, 0x00, ##  0000     00000       
            0xF0, 0xF8, 0x00, ##  0000    00000        
            0xF1, 0xF0, 0x00, ##  0000   00000         
            0xF3, 0xE0, 0x00, ##  0000  00000          
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x00, 0x00, ##  00000000             
            0xFF, 0x80, 0x00, ##  000000000            
            0xF7, 0xC0, 0x00, ##  0000 00000           
            0xF3, 0xE0, 0x00, ##  0000  00000          
            0xF1, 0xF0, 0x00, ##  0000   00000         
            0xF0, 0xF8, 0x00, ##  0000    00000        
            0xF0, 0x7C, 0x00, ##  0000     00000       
            0xF0, 0x3E, 0x00, ##  0000      00000      
            0xF0, 0x1F, 0x00, ##  0000       00000     
            0xF0, 0x0F, 0x80, ##  0000        00000    
            0xF0, 0x07, 0xC0, ##  0000         00000   
            0xF0, 0x03, 0xE0, ##  0000          00000  
            0xF0, 0x01, 0xF0, ##  0000           00000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 4, 
        'xoffset'  => 4, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 34, 
        'xoffset'  => 4, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0xF1, 0xFE, 0x03, 0xFC, 0x00, ##  0000   00000000       00000000    
            0xF3, 0xFF, 0x87, 0xFF, 0x00, ##  0000  00000000000    00000000000  
            0xF7, 0xFF, 0x8F, 0xFF, 0x00, ##  0000 000000000000   000000000000  
            0xFE, 0x07, 0xDC, 0x0F, 0x80, ##  0000000      00000 000      00000 
            0xFC, 0x03, 0xF8, 0x07, 0x80, ##  000000        0000000        0000 
            0xF8, 0x03, 0xF0, 0x07, 0xC0, ##  00000         000000         00000
            0xF8, 0x01, 0xF0, 0x03, 0xC0, ##  00000          00000          0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0xF0, 0x01, 0xE0, 0x03, 0xC0, ##  0000           0000           0000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0xF1, 0xFF, 0x00, ##  0000   000000000    
            0xF3, 0xFF, 0x80, ##  0000  00000000000   
            0xF7, 0xFF, 0xC0, ##  0000 0000000000000  
            0xFE, 0x03, 0xE0, ##  0000000       00000 
            0xFC, 0x01, 0xE0, ##  000000         0000 
            0xF8, 0x01, 0xF0, ##  00000          00000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x78, 0x00, 0xF8, ##   0000           00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 21, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0xF1, 0xFF, 0x00, ##  0000   000000000     
            0xF3, 0xFF, 0x80, ##  0000  00000000000    
            0xF7, 0xFF, 0xC0, ##  0000 0000000000000   
            0xFE, 0x03, 0xE0, ##  0000000       00000  
            0xFC, 0x01, 0xE0, ##  000000         0000  
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0xF8, ##  0000            00000
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xFC, 0x01, 0xE0, ##  000000         0000  
            0xFE, 0x03, 0xE0, ##  0000000       00000  
            0xF7, 0xFF, 0xC0, ##  0000 0000000000000   
            0xF3, 0xFF, 0x80, ##  0000  00000000000    
            0xF1, 0xFF, 0x00, ##  0000   000000000     
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0x07, 0xFC, 0x78, ##       000000000   0000
            0x0F, 0xFE, 0x78, ##      00000000000  0000
            0x1F, 0xFF, 0x78, ##     0000000000000 0000
            0x3E, 0x03, 0xF8, ##    00000       0000000
            0x3C, 0x01, 0xF8, ##    0000         000000
            0x78, 0x00, 0xF8, ##   0000           00000
            0x78, 0x00, 0xF8, ##   0000           00000
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0xF8, ##  0000            00000
            0x78, 0x00, 0xF8, ##   0000           00000
            0x78, 0x00, 0xF8, ##   0000           00000
            0x3C, 0x01, 0xF8, ##    0000         000000
            0x3E, 0x03, 0xF8, ##    00000       0000000
            0x1F, 0xFF, 0x78, ##     0000000000000 0000
            0x0F, 0xFE, 0x78, ##      00000000000  0000
            0x07, 0xFC, 0x78, ##       000000000   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 14, 
        'xoffset'  => 4, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##                
            0xF1, 0xFC, ##  0000   0000000
            0xF3, 0xFC, ##  0000  00000000
            0xF7, 0xFC, ##  0000 000000000
            0xFE, 0x00, ##  0000000       
            0xFC, 0x00, ##  000000        
            0xF8, 0x00, ##  00000         
            0xF8, 0x00, ##  00000         
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 18, 
        'xoffset'  => 2, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                    
            0x0F, 0xFF, 0x00, ##      000000000000  
            0x3F, 0xFF, 0x80, ##    000000000000000 
            0x7F, 0xFF, 0x80, ##   0000000000000000 
            0x78, 0x01, 0x80, ##   0000          00 
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xF0, 0x00, 0x00, ##  0000              
            0xFC, 0x00, 0x00, ##  000000            
            0x7F, 0x80, 0x00, ##   00000000         
            0x3F, 0xF8, 0x00, ##    00000000000     
            0x1F, 0xFE, 0x00, ##     000000000000   
            0x03, 0xFF, 0x80, ##        00000000000 
            0x00, 0x3F, 0x80, ##            0000000 
            0x00, 0x07, 0xC0, ##               00000
            0x00, 0x03, 0xC0, ##                0000
            0x00, 0x03, 0xC0, ##                0000
            0x00, 0x03, 0xC0, ##                0000
            0x00, 0x03, 0xC0, ##                0000
            0xE0, 0x07, 0x80, ##  000          0000 
            0xFF, 0xFF, 0x80, ##  00000000000000000 
            0xFF, 0xFF, 0x00, ##  0000000000000000  
            0x7F, 0xFC, 0x00, ##   0000000000000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 15, 
        'xoffset'  => 1, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x1E, 0x00, ##     0000        
            0x0F, 0x00, ##      0000       
            0x0F, 0xFE, ##      00000000000
            0x07, 0xFE, ##       0000000000
            0x01, 0xFE, ##         00000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x01, 0xF0, ##  00000          00000
            0x78, 0x03, 0xF0, ##   0000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x3F, 0xFE, 0xF0, ##    0000000000000 0000
            0x1F, 0xFC, 0xF0, ##     00000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 23, 
        'xoffset'  => 1, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0x00, 0x1E, ##  00000              0000
            0x78, 0x00, 0x3E, ##   0000             00000
            0x78, 0x00, 0x3C, ##   0000             0000 
            0x3C, 0x00, 0x3C, ##    0000            0000 
            0x3C, 0x00, 0x78, ##    0000           0000  
            0x3C, 0x00, 0x78, ##    0000           0000  
            0x1E, 0x00, 0x78, ##     0000          0000  
            0x1E, 0x00, 0xF0, ##     0000         0000   
            0x0F, 0x00, 0xF0, ##      0000        0000   
            0x0F, 0x01, 0xF0, ##      0000       00000   
            0x0F, 0x01, 0xE0, ##      0000       0000    
            0x07, 0x81, 0xE0, ##       0000      0000    
            0x07, 0x83, 0xC0, ##       0000     0000     
            0x07, 0xC3, 0xC0, ##       00000    0000     
            0x03, 0xC3, 0xC0, ##        0000    0000     
            0x03, 0xC7, 0x80, ##        0000   0000      
            0x01, 0xE7, 0x80, ##         0000  0000      
            0x01, 0xEF, 0x00, ##         0000 0000       
            0x01, 0xEF, 0x00, ##         0000 0000       
            0x00, 0xFF, 0x00, ##          00000000       
            0x00, 0xFE, 0x00, ##          0000000        
            0x00, 0x7E, 0x00, ##           000000        
            0x00, 0x7E, 0x00, ##           000000        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xF0, 0x07, 0xC0, 0x1E, ##  0000         00000         0000
            0xF0, 0x07, 0xC0, 0x1E, ##  0000         00000         0000
            0xF0, 0x07, 0xE0, 0x1E, ##  0000         000000        0000
            0x78, 0x0F, 0xE0, 0x1C, ##   0000       0000000        000 
            0x78, 0x0F, 0xE0, 0x3C, ##   0000       0000000       0000 
            0x78, 0x0E, 0xE0, 0x3C, ##   0000       000 000       0000 
            0x38, 0x0E, 0xF0, 0x3C, ##    000       000 0000      0000 
            0x3C, 0x1E, 0xF0, 0x78, ##    0000     0000 0000     0000  
            0x3C, 0x1C, 0x70, 0x78, ##    0000     000   000     0000  
            0x3C, 0x1C, 0x70, 0x78, ##    0000     000   000     0000  
            0x1E, 0x3C, 0x78, 0x78, ##     0000   0000   0000    0000  
            0x1E, 0x3C, 0x38, 0xF0, ##     0000   0000    000   0000   
            0x1E, 0x38, 0x38, 0xF0, ##     0000   000     000   0000   
            0x1E, 0x38, 0x38, 0xF0, ##     0000   000     000   0000   
            0x0F, 0x78, 0x3C, 0xE0, ##      0000 0000     0000  000    
            0x0F, 0x78, 0x1D, 0xE0, ##      0000 0000      000 0000    
            0x0F, 0x70, 0x1D, 0xE0, ##      0000 000       000 0000    
            0x0F, 0x70, 0x1F, 0xE0, ##      0000 000       00000000    
            0x07, 0xF0, 0x1F, 0xC0, ##       0000000       0000000     
            0x07, 0xE0, 0x0F, 0xC0, ##       000000         000000     
            0x07, 0xE0, 0x0F, 0xC0, ##       000000         000000     
            0x03, 0xE0, 0x0F, 0xC0, ##        00000         000000     
            0x03, 0xE0, 0x07, 0x80, ##        00000          0000      
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 23, 
        'xoffset'  => 1, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7C, 0x00, 0x3C, ##   00000            0000 
            0x3E, 0x00, 0x78, ##    00000          0000  
            0x1E, 0x00, 0xF8, ##     0000         00000  
            0x0F, 0x01, 0xF0, ##      0000       00000   
            0x0F, 0x81, 0xE0, ##      00000      0000    
            0x07, 0xC3, 0xC0, ##       00000    0000     
            0x03, 0xE7, 0xC0, ##        00000  00000     
            0x01, 0xEF, 0x80, ##         0000 00000      
            0x01, 0xFF, 0x00, ##         000000000       
            0x00, 0xFE, 0x00, ##          0000000        
            0x00, 0x7E, 0x00, ##           000000        
            0x00, 0x7C, 0x00, ##           00000         
            0x00, 0xFE, 0x00, ##          0000000        
            0x01, 0xFF, 0x00, ##         000000000       
            0x01, 0xEF, 0x80, ##         0000 00000      
            0x03, 0xC7, 0x80, ##        0000   0000      
            0x07, 0xC3, 0xC0, ##       00000    0000     
            0x0F, 0x83, 0xE0, ##      00000     00000    
            0x0F, 0x01, 0xF0, ##      0000       00000   
            0x1E, 0x00, 0xF0, ##     0000         0000   
            0x3E, 0x00, 0x78, ##    00000          0000  
            0x7C, 0x00, 0x7C, ##   00000           00000 
            0x78, 0x00, 0x3E, ##   0000             00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 23, 
        'xoffset'  => 1, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x3E, ##  0000              00000
            0xF8, 0x00, 0x3C, ##  00000             0000 
            0x78, 0x00, 0x3C, ##   0000             0000 
            0x78, 0x00, 0x78, ##   0000            0000  
            0x3C, 0x00, 0x78, ##    0000           0000  
            0x3C, 0x00, 0xF8, ##    0000          00000  
            0x1E, 0x00, 0xF0, ##     0000         0000   
            0x1E, 0x00, 0xF0, ##     0000         0000   
            0x1E, 0x01, 0xE0, ##     0000        0000    
            0x0F, 0x01, 0xE0, ##      0000       0000    
            0x0F, 0x03, 0xE0, ##      0000      00000    
            0x07, 0x83, 0xC0, ##       0000     0000     
            0x07, 0x83, 0xC0, ##       0000     0000     
            0x07, 0x87, 0x80, ##       0000    0000      
            0x03, 0xC7, 0x80, ##        0000   0000      
            0x03, 0xCF, 0x00, ##        0000  0000       
            0x01, 0xEF, 0x00, ##         0000 0000       
            0x01, 0xEF, 0x00, ##         0000 0000       
            0x00, 0xFE, 0x00, ##          0000000        
            0x00, 0xFE, 0x00, ##          0000000        
            0x00, 0xFC, 0x00, ##          000000         
            0x00, 0x7C, 0x00, ##           00000         
            0x00, 0x7C, 0x00, ##           00000         
            0x00, 0x78, 0x00, ##           0000          
            0x00, 0x78, 0x00, ##           0000          
            0x00, 0xF0, 0x00, ##          0000           
            0x00, 0xF0, 0x00, ##          0000           
            0x01, 0xE0, 0x00, ##         0000            
            0x03, 0xE0, 0x00, ##        00000            
            0x3F, 0xC0, 0x00, ##    00000000             
            0x3F, 0xC0, 0x00, ##    00000000             
            0x3F, 0x00, 0x00, ##    000000               
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xE0, ##   000000000000000000
            0x7F, 0xFF, 0xE0, ##   000000000000000000
            0x7F, 0xFF, 0xE0, ##   000000000000000000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x07, 0x80, ##               0000  
            0x00, 0x0F, 0x00, ##              0000   
            0x00, 0x1F, 0x00, ##             00000   
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x7C, 0x00, ##           00000     
            0x00, 0xF8, 0x00, ##          00000      
            0x01, 0xF0, 0x00, ##         00000       
            0x03, 0xE0, 0x00, ##        00000        
            0x07, 0xC0, 0x00, ##       00000         
            0x0F, 0xC0, 0x00, ##      000000         
            0x0F, 0x80, 0x00, ##      00000          
            0x1F, 0x00, 0x00, ##     00000           
            0x3E, 0x00, 0x00, ##    00000            
            0x7C, 0x00, 0x00, ##   00000             
            0xF8, 0x00, 0x00, ##  00000              
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 16, 
        'xoffset'  => 6, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x3F, ##            000000
            0x00, 0xFF, ##          00000000
            0x01, 0xFF, ##         000000000
            0x01, 0xE0, ##         0000     
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x07, 0xC0, ##       00000      
            0x0F, 0x80, ##      00000       
            0xFF, 0x00, ##  00000000        
            0xFC, 0x00, ##  000000          
            0xFF, 0x00, ##  00000000        
            0x0F, 0x80, ##      00000       
            0x07, 0x80, ##       0000       
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xE0, ##        00000     
            0x01, 0xE0, ##         0000     
            0x01, 0xFF, ##         000000000
            0x00, 0xFF, ##          00000000
            0x00, 0x3F, ##            000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 4, 
        'xoffset'  => 5, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 17, 
        'xoffset'  => 5, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, ##  000000           
            0xFF, 0x00, 0x00, ##  00000000         
            0xFF, 0x80, 0x00, ##  000000000        
            0x07, 0x80, 0x00, ##       0000        
            0x07, 0xC0, 0x00, ##       00000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xE0, 0x00, ##        00000      
            0x01, 0xF0, 0x00, ##         00000     
            0x00, 0xFF, 0x80, ##          000000000
            0x00, 0x3F, 0x80, ##            0000000
            0x00, 0xFF, 0x80, ##          000000000
            0x01, 0xF0, 0x00, ##         00000     
            0x01, 0xE0, 0x00, ##         0000      
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x07, 0xC0, 0x00, ##       00000       
            0x07, 0x80, 0x00, ##       0000        
            0xFF, 0x80, 0x00, ##  000000000        
            0xFF, 0x00, 0x00, ##  00000000         
            0xFC, 0x00, 0x00, ##  000000           
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                             
            0x07, 0xE0, 0x00, 0x20, ##       000000               0
            0x3F, 0xFC, 0x00, 0xE0, ##    000000000000          000
            0x7F, 0xFF, 0x83, 0xE0, ##   0000000000000000     00000
            0xF8, 0x3F, 0xFF, 0xC0, ##  00000     0000000000000000 
            0xE0, 0x07, 0xFF, 0x80, ##  000          000000000000  
            0x80, 0x00, 0xFC, 0x00, ##  0               000000     
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '160' => {    # ' '
        'width'    => 0, 
        'xoffset'  => 0, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
        ], 
    }, 
    '161' => {    # '¡'
        'width'    => 4, 
        'xoffset'  => 6, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '162' => {    # '¢'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x18, 0x00, ##             00      
            0x01, 0xFF, 0xC0, ##         00000000000 
            0x07, 0xFF, 0xE0, ##       00000000000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3F, 0x18, 0x60, ##    000000   00    00
            0x3E, 0x18, 0x00, ##    00000    00      
            0x7C, 0x18, 0x00, ##   00000     00      
            0x78, 0x18, 0x00, ##   0000      00      
            0xF8, 0x18, 0x00, ##  00000      00      
            0xF0, 0x18, 0x00, ##  0000       00      
            0xF0, 0x18, 0x00, ##  0000       00      
            0xF0, 0x18, 0x00, ##  0000       00      
            0xF0, 0x18, 0x00, ##  0000       00      
            0xF0, 0x18, 0x00, ##  0000       00      
            0xF0, 0x18, 0x00, ##  0000       00      
            0xF0, 0x18, 0x00, ##  0000       00      
            0xF8, 0x18, 0x00, ##  00000      00      
            0x78, 0x18, 0x00, ##   0000      00      
            0x7C, 0x18, 0x00, ##   00000     00      
            0x3E, 0x18, 0x00, ##    00000    00      
            0x3F, 0x18, 0x60, ##    000000   00    00
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x07, 0xFF, 0xE0, ##       00000000000000
            0x03, 0xFF, 0xC0, ##        000000000000 
            0x00, 0x1C, 0x00, ##             000     
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '163' => {    # '£'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0x00, 0x7F, 0xF0, ##           00000000000 
            0x00, 0xFF, 0xF8, ##          0000000000000
            0x01, 0xFF, 0xF8, ##         00000000000000
            0x03, 0xE0, 0x18, ##        00000        00
            0x03, 0xC0, 0x00, ##        0000           
            0x07, 0xC0, 0x00, ##       00000           
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x7F, 0xFF, 0xC0, ##   00000000000000000   
            0x7F, 0xFF, 0xC0, ##   00000000000000000   
            0x7F, 0xFF, 0xC0, ##   00000000000000000   
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x80, 0x00, ##       0000            
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '164' => {    # '¤'
        'width'    => 24, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x20, 0x00, 0x04, ##    0                  0  
            0x70, 0x00, 0x0E, ##   000                000 
            0xF8, 0x00, 0x1F, ##  00000              00000
            0x7E, 0x3E, 0x3E, ##   000000   00000   00000 
            0x3F, 0xFF, 0xFC, ##    00000000000000000000  
            0x0F, 0xFF, 0xF0, ##      0000000000000000    
            0x07, 0xC3, 0xE0, ##       00000    00000     
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x07, 0xC3, 0xE0, ##       00000    00000     
            0x0F, 0xFF, 0xF0, ##      0000000000000000    
            0x3F, 0xFF, 0xFC, ##    00000000000000000000  
            0x7E, 0x7E, 0x3E, ##   000000  000000   00000 
            0xF8, 0x00, 0x1F, ##  00000              00000
            0x70, 0x00, 0x0E, ##   000                000 
            0x20, 0x00, 0x04, ##    0                  0  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '165' => {    # '¥'
        'width'    => 24, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x0F, ##  0000                0000
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x0E, 0x00, 0xF0, ##      000         0000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x7F, 0xE7, 0xFE, ##   0000000000  0000000000 
            0x7F, 0xE7, 0xFE, ##   0000000000  0000000000 
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x00, 0xFE, 0x00, ##          0000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '166' => {    # '¦'
        'width'    => 4, 
        'xoffset'  => 5, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '167' => {    # '§'
        'width'    => 18, 
        'xoffset'  => 2, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                    
            0x0F, 0xFE, 0x00, ##      00000000000   
            0x1F, 0xFE, 0x00, ##     000000000000   
            0x3F, 0xFE, 0x00, ##    0000000000000   
            0x7C, 0x02, 0x00, ##   00000        0   
            0x78, 0x00, 0x00, ##   0000             
            0x78, 0x00, 0x00, ##   0000             
            0x78, 0x00, 0x00, ##   0000             
            0x7C, 0x00, 0x00, ##   00000            
            0x3E, 0x00, 0x00, ##    00000           
            0x1F, 0x80, 0x00, ##     000000         
            0x0F, 0xE0, 0x00, ##      0000000       
            0x3D, 0xF8, 0x00, ##    0000 000000     
            0x78, 0xFC, 0x00, ##   0000   000000    
            0x78, 0x3F, 0x00, ##   0000     000000  
            0xF0, 0x1F, 0x80, ##  0000       000000 
            0xF0, 0x0F, 0x80, ##  0000        00000 
            0xF0, 0x07, 0xC0, ##  0000         00000
            0xF8, 0x03, 0xC0, ##  00000         0000
            0x7C, 0x03, 0xC0, ##   00000        0000
            0x7E, 0x03, 0xC0, ##   000000       0000
            0x3F, 0x07, 0x80, ##    000000     0000 
            0x1F, 0xCF, 0x80, ##     0000000  00000 
            0x07, 0xFF, 0x00, ##       00000000000  
            0x03, 0xFC, 0x00, ##        00000000    
            0x00, 0xFC, 0x00, ##          000000    
            0x00, 0x3E, 0x00, ##            00000   
            0x00, 0x1F, 0x00, ##             00000  
            0x00, 0x0F, 0x00, ##              0000  
            0x00, 0x0F, 0x00, ##              0000  
            0x00, 0x0F, 0x00, ##              0000  
            0x40, 0x1F, 0x00, ##   0         00000  
            0x70, 0x3E, 0x00, ##   000      00000   
            0x7F, 0xFE, 0x00, ##   00000000000000   
            0x7F, 0xFC, 0x00, ##   0000000000000    
            0x0F, 0xF0, 0x00, ##      00000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '168' => {    # '¨'
        'width'    => 12, 
        'xoffset'  => 5, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '169' => {    # '©'
        'width'    => 31, 
        'xoffset'  => 6, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xE0, 0x00, ##              0000000            
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000         
            0x01, 0xF0, 0x1F, 0x00, ##         00000       00000       
            0x03, 0x80, 0x03, 0x80, ##        000             000      
            0x07, 0x00, 0x01, 0xC0, ##       000               000     
            0x0E, 0x00, 0x00, 0x60, ##      000                  00    
            0x1C, 0x0F, 0xF0, 0x30, ##     000      00000000      00   
            0x38, 0x3F, 0xFC, 0x38, ##    000     000000000000    000  
            0x30, 0x7F, 0xFC, 0x18, ##    00     0000000000000     00  
            0x60, 0xFC, 0x0C, 0x0C, ##   00     000000      00      00 
            0x61, 0xF0, 0x00, 0x0C, ##   00    00000                00 
            0xE1, 0xE0, 0x00, 0x0C, ##  000    0000                 00 
            0xC3, 0xE0, 0x00, 0x06, ##  00    00000                  00
            0xC3, 0xC0, 0x00, 0x06, ##  00    0000                   00
            0xC3, 0xC0, 0x00, 0x06, ##  00    0000                   00
            0xC3, 0xC0, 0x00, 0x06, ##  00    0000                   00
            0xC3, 0xC0, 0x00, 0x06, ##  00    0000                   00
            0xC3, 0xC0, 0x00, 0x06, ##  00    0000                   00
            0xC3, 0xE0, 0x00, 0x06, ##  00    00000                  00
            0xE1, 0xE0, 0x00, 0x0E, ##  000    0000                 000
            0x61, 0xF0, 0x00, 0x0C, ##   00    00000                00 
            0x60, 0xFC, 0x0C, 0x0C, ##   00     000000      00      00 
            0x30, 0x7F, 0xFC, 0x18, ##    00     0000000000000     00  
            0x38, 0x3F, 0xFC, 0x38, ##    000     000000000000    000  
            0x18, 0x0F, 0xF0, 0x30, ##     00       00000000      00   
            0x0C, 0x00, 0x00, 0x60, ##      00                   00    
            0x07, 0x00, 0x01, 0xC0, ##       000               000     
            0x03, 0x80, 0x03, 0x80, ##        000             000      
            0x01, 0xF0, 0x1F, 0x00, ##         00000       00000       
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000         
            0x00, 0x1F, 0xF0, 0x00, ##             000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '170' => {    # 'ª'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xE0, ##     00000000    
            0x3F, 0xF8, ##    00000000000  
            0x30, 0x3C, ##    00      0000 
            0x00, 0x1C, ##             000 
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x0F, 0xFE, ##      00000000000
            0x3F, 0xFE, ##    0000000000000
            0x78, 0x0E, ##   0000       000
            0xF0, 0x0E, ##  0000        000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x1E, ##  000        0000
            0xF0, 0x3E, ##  0000      00000
            0x78, 0x7E, ##   0000    000000
            0x3F, 0xEE, ##    000000000 000
            0x1F, 0x8E, ##     000000   000
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x7F, 0xFE, ##   00000000000000
            0x7F, 0xFE, ##   00000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '171' => {    # '«'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x40, 0x20, ##           0        0
            0x00, 0xC0, 0x60, ##          00       00
            0x01, 0xC0, 0xE0, ##         000      000
            0x03, 0xC1, 0xE0, ##        0000     0000
            0x07, 0x83, 0xC0, ##       0000     0000 
            0x0F, 0x07, 0x80, ##      0000     0000  
            0x3E, 0x1F, 0x00, ##    00000    00000   
            0x7C, 0x3E, 0x00, ##   00000    00000    
            0xF8, 0x7C, 0x00, ##  00000    00000     
            0xF0, 0x78, 0x00, ##  0000     0000      
            0xF8, 0x7C, 0x00, ##  00000    00000     
            0x7C, 0x3E, 0x00, ##   00000    00000    
            0x1E, 0x0F, 0x00, ##     0000     0000   
            0x0F, 0x07, 0x80, ##      0000     0000  
            0x07, 0x83, 0xC0, ##       0000     0000 
            0x03, 0xC1, 0xE0, ##        0000     0000
            0x01, 0xC0, 0xE0, ##         000      000
            0x00, 0xC0, 0x60, ##          00       00
            0x00, 0x40, 0x20, ##           0        0
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '172' => {    # '¬'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '173' => {    # '­'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '174' => {    # '®'
        'width'    => 31, 
        'xoffset'  => 6, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xE0, 0x00, ##              0000000            
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000         
            0x01, 0xF0, 0x1F, 0x00, ##         00000       00000       
            0x03, 0x80, 0x03, 0x80, ##        000             000      
            0x07, 0x00, 0x01, 0xC0, ##       000               000     
            0x0E, 0x00, 0x00, 0x60, ##      000                  00    
            0x1C, 0x00, 0x00, 0x30, ##     000                    00   
            0x38, 0x7F, 0xE0, 0x38, ##    000    0000000000       000  
            0x30, 0x7F, 0xFC, 0x18, ##    00     0000000000000     00  
            0x60, 0x70, 0x3E, 0x0C, ##   00      000      00000     00 
            0x60, 0x70, 0x1E, 0x0C, ##   00      000       0000     00 
            0xE0, 0x70, 0x1E, 0x0C, ##  000      000       0000     00 
            0xC0, 0x70, 0x1E, 0x06, ##  00       000       0000      00
            0xC0, 0x70, 0x3C, 0x06, ##  00       000      0000       00
            0xC0, 0x7F, 0xF8, 0x06, ##  00       000000000000        00
            0xC0, 0x7F, 0xC0, 0x06, ##  00       000000000           00
            0xC0, 0x71, 0xE0, 0x06, ##  00       000   0000          00
            0xC0, 0x70, 0xF0, 0x06, ##  00       000    0000         00
            0xC0, 0x70, 0x78, 0x06, ##  00       000     0000        00
            0xE0, 0x70, 0x3C, 0x0E, ##  000      000      0000      000
            0x60, 0x70, 0x3C, 0x0C, ##   00      000      0000      00 
            0x60, 0x70, 0x1E, 0x0C, ##   00      000       0000     00 
            0x30, 0x70, 0x0F, 0x18, ##    00     000        0000   00  
            0x38, 0x70, 0x0F, 0x38, ##    000    000        0000  000  
            0x18, 0x00, 0x00, 0x30, ##     00                     00   
            0x0C, 0x00, 0x00, 0x60, ##      00                   00    
            0x07, 0x00, 0x01, 0xC0, ##       000               000     
            0x03, 0x80, 0x03, 0x80, ##        000             000      
            0x01, 0xF0, 0x1F, 0x00, ##         00000       00000       
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000         
            0x00, 0x1F, 0xF0, 0x00, ##             000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '175' => {    # '¯'
        'width'    => 13, 
        'xoffset'  => 4, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 13, 
        'xoffset'  => 4, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000    
            0x3F, 0xE0, ##    000000000  
            0x7F, 0xF0, ##   00000000000 
            0x78, 0xF0, ##   0000   0000 
            0xF0, 0x78, ##  0000     0000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xF0, 0x78, ##  0000     0000
            0x78, 0xF0, ##   0000   0000 
            0x7F, 0xF0, ##   00000000000 
            0x3F, 0xE0, ##    000000000  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '177' => {    # '±'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x1E, 0x00, 0x00, ##             0000            
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '178' => {    # '²'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x00, ##    000000    
            0xFF, 0xC0, ##  0000000000  
            0xC1, 0xE0, ##  00     0000 
            0x00, 0xF0, ##          0000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0xE0, ##          000 
            0x01, 0xE0, ##         0000 
            0x03, 0xC0, ##        0000  
            0x03, 0x80, ##        000   
            0x07, 0x00, ##       000    
            0x0E, 0x00, ##      000     
            0x1C, 0x00, ##     000      
            0x38, 0x00, ##    000       
            0x70, 0x00, ##   000        
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '179' => {    # '³'
        'width'    => 13, 
        'xoffset'  => 3, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7F, 0x80, ##   00000000    
            0xFF, 0xE0, ##  00000000000  
            0xC0, 0xE0, ##  00      000  
            0x00, 0x70, ##           000 
            0x00, 0x70, ##           000 
            0x00, 0x70, ##           000 
            0x00, 0xE0, ##          000  
            0x1F, 0xC0, ##     0000000   
            0x1F, 0x80, ##     000000    
            0x00, 0xE0, ##          000  
            0x00, 0x70, ##           000 
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x78, ##           0000
            0x80, 0xF0, ##  0       0000 
            0xFF, 0xE0, ##  00000000000  
            0x7F, 0x80, ##   00000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '180' => {    # '´'
        'width'    => 10, 
        'xoffset'  => 8, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x0F, 0x00, ##      0000  
            0x1E, 0x00, ##     0000   
            0x3C, 0x00, ##    0000    
            0x38, 0x00, ##    000     
            0x70, 0x00, ##   000      
            0xE0, 0x00, ##  000       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '181' => {    # 'µ'
        'width'    => 23, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x00, 0xF0, ##  0000            0000   
            0xF0, 0x01, 0xF0, ##  0000           00000   
            0xF8, 0x01, 0xF0, ##  00000          00000   
            0xFC, 0x03, 0xF0, ##  000000        000000   
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0xF7, 0xFE, 0xFE, ##  0000 0000000000 0000000
            0xF3, 0xFC, 0x7E, ##  0000  00000000   000000
            0xF0, 0x00, 0x00, ##  0000                   
            0xF0, 0x00, 0x00, ##  0000                   
            0xF0, 0x00, 0x00, ##  0000                   
            0xF0, 0x00, 0x00, ##  0000                   
            0xF0, 0x00, 0x00, ##  0000                   
            0xF0, 0x00, 0x00, ##  0000                   
            0xF0, 0x00, 0x00, ##  0000                   
            0xF0, 0x00, 0x00, ##  0000                   
            0xF0, 0x00, 0x00, ##  0000                   
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '182' => {    # '¶'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xFF, 0xE0, ##        0000000000000
            0x0F, 0xFF, 0xE0, ##      000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x7F, 0xF0, 0xE0, ##   00000000000    000
            0x7F, 0xF0, 0xE0, ##   00000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0xFF, 0xF0, 0xE0, ##  000000000000    000
            0x7F, 0xF0, 0xE0, ##   00000000000    000
            0x3F, 0xF0, 0xE0, ##    0000000000    000
            0x1F, 0xF0, 0xE0, ##     000000000    000
            0x03, 0xF0, 0xE0, ##        000000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x70, 0xE0, ##           000    000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '183' => {    # '·'
        'width'    => 4, 
        'xoffset'  => 5, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '184' => {    # '¸'
        'width'    => 8, 
        'xoffset'  => 7, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x1C, ##     000  
            0x0C, ##      00  
            0x06, ##       00 
            0x07, ##       000
            0x07, ##       000
            0x0F, ##      0000
            0xFF, ##  00000000
            0xFE, ##  0000000 
            0xFC, ##  000000  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '185' => {    # '¹'
        'width'    => 12, 
        'xoffset'  => 3, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7E, 0x00, ##   000000     
            0xFE, 0x00, ##  0000000     
            0xFE, 0x00, ##  0000000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '186' => {    # 'º'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000     
            0x1F, 0xF8, ##     0000000000   
            0x3C, 0x3C, ##    0000    0000  
            0x78, 0x1E, ##   0000      0000 
            0x70, 0x0E, ##   000        000 
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0x70, 0x0E, ##   000        000 
            0x78, 0x1E, ##   0000      0000 
            0x3C, 0x3C, ##    0000    0000  
            0x1F, 0xF8, ##     0000000000   
            0x07, 0xE0, ##       000000     
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0x7F, 0xFE, ##   00000000000000 
            0x7F, 0xFE, ##   00000000000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '187' => {    # '»'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x80, 0x40, 0x00, ##  0        0         
            0xC0, 0x60, 0x00, ##  00       00        
            0xE0, 0x70, 0x00, ##  000      000       
            0xF0, 0x78, 0x00, ##  0000     0000      
            0x78, 0x3C, 0x00, ##   0000     0000     
            0x3C, 0x1E, 0x00, ##    0000     0000    
            0x1F, 0x0F, 0x80, ##     00000    00000  
            0x0F, 0x87, 0xC0, ##      00000    00000 
            0x07, 0xC3, 0xE0, ##       00000    00000
            0x03, 0xC1, 0xE0, ##        0000     0000
            0x07, 0xC3, 0xE0, ##       00000    00000
            0x0F, 0x87, 0xC0, ##      00000    00000 
            0x1E, 0x0F, 0x00, ##     0000     0000   
            0x3C, 0x1E, 0x00, ##    0000     0000    
            0x78, 0x3C, 0x00, ##   0000     0000     
            0xF0, 0x78, 0x00, ##  0000     0000      
            0xE0, 0x70, 0x00, ##  000      000       
            0xC0, 0x60, 0x00, ##  00       00        
            0x80, 0x40, 0x00, ##  0        0         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '188' => {    # '¼'
        'width'    => 37, 
        'xoffset'  => 3, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x0E, 0x00, 0x00, 0x78, 0x00, ##      000                  0000        
            0xFE, 0x00, 0x00, 0x70, 0x00, ##  0000000                  000         
            0xFE, 0x00, 0x00, 0xE0, 0x00, ##  0000000                 000          
            0x8E, 0x00, 0x00, 0xE0, 0x00, ##  0   000                 000          
            0x0E, 0x00, 0x01, 0xC0, 0x00, ##      000                000           
            0x0E, 0x00, 0x03, 0xC0, 0x00, ##      000               0000           
            0x0E, 0x00, 0x03, 0x80, 0x00, ##      000               000            
            0x0E, 0x00, 0x07, 0x00, 0x00, ##      000              000             
            0x0E, 0x00, 0x0F, 0x00, 0x00, ##      000             0000             
            0x0E, 0x00, 0x0E, 0x00, 0x00, ##      000             000              
            0x0E, 0x00, 0x1E, 0x00, 0x00, ##      000            0000              
            0x0E, 0x00, 0x1C, 0x00, 0x00, ##      000            000               
            0x0E, 0x00, 0x38, 0x00, 0x00, ##      000           000                
            0x0E, 0x00, 0x78, 0x00, 0x00, ##      000          0000                
            0x0E, 0x00, 0x70, 0x01, 0xC0, ##      000          000           000   
            0xFF, 0xF0, 0xF0, 0x03, 0xC0, ##  000000000000    0000          0000   
            0xFF, 0xF0, 0xE0, 0x07, 0xC0, ##  000000000000    000          00000   
            0xFF, 0xF1, 0xC0, 0x0D, 0xC0, ##  000000000000   000          00 000   
            0x00, 0x03, 0xC0, 0x1D, 0xC0, ##                0000         000 000   
            0x00, 0x03, 0x80, 0x19, 0xC0, ##                000          00  000   
            0x00, 0x07, 0x80, 0x31, 0xC0, ##               0000         00   000   
            0x00, 0x07, 0x00, 0x61, 0xC0, ##               000         00    000   
            0x00, 0x0E, 0x00, 0xE1, 0xC0, ##              000         000    000   
            0x00, 0x1E, 0x00, 0xC1, 0xC0, ##             0000         00     000   
            0x00, 0x1C, 0x01, 0x81, 0xC0, ##             000         00      000   
            0x00, 0x3C, 0x01, 0xFF, 0xF8, ##            0000         00000000000000
            0x00, 0x78, 0x01, 0xFF, 0xF8, ##           0000          00000000000000
            0x00, 0x70, 0x01, 0xFF, 0xF8, ##           000           00000000000000
            0x00, 0xF0, 0x00, 0x01, 0xC0, ##          0000                   000   
            0x00, 0xE0, 0x00, 0x01, 0xC0, ##          000                    000   
            0x01, 0xE0, 0x00, 0x01, 0xC0, ##         0000                    000   
            0x03, 0xC0, 0x00, 0x01, 0xC0, ##        0000                     000   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '189' => {    # '½'
        'width'    => 36, 
        'xoffset'  => 3, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x0E, 0x00, 0x00, 0x70, 0x00, ##      000                  000        
            0xFE, 0x00, 0x00, 0x70, 0x00, ##  0000000                  000        
            0xFE, 0x00, 0x00, 0xE0, 0x00, ##  0000000                 000         
            0x8E, 0x00, 0x01, 0xE0, 0x00, ##  0   000                0000         
            0x0E, 0x00, 0x01, 0xC0, 0x00, ##      000                000          
            0x0E, 0x00, 0x03, 0x80, 0x00, ##      000               000           
            0x0E, 0x00, 0x03, 0x80, 0x00, ##      000               000           
            0x0E, 0x00, 0x07, 0x00, 0x00, ##      000              000            
            0x0E, 0x00, 0x0F, 0x00, 0x00, ##      000             0000            
            0x0E, 0x00, 0x0E, 0x00, 0x00, ##      000             000             
            0x0E, 0x00, 0x1E, 0x00, 0x00, ##      000            0000             
            0x0E, 0x00, 0x3C, 0x00, 0x00, ##      000           0000              
            0x0E, 0x00, 0x38, 0x00, 0x00, ##      000           000               
            0x0E, 0x00, 0x78, 0x00, 0x00, ##      000          0000               
            0x0E, 0x00, 0x70, 0xFF, 0x00, ##      000          000    00000000    
            0xFF, 0xF0, 0xF1, 0xFF, 0xC0, ##  000000000000    0000   00000000000  
            0xFF, 0xF1, 0xE1, 0xFF, 0xE0, ##  000000000000   0000    000000000000 
            0xFF, 0xF1, 0xC1, 0x83, 0xF0, ##  000000000000   000     00     000000
            0x00, 0x03, 0xC0, 0x00, 0xF0, ##                0000              0000
            0x00, 0x03, 0x80, 0x00, 0xF0, ##                000               0000
            0x00, 0x07, 0x80, 0x00, 0xF0, ##               0000               0000
            0x00, 0x0F, 0x00, 0x01, 0xE0, ##              0000               0000 
            0x00, 0x0E, 0x00, 0x03, 0xC0, ##              000               0000  
            0x00, 0x1E, 0x00, 0x07, 0x80, ##             0000              0000   
            0x00, 0x1C, 0x00, 0x0F, 0x00, ##             000              0000    
            0x00, 0x3C, 0x00, 0x1E, 0x00, ##            0000             0000     
            0x00, 0x78, 0x00, 0x3C, 0x00, ##           0000             0000      
            0x00, 0x70, 0x00, 0x78, 0x00, ##           000             0000       
            0x00, 0xF0, 0x00, 0xE0, 0x00, ##          0000            000         
            0x00, 0xE0, 0x01, 0xFF, 0xF0, ##          000            0000000000000
            0x01, 0xE0, 0x01, 0xFF, 0xF0, ##         0000            0000000000000
            0x03, 0xC0, 0x01, 0xFF, 0xF0, ##        0000             0000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '190' => {    # '¾'
        'width'    => 38, 
        'xoffset'  => 3, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x3F, 0x80, 0x00, 0x3C, 0x00, ##    0000000                 0000        
            0xFF, 0xC0, 0x00, 0x38, 0x00, ##  0000000000                000         
            0xFF, 0xE0, 0x00, 0x70, 0x00, ##  00000000000              000          
            0x80, 0xF0, 0x00, 0xF0, 0x00, ##  0       0000            0000          
            0x00, 0x70, 0x00, 0xE0, 0x00, ##           000            000           
            0x00, 0x70, 0x01, 0xE0, 0x00, ##           000           0000           
            0x00, 0xF0, 0x01, 0xC0, 0x00, ##          0000           000            
            0x1F, 0xE0, 0x03, 0x80, 0x00, ##     00000000           000             
            0x1F, 0x80, 0x07, 0x80, 0x00, ##     000000            0000             
            0x1F, 0xC0, 0x07, 0x00, 0x00, ##     0000000           000              
            0x00, 0xF0, 0x0F, 0x00, 0x00, ##          0000        0000              
            0x00, 0x38, 0x0E, 0x00, 0x00, ##            000       000               
            0x00, 0x38, 0x1C, 0x00, 0x00, ##            000      000                
            0x00, 0x38, 0x3C, 0x00, 0x00, ##            000     0000                
            0x00, 0x78, 0x38, 0x00, 0x00, ##           0000     000                 
            0x80, 0xF8, 0x78, 0x01, 0xE0, ##  0       00000    0000          0000   
            0xFF, 0xF0, 0x70, 0x03, 0xE0, ##  000000000000     000          00000   
            0xFF, 0xE0, 0xF0, 0x07, 0xE0, ##  00000000000     0000         000000   
            0x7F, 0x81, 0xE0, 0x0E, 0xE0, ##   00000000      0000         000 000   
            0x00, 0x01, 0xC0, 0x0C, 0xE0, ##                 000          00  000   
            0x00, 0x03, 0xC0, 0x18, 0xE0, ##                0000         00   000   
            0x00, 0x03, 0x80, 0x38, 0xE0, ##                000         000   000   
            0x00, 0x07, 0x80, 0x70, 0xE0, ##               0000        000    000   
            0x00, 0x0F, 0x00, 0xE0, 0xE0, ##              0000        000     000   
            0x00, 0x0E, 0x00, 0xC0, 0xE0, ##              000         00      000   
            0x00, 0x1E, 0x01, 0xFF, 0xFC, ##             0000        000000000000000
            0x00, 0x1C, 0x01, 0xFF, 0xFC, ##             000         000000000000000
            0x00, 0x3C, 0x01, 0xFF, 0xFC, ##            0000         000000000000000
            0x00, 0x78, 0x00, 0x00, 0xE0, ##           0000                   000   
            0x00, 0x70, 0x00, 0x00, 0xE0, ##           000                    000   
            0x00, 0xF0, 0x00, 0x00, 0xE0, ##          0000                    000   
            0x01, 0xE0, 0x00, 0x00, 0xE0, ##         0000                     000   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '191' => {    # '¿'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x03, 0xE0, 0x00, ##        00000      
            0x07, 0xC0, 0x00, ##       00000       
            0x07, 0xC0, 0x00, ##       00000       
            0x0F, 0x80, 0x00, ##      00000        
            0x1F, 0x00, 0x00, ##     00000         
            0x3E, 0x00, 0x00, ##    00000          
            0x7C, 0x00, 0x00, ##   00000           
            0x78, 0x00, 0x00, ##   0000            
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF0, 0x00, 0x00, ##  0000             
            0xF8, 0x01, 0x80, ##  00000          00
            0x7C, 0x07, 0x80, ##   00000       0000
            0x7F, 0xFF, 0x80, ##   0000000000000000
            0x3F, 0xFF, 0x00, ##    00000000000000 
            0x0F, 0xFC, 0x00, ##      0000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '192' => {    # 'À'
        'width'    => 29, 
        'xoffset'  => 0, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x3C, 0x00, 0x00, ##            0000               
            0x00, 0x3C, 0x00, 0x00, ##            0000               
            0x00, 0x1E, 0x00, 0x00, ##             0000              
            0x00, 0x0F, 0x00, 0x00, ##              0000             
            0x00, 0x07, 0x00, 0x00, ##               000             
            0x00, 0x03, 0x80, 0x00, ##                000            
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x0F, 0x80, 0x00, ##              00000            
            0x00, 0x0F, 0xC0, 0x00, ##              000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xE0, 0x00, ##             00000000          
            0x00, 0x3D, 0xE0, 0x00, ##            0000 0000          
            0x00, 0x3D, 0xF0, 0x00, ##            0000 00000         
            0x00, 0x7C, 0xF0, 0x00, ##           00000  0000         
            0x00, 0x78, 0xF0, 0x00, ##           0000   0000         
            0x00, 0x78, 0x78, 0x00, ##           0000    0000        
            0x00, 0xF0, 0x78, 0x00, ##          0000     0000        
            0x00, 0xF0, 0x7C, 0x00, ##          0000     00000       
            0x01, 0xF0, 0x3C, 0x00, ##         00000      0000       
            0x01, 0xE0, 0x3C, 0x00, ##         0000       0000       
            0x01, 0xE0, 0x3E, 0x00, ##         0000       00000      
            0x03, 0xE0, 0x1E, 0x00, ##        00000        0000      
            0x03, 0xC0, 0x1E, 0x00, ##        0000         0000      
            0x03, 0xC0, 0x0F, 0x00, ##        0000          0000     
            0x07, 0xC0, 0x0F, 0x00, ##       00000          0000     
            0x07, 0x80, 0x0F, 0x80, ##       0000           00000    
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000    
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000    
            0x0F, 0xFF, 0xFF, 0xC0, ##      0000000000000000000000   
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x1E, 0x00, 0x03, 0xE0, ##     0000               00000  
            0x3E, 0x00, 0x01, 0xE0, ##    00000                0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xF0, ##    0000                 00000 
            0x7C, 0x00, 0x00, 0xF0, ##   00000                  0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF8, ##   0000                   00000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '193' => {    # 'Á'
        'width'    => 29, 
        'xoffset'  => 0, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0xF0, 0x00, ##                  0000         
            0x00, 0x01, 0xE0, 0x00, ##                 0000          
            0x00, 0x03, 0xC0, 0x00, ##                0000           
            0x00, 0x03, 0x80, 0x00, ##                000            
            0x00, 0x07, 0x00, 0x00, ##               000             
            0x00, 0x0E, 0x00, 0x00, ##              000              
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x0F, 0x80, 0x00, ##              00000            
            0x00, 0x0F, 0xC0, 0x00, ##              000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xE0, 0x00, ##             00000000          
            0x00, 0x3D, 0xE0, 0x00, ##            0000 0000          
            0x00, 0x3D, 0xF0, 0x00, ##            0000 00000         
            0x00, 0x7C, 0xF0, 0x00, ##           00000  0000         
            0x00, 0x78, 0xF0, 0x00, ##           0000   0000         
            0x00, 0x78, 0x78, 0x00, ##           0000    0000        
            0x00, 0xF0, 0x78, 0x00, ##          0000     0000        
            0x00, 0xF0, 0x7C, 0x00, ##          0000     00000       
            0x01, 0xF0, 0x3C, 0x00, ##         00000      0000       
            0x01, 0xE0, 0x3C, 0x00, ##         0000       0000       
            0x01, 0xE0, 0x3E, 0x00, ##         0000       00000      
            0x03, 0xE0, 0x1E, 0x00, ##        00000        0000      
            0x03, 0xC0, 0x1E, 0x00, ##        0000         0000      
            0x03, 0xC0, 0x0F, 0x00, ##        0000          0000     
            0x07, 0xC0, 0x0F, 0x00, ##       00000          0000     
            0x07, 0x80, 0x0F, 0x80, ##       0000           00000    
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000    
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000    
            0x0F, 0xFF, 0xFF, 0xC0, ##      0000000000000000000000   
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x1E, 0x00, 0x03, 0xE0, ##     0000               00000  
            0x3E, 0x00, 0x01, 0xE0, ##    00000                0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xF0, ##    0000                 00000 
            0x7C, 0x00, 0x00, 0xF0, ##   00000                  0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF8, ##   0000                   00000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '194' => {    # 'Â'
        'width'    => 29, 
        'xoffset'  => 0, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x0F, 0x80, 0x00, ##              00000            
            0x00, 0x0F, 0xC0, 0x00, ##              000000           
            0x00, 0x1D, 0xE0, 0x00, ##             000 0000          
            0x00, 0x38, 0xE0, 0x00, ##            000   000          
            0x00, 0x78, 0x70, 0x00, ##           0000    000         
            0x00, 0x70, 0x38, 0x00, ##           000      000        
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x0F, 0x80, 0x00, ##              00000            
            0x00, 0x0F, 0xC0, 0x00, ##              000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xE0, 0x00, ##             00000000          
            0x00, 0x3D, 0xE0, 0x00, ##            0000 0000          
            0x00, 0x3D, 0xF0, 0x00, ##            0000 00000         
            0x00, 0x7C, 0xF0, 0x00, ##           00000  0000         
            0x00, 0x78, 0xF0, 0x00, ##           0000   0000         
            0x00, 0x78, 0x78, 0x00, ##           0000    0000        
            0x00, 0xF0, 0x78, 0x00, ##          0000     0000        
            0x00, 0xF0, 0x7C, 0x00, ##          0000     00000       
            0x01, 0xF0, 0x3C, 0x00, ##         00000      0000       
            0x01, 0xE0, 0x3C, 0x00, ##         0000       0000       
            0x01, 0xE0, 0x3E, 0x00, ##         0000       00000      
            0x03, 0xE0, 0x1E, 0x00, ##        00000        0000      
            0x03, 0xC0, 0x1E, 0x00, ##        0000         0000      
            0x03, 0xC0, 0x0F, 0x00, ##        0000          0000     
            0x07, 0xC0, 0x0F, 0x00, ##       00000          0000     
            0x07, 0x80, 0x0F, 0x80, ##       0000           00000    
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000    
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000    
            0x0F, 0xFF, 0xFF, 0xC0, ##      0000000000000000000000   
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x1E, 0x00, 0x03, 0xE0, ##     0000               00000  
            0x3E, 0x00, 0x01, 0xE0, ##    00000                0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xF0, ##    0000                 00000 
            0x7C, 0x00, 0x00, 0xF0, ##   00000                  0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF8, ##   0000                   00000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '195' => {    # 'Ã'
        'width'    => 28, 
        'xoffset'  => 1, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x78, 0x38, 0x00, ##           0000     000       
            0x00, 0xFE, 0x38, 0x00, ##          0000000   000       
            0x01, 0xFF, 0xF8, 0x00, ##         00000000000000       
            0x01, 0xC7, 0xF0, 0x00, ##         000   0000000        
            0x01, 0xC1, 0xE0, 0x00, ##         000     0000         
            0x00, 0x00, 0x00, 0x00, ##                              
            0x00, 0x00, 0x00, 0x00, ##                              
            0x00, 0x00, 0x00, 0x00, ##                              
            0x00, 0x00, 0x00, 0x00, ##                              
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x3F, 0xC0, 0x00, ##            00000000          
            0x00, 0x3F, 0xC0, 0x00, ##            00000000          
            0x00, 0x3F, 0xC0, 0x00, ##            00000000          
            0x00, 0x79, 0xE0, 0x00, ##           0000  0000         
            0x00, 0x79, 0xE0, 0x00, ##           0000  0000         
            0x00, 0xF9, 0xF0, 0x00, ##          00000  00000        
            0x00, 0xF0, 0xF0, 0x00, ##          0000    0000        
            0x00, 0xF0, 0xF0, 0x00, ##          0000    0000        
            0x01, 0xE0, 0x78, 0x00, ##         0000      0000       
            0x01, 0xE0, 0x78, 0x00, ##         0000      0000       
            0x03, 0xE0, 0x7C, 0x00, ##        00000      00000      
            0x03, 0xC0, 0x3C, 0x00, ##        0000        0000      
            0x03, 0xC0, 0x3C, 0x00, ##        0000        0000      
            0x07, 0xC0, 0x3E, 0x00, ##       00000        00000     
            0x07, 0x80, 0x1E, 0x00, ##       0000          0000     
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000    
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000    
            0x0F, 0xFF, 0xFF, 0x00, ##      00000000000000000000    
            0x1F, 0xFF, 0xFF, 0x80, ##     0000000000000000000000   
            0x1F, 0xFF, 0xFF, 0x80, ##     0000000000000000000000   
            0x1E, 0x00, 0x07, 0xC0, ##     0000              00000  
            0x3C, 0x00, 0x03, 0xC0, ##    0000                0000  
            0x3C, 0x00, 0x03, 0xC0, ##    0000                0000  
            0x7C, 0x00, 0x03, 0xE0, ##   00000                00000 
            0x78, 0x00, 0x01, 0xE0, ##   0000                  0000 
            0x78, 0x00, 0x01, 0xE0, ##   0000                  0000 
            0xF8, 0x00, 0x00, 0xF0, ##  00000                   0000
            0xF0, 0x00, 0x00, 0xF0, ##  0000                    0000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '196' => {    # 'Ä'
        'width'    => 28, 
        'xoffset'  => 0, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0xF0, 0x00, ##          0000    0000        
            0x00, 0xF0, 0xF0, 0x00, ##          0000    0000        
            0x00, 0xF0, 0xF0, 0x00, ##          0000    0000        
            0x00, 0xF0, 0xF0, 0x00, ##          0000    0000        
            0x00, 0x00, 0x00, 0x00, ##                              
            0x00, 0x00, 0x00, 0x00, ##                              
            0x00, 0x00, 0x00, 0x00, ##                              
            0x00, 0x00, 0x00, 0x00, ##                              
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x3F, 0xC0, 0x00, ##            00000000          
            0x00, 0x3F, 0xC0, 0x00, ##            00000000          
            0x00, 0x3F, 0xC0, 0x00, ##            00000000          
            0x00, 0x79, 0xE0, 0x00, ##           0000  0000         
            0x00, 0x79, 0xE0, 0x00, ##           0000  0000         
            0x00, 0xF9, 0xF0, 0x00, ##          00000  00000        
            0x00, 0xF0, 0xF0, 0x00, ##          0000    0000        
            0x00, 0xF0, 0xF0, 0x00, ##          0000    0000        
            0x01, 0xF0, 0x78, 0x00, ##         00000     0000       
            0x01, 0xE0, 0x78, 0x00, ##         0000      0000       
            0x03, 0xE0, 0x7C, 0x00, ##        00000      00000      
            0x03, 0xC0, 0x3C, 0x00, ##        0000        0000      
            0x03, 0xC0, 0x3C, 0x00, ##        0000        0000      
            0x07, 0xC0, 0x3E, 0x00, ##       00000        00000     
            0x07, 0x80, 0x1E, 0x00, ##       0000          0000     
            0x07, 0x80, 0x1E, 0x00, ##       0000          0000     
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000    
            0x0F, 0xFF, 0xFF, 0x00, ##      00000000000000000000    
            0x1F, 0xFF, 0xFF, 0x80, ##     0000000000000000000000   
            0x1F, 0xFF, 0xFF, 0x80, ##     0000000000000000000000   
            0x1E, 0x00, 0x07, 0x80, ##     0000              0000   
            0x3E, 0x00, 0x07, 0xC0, ##    00000              00000  
            0x3C, 0x00, 0x03, 0xC0, ##    0000                0000  
            0x3C, 0x00, 0x03, 0xC0, ##    0000                0000  
            0x7C, 0x00, 0x03, 0xE0, ##   00000                00000 
            0x78, 0x00, 0x01, 0xE0, ##   0000                  0000 
            0xF8, 0x00, 0x01, 0xF0, ##  00000                  00000
            0xF8, 0x00, 0x00, 0xF0, ##  00000                   0000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '197' => {    # 'Å'
        'width'    => 30, 
        'xoffset'  => 0, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x0F, 0x80, 0x00, ##              00000             
            0x00, 0x1F, 0xE0, 0x00, ##             00000000           
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x00, 0x78, 0x78, 0x00, ##           0000    0000         
            0x00, 0x70, 0x38, 0x00, ##           000      000         
            0x00, 0x70, 0x38, 0x00, ##           000      000         
            0x00, 0x70, 0x38, 0x00, ##           000      000         
            0x00, 0x70, 0x38, 0x00, ##           000      000         
            0x00, 0x38, 0x70, 0x00, ##            000    000          
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x00, 0x1F, 0xE0, 0x00, ##             00000000           
            0x00, 0x1F, 0xE0, 0x00, ##             00000000           
            0x00, 0x1F, 0xE0, 0x00, ##             00000000           
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x00, 0x3C, 0xF0, 0x00, ##            0000  0000          
            0x00, 0x7C, 0xF8, 0x00, ##           00000  00000         
            0x00, 0x78, 0x78, 0x00, ##           0000    0000         
            0x00, 0x78, 0x78, 0x00, ##           0000    0000         
            0x00, 0xF8, 0x7C, 0x00, ##          00000    00000        
            0x00, 0xF0, 0x3C, 0x00, ##          0000      0000        
            0x01, 0xF0, 0x3E, 0x00, ##         00000      00000       
            0x01, 0xF0, 0x3E, 0x00, ##         00000      00000       
            0x01, 0xE0, 0x1E, 0x00, ##         0000        0000       
            0x03, 0xE0, 0x1F, 0x00, ##        00000        00000      
            0x03, 0xC0, 0x0F, 0x00, ##        0000          0000      
            0x03, 0xC0, 0x0F, 0x00, ##        0000          0000      
            0x07, 0xC0, 0x0F, 0x80, ##       00000          00000     
            0x07, 0x80, 0x07, 0x80, ##       0000            0000     
            0x0F, 0xFF, 0xFF, 0xC0, ##      0000000000000000000000    
            0x0F, 0xFF, 0xFF, 0xC0, ##      0000000000000000000000    
            0x0F, 0xFF, 0xFF, 0xC0, ##      0000000000000000000000    
            0x1F, 0x00, 0x01, 0xE0, ##     00000               0000   
            0x1E, 0x00, 0x01, 0xE0, ##     0000                0000   
            0x3E, 0x00, 0x01, 0xF0, ##    00000                00000  
            0x3C, 0x00, 0x00, 0xF0, ##    0000                  0000  
            0x3C, 0x00, 0x00, 0xF0, ##    0000                  0000  
            0x7C, 0x00, 0x00, 0xF8, ##   00000                  00000 
            0x78, 0x00, 0x00, 0x78, ##   0000                    0000 
            0x78, 0x00, 0x00, 0x78, ##   0000                    0000 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '198' => {    # 'Æ'
        'width'    => 39, 
        'xoffset'  => 0, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xFF, 0xFF, 0xFE, ##               00000000000000000000000000
            0x00, 0x07, 0xFF, 0xFF, 0xFE, ##               00000000000000000000000000
            0x00, 0x0F, 0xFF, 0xFF, 0xFE, ##              000000000000000000000000000
            0x00, 0x0F, 0x1E, 0x00, 0x00, ##              0000   0000                
            0x00, 0x1F, 0x1E, 0x00, 0x00, ##             00000   0000                
            0x00, 0x1E, 0x1E, 0x00, 0x00, ##             0000    0000                
            0x00, 0x1E, 0x1E, 0x00, 0x00, ##             0000    0000                
            0x00, 0x3C, 0x1E, 0x00, 0x00, ##            0000     0000                
            0x00, 0x3C, 0x1E, 0x00, 0x00, ##            0000     0000                
            0x00, 0x7C, 0x1E, 0x00, 0x00, ##           00000     0000                
            0x00, 0x78, 0x1E, 0x00, 0x00, ##           0000      0000                
            0x00, 0xF8, 0x1E, 0x00, 0x00, ##          00000      0000                
            0x00, 0xF0, 0x1E, 0x00, 0x00, ##          0000       0000                
            0x00, 0xF0, 0x1F, 0xFF, 0xFC, ##          0000       0000000000000000000 
            0x01, 0xF0, 0x1F, 0xFF, 0xFC, ##         00000       0000000000000000000 
            0x01, 0xE0, 0x1F, 0xFF, 0xFC, ##         0000        0000000000000000000 
            0x03, 0xE0, 0x1E, 0x00, 0x00, ##        00000        0000                
            0x03, 0xC0, 0x1E, 0x00, 0x00, ##        0000         0000                
            0x03, 0xC0, 0x1E, 0x00, 0x00, ##        0000         0000                
            0x07, 0xC0, 0x1E, 0x00, 0x00, ##       00000         0000                
            0x07, 0xFF, 0xFE, 0x00, 0x00, ##       000000000000000000                
            0x0F, 0xFF, 0xFE, 0x00, 0x00, ##      0000000000000000000                
            0x0F, 0xFF, 0xFE, 0x00, 0x00, ##      0000000000000000000                
            0x1F, 0x00, 0x1E, 0x00, 0x00, ##     00000           0000                
            0x1E, 0x00, 0x1E, 0x00, 0x00, ##     0000            0000                
            0x1E, 0x00, 0x1E, 0x00, 0x00, ##     0000            0000                
            0x3C, 0x00, 0x1E, 0x00, 0x00, ##    0000             0000                
            0x3C, 0x00, 0x1E, 0x00, 0x00, ##    0000             0000                
            0x7C, 0x00, 0x1F, 0xFF, 0xFE, ##   00000             00000000000000000000
            0x78, 0x00, 0x1F, 0xFF, 0xFE, ##   0000              00000000000000000000
            0xF8, 0x00, 0x1F, 0xFF, 0xFE, ##  00000              00000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '199' => {    # 'Ç'
        'width'    => 26, 
        'xoffset'  => 2, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000    
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000  
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000
            0x0F, 0xC0, 0x07, 0xC0, ##      000000           00000
            0x1F, 0x00, 0x01, 0xC0, ##     00000               000
            0x1E, 0x00, 0x00, 0xC0, ##     0000                 00
            0x3C, 0x00, 0x00, 0x40, ##    0000                   0
            0x3C, 0x00, 0x00, 0x00, ##    0000                    
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0xF0, 0x00, 0x00, 0x00, ##  0000                      
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0x78, 0x00, 0x00, 0x00, ##   0000                     
            0x3C, 0x00, 0x00, 0x00, ##    0000                    
            0x3C, 0x00, 0x00, 0x40, ##    0000                   0
            0x1E, 0x00, 0x00, 0xC0, ##     0000                 00
            0x1F, 0x00, 0x01, 0xC0, ##     00000               000
            0x0F, 0xC0, 0x07, 0xC0, ##      000000           00000
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000  
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000    
            0x00, 0x03, 0x80, 0x00, ##                000         
            0x00, 0x01, 0xC0, 0x00, ##                 000        
            0x00, 0x00, 0xE0, 0x00, ##                  000       
            0x00, 0x00, 0xE0, 0x00, ##                  000       
            0x00, 0x01, 0xE0, 0x00, ##                 0000       
            0x00, 0x3F, 0xE0, 0x00, ##            000000000       
            0x00, 0x3F, 0xC0, 0x00, ##            00000000        
            0x00, 0x3F, 0x80, 0x00, ##            0000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '200' => {    # 'È'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x0F, 0x00, 0x00, ##      0000            
            0x07, 0x80, 0x00, ##       0000           
            0x03, 0xC0, 0x00, ##        0000          
            0x01, 0xE0, 0x00, ##         0000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '201' => {    # 'É'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x1E, 0x00, ##             0000     
            0x00, 0x3C, 0x00, ##            0000      
            0x00, 0x78, 0x00, ##           0000       
            0x00, 0x70, 0x00, ##           000        
            0x00, 0xE0, 0x00, ##          000         
            0x01, 0xC0, 0x00, ##         000          
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '202' => {    # 'Ê'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x01, 0xF0, 0x00, ##         00000        
            0x01, 0xF8, 0x00, ##         000000       
            0x03, 0xB8, 0x00, ##        000 000       
            0x07, 0x1C, 0x00, ##       000   000      
            0x0E, 0x0E, 0x00, ##      000     000     
            0x0E, 0x07, 0x00, ##      000      000    
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '203' => {    # 'Ë'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xFF, 0xFF, 0xE0, ##  0000000000000000000 
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '204' => {    # 'Ì'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0xF0, ##  0000    
            0x78, ##   0000   
            0x38, ##    000   
            0x1C, ##     000  
            0x1E, ##     0000 
            0x0E, ##      000 
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '205' => {    # 'Í'
        'width'    => 8, 
        'xoffset'  => 3, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x0F, ##      0000
            0x1E, ##     0000 
            0x1C, ##     000  
            0x38, ##    000   
            0x78, ##   0000   
            0x70, ##   000    
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x78, ##   0000   
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '206' => {    # 'Î'
        'width'    => 12, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x0F, 0x00, ##      0000    
            0x1F, 0x80, ##     000000   
            0x3F, 0xC0, ##    00000000  
            0x39, 0xC0, ##    000  000  
            0x70, 0xE0, ##   000    000 
            0xE0, 0x70, ##  000      000
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '207' => {    # 'Ï'
        'width'    => 12, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '208' => {    # 'Ð'
        'width'    => 30, 
        'xoffset'  => 1, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x0F, 0xFF, 0xC0, 0x00, ##      00000000000000            
            0x0F, 0xFF, 0xFC, 0x00, ##      000000000000000000        
            0x0F, 0xFF, 0xFF, 0x00, ##      00000000000000000000      
            0x0F, 0x00, 0x3F, 0x80, ##      0000          0000000     
            0x0F, 0x00, 0x07, 0xC0, ##      0000             00000    
            0x0F, 0x00, 0x03, 0xE0, ##      0000              00000   
            0x0F, 0x00, 0x01, 0xF0, ##      0000               00000  
            0x0F, 0x00, 0x00, 0xF0, ##      0000                0000  
            0x0F, 0x00, 0x00, 0x78, ##      0000                 0000 
            0x0F, 0x00, 0x00, 0x78, ##      0000                 0000 
            0x0F, 0x00, 0x00, 0x78, ##      0000                 0000 
            0x0F, 0x00, 0x00, 0x3C, ##      0000                  0000
            0x0F, 0x00, 0x00, 0x3C, ##      0000                  0000
            0xFF, 0xFF, 0x00, 0x3C, ##  0000000000000000          0000
            0xFF, 0xFF, 0x00, 0x3C, ##  0000000000000000          0000
            0xFF, 0xFF, 0x00, 0x3C, ##  0000000000000000          0000
            0x0F, 0x00, 0x00, 0x3C, ##      0000                  0000
            0x0F, 0x00, 0x00, 0x3C, ##      0000                  0000
            0x0F, 0x00, 0x00, 0x3C, ##      0000                  0000
            0x0F, 0x00, 0x00, 0x3C, ##      0000                  0000
            0x0F, 0x00, 0x00, 0x78, ##      0000                 0000 
            0x0F, 0x00, 0x00, 0x78, ##      0000                 0000 
            0x0F, 0x00, 0x00, 0x78, ##      0000                 0000 
            0x0F, 0x00, 0x00, 0xF8, ##      0000                00000 
            0x0F, 0x00, 0x01, 0xF0, ##      0000               00000  
            0x0F, 0x00, 0x03, 0xE0, ##      0000              00000   
            0x0F, 0x00, 0x07, 0xE0, ##      0000             000000   
            0x0F, 0x00, 0x3F, 0x80, ##      0000          0000000     
            0x0F, 0xFF, 0xFF, 0x00, ##      00000000000000000000      
            0x0F, 0xFF, 0xFC, 0x00, ##      000000000000000000        
            0x0F, 0xFF, 0xC0, 0x00, ##      00000000000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '209' => {    # 'Ñ'
        'width'    => 24, 
        'xoffset'  => 4, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x01, 0xE0, 0xE0, ##         0000     000     
            0x03, 0xF8, 0xE0, ##        0000000   000     
            0x07, 0xFF, 0xE0, ##       00000000000000     
            0x07, 0x1F, 0xC0, ##       000   0000000      
            0x07, 0x07, 0x80, ##       000     0000       
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0xFC, 0x00, 0x0F, ##  000000              0000
            0xFE, 0x00, 0x0F, ##  0000000             0000
            0xFE, 0x00, 0x0F, ##  0000000             0000
            0xFF, 0x00, 0x0F, ##  00000000            0000
            0xFF, 0x00, 0x0F, ##  00000000            0000
            0xFF, 0x80, 0x0F, ##  000000000           0000
            0xF7, 0x80, 0x0F, ##  0000 0000           0000
            0xF7, 0xC0, 0x0F, ##  0000 00000          0000
            0xF3, 0xE0, 0x0F, ##  0000  00000         0000
            0xF3, 0xE0, 0x0F, ##  0000  00000         0000
            0xF1, 0xF0, 0x0F, ##  0000   00000        0000
            0xF0, 0xF0, 0x0F, ##  0000    0000        0000
            0xF0, 0xF8, 0x0F, ##  0000    00000       0000
            0xF0, 0x78, 0x0F, ##  0000     0000       0000
            0xF0, 0x7C, 0x0F, ##  0000     00000      0000
            0xF0, 0x3C, 0x0F, ##  0000      0000      0000
            0xF0, 0x3E, 0x0F, ##  0000      00000     0000
            0xF0, 0x1E, 0x0F, ##  0000       0000     0000
            0xF0, 0x1F, 0x0F, ##  0000       00000    0000
            0xF0, 0x0F, 0x0F, ##  0000        0000    0000
            0xF0, 0x0F, 0x8F, ##  0000        00000   0000
            0xF0, 0x07, 0xCF, ##  0000         00000  0000
            0xF0, 0x03, 0xCF, ##  0000          0000  0000
            0xF0, 0x03, 0xEF, ##  0000          00000 0000
            0xF0, 0x01, 0xEF, ##  0000           0000 0000
            0xF0, 0x01, 0xFF, ##  0000           000000000
            0xF0, 0x00, 0xFF, ##  0000            00000000
            0xF0, 0x00, 0xFF, ##  0000            00000000
            0xF0, 0x00, 0x7F, ##  0000             0000000
            0xF0, 0x00, 0x7F, ##  0000             0000000
            0xF0, 0x00, 0x3F, ##  0000              000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '210' => {    # 'Ò'
        'width'    => 29, 
        'xoffset'  => 2, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x3C, 0x00, 0x00, ##            0000               
            0x00, 0x1C, 0x00, 0x00, ##             000               
            0x00, 0x1E, 0x00, 0x00, ##             0000              
            0x00, 0x0F, 0x00, 0x00, ##              0000             
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x03, 0xC0, 0x00, ##                0000           
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '211' => {    # 'Ó'
        'width'    => 29, 
        'xoffset'  => 2, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x01, 0xE0, 0x00, ##                 0000          
            0x00, 0x01, 0xC0, 0x00, ##                 000           
            0x00, 0x03, 0xC0, 0x00, ##                0000           
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000             
            0x00, 0x1E, 0x00, 0x00, ##             0000              
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '212' => {    # 'Ô'
        'width'    => 29, 
        'xoffset'  => 2, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x0F, 0x80, 0x00, ##              00000            
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x3D, 0xE0, 0x00, ##            0000 0000          
            0x00, 0x78, 0xF0, 0x00, ##           0000   0000         
            0x00, 0x70, 0x70, 0x00, ##           000     000         
            0x00, 0xE0, 0x38, 0x00, ##          000       000        
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '213' => {    # 'Õ'
        'width'    => 29, 
        'xoffset'  => 2, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x7C, 0x1C, 0x00, ##           00000     000       
            0x00, 0xFF, 0x3C, 0x00, ##          00000000  0000       
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x01, 0xE7, 0xF8, 0x00, ##         0000  00000000        
            0x01, 0xC1, 0xF0, 0x00, ##         000     00000         
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '214' => {    # 'Ö'
        'width'    => 29, 
        'xoffset'  => 2, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0x78, 0x00, ##          0000     0000        
            0x00, 0xF0, 0x78, 0x00, ##          0000     0000        
            0x00, 0xF0, 0x78, 0x00, ##          0000     0000        
            0x00, 0xF0, 0x78, 0x00, ##          0000     0000        
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0xF0, 0x00, 0x00, 0x78, ##  0000                     0000
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x78, 0x00, 0x00, 0xF0, ##   0000                   0000 
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x3C, 0x00, 0x01, 0xE0, ##    0000                 0000  
            0x1E, 0x00, 0x03, 0xC0, ##     0000               0000   
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x0F, 0xC0, 0x1F, 0x80, ##      000000         000000    
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000     
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000       
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '215' => {    # '×'
        'width'    => 24, 
        'xoffset'  => 6, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                          
            0x60, 0x00, 0x06, ##   00                  00 
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x07, 0xC3, 0xE0, ##       00000    00000     
            0x03, 0xE7, 0xC0, ##        00000  00000      
            0x01, 0xFF, 0x80, ##         0000000000       
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xFF, 0x00, ##          00000000        
            0x01, 0xFF, 0x80, ##         0000000000       
            0x03, 0xE7, 0xC0, ##        00000  00000      
            0x07, 0xC3, 0xE0, ##       00000    00000     
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0xF8, 0x00, 0x1F, ##  00000              00000
            0x70, 0x00, 0x0E, ##   000                000 
            0x20, 0x00, 0x04, ##    0                  0  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '216' => {    # 'Ø'
        'width'    => 29, 
        'xoffset'  => 2, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x10, ##                             0 
            0x00, 0x7F, 0xF8, 0x38, ##           000000000000     000
            0x01, 0xFF, 0xFE, 0x70, ##         0000000000000000  000 
            0x07, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000 
            0x0F, 0xC0, 0x3F, 0xE0, ##      000000        000000000  
            0x1F, 0x00, 0x0F, 0xC0, ##     00000            000000   
            0x1E, 0x00, 0x07, 0xE0, ##     0000              000000  
            0x3C, 0x00, 0x0F, 0xE0, ##    0000              0000000  
            0x3C, 0x00, 0x1F, 0xF0, ##    0000             000000000 
            0x78, 0x00, 0x3E, 0xF0, ##   0000             00000 0000 
            0x78, 0x00, 0x7C, 0xF0, ##   0000            00000  0000 
            0x78, 0x00, 0xF8, 0xF8, ##   0000           00000   00000
            0xF0, 0x00, 0xF0, 0x78, ##  0000            0000     0000
            0xF0, 0x01, 0xE0, 0x78, ##  0000           0000      0000
            0xF0, 0x03, 0xC0, 0x78, ##  0000          0000       0000
            0xF0, 0x07, 0xC0, 0x78, ##  0000         00000       0000
            0xF0, 0x0F, 0x80, 0x78, ##  0000        00000        0000
            0xF0, 0x1F, 0x00, 0x78, ##  0000       00000         0000
            0xF0, 0x1E, 0x00, 0x78, ##  0000       0000          0000
            0xF0, 0x3C, 0x00, 0x78, ##  0000      0000           0000
            0xF0, 0x78, 0x00, 0x78, ##  0000     0000            0000
            0x78, 0xF0, 0x00, 0xF0, ##   0000   0000            0000 
            0x79, 0xE0, 0x00, 0xF0, ##   0000  0000             0000 
            0x7B, 0xC0, 0x00, 0xF0, ##   0000 0000              0000 
            0x7F, 0xC0, 0x01, 0xE0, ##   000000000             0000  
            0x3F, 0x80, 0x01, 0xE0, ##    0000000              0000  
            0x1F, 0x00, 0x03, 0xC0, ##     00000              0000   
            0x1F, 0x00, 0x07, 0xC0, ##     00000             00000   
            0x3F, 0xC0, 0x1F, 0x80, ##    00000000         000000    
            0x3F, 0xFF, 0xFE, 0x00, ##    000000000000000000000      
            0x73, 0xFF, 0xFC, 0x00, ##   000  0000000000000000       
            0xE0, 0xFF, 0xF0, 0x00, ##  000     000000000000         
            0x40, 0x00, 0x00, 0x00, ##   0                           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '217' => {    # 'Ù'
        'width'    => 24, 
        'xoffset'  => 4, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x01, 0xE0, 0x00, ##         0000             
            0x00, 0xF0, 0x00, ##          0000            
            0x00, 0x78, 0x00, ##           0000           
            0x00, 0x38, 0x00, ##            000           
            0x00, 0x1C, 0x00, ##             000          
            0x00, 0x0E, 0x00, ##              000         
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x1F, ##  0000               00000
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x0F, 0xFF, 0xF0, ##      0000000000000000    
            0x03, 0xFF, 0xC0, ##        000000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '218' => {    # 'Ú'
        'width'    => 24, 
        'xoffset'  => 4, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x07, 0x80, ##               0000       
            0x00, 0x0F, 0x00, ##              0000        
            0x00, 0x1E, 0x00, ##             0000         
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x38, 0x00, ##            000           
            0x00, 0x70, 0x00, ##           000            
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x1F, ##  0000               00000
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x0F, 0xFF, 0xF0, ##      0000000000000000    
            0x03, 0xFF, 0xC0, ##        000000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '219' => {    # 'Û'
        'width'    => 24, 
        'xoffset'  => 4, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xE7, 0x00, ##          000  000        
            0x01, 0xC3, 0x80, ##         000    000       
            0x03, 0x81, 0xC0, ##        000      000      
            0x07, 0x00, 0xE0, ##       000        000     
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x1F, ##  0000               00000
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x0F, 0xFF, 0xF0, ##      0000000000000000    
            0x03, 0xFF, 0xC0, ##        000000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '220' => {    # 'Ü'
        'width'    => 24, 
        'xoffset'  => 4, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x0F, ##  0000                0000
            0xF0, 0x00, 0x1F, ##  0000               00000
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x1F, 0xFF, 0xF8, ##     000000000000000000   
            0x0F, 0xFF, 0xF0, ##      0000000000000000    
            0x03, 0xFF, 0xC0, ##        000000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '221' => {    # 'Ý'
        'width'    => 26, 
        'xoffset'  => 0, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x03, 0xC0, 0x00, ##                0000        
            0x00, 0x07, 0x80, 0x00, ##               0000         
            0x00, 0x07, 0x00, 0x00, ##               000          
            0x00, 0x0E, 0x00, 0x00, ##              000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1C, 0x00, 0x00, ##             000            
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x00, 0x00, 0x00, ##                            
            0xF8, 0x00, 0x07, 0xC0, ##  00000                00000
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0x3C, 0x00, 0x0F, 0x00, ##    0000              0000  
            0x3E, 0x00, 0x1F, 0x00, ##    00000            00000  
            0x1E, 0x00, 0x1E, 0x00, ##     0000            0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000    
            0x0F, 0x80, 0x7C, 0x00, ##      00000        00000    
            0x07, 0x80, 0x78, 0x00, ##       0000        0000     
            0x03, 0xC0, 0xF0, 0x00, ##        0000      0000      
            0x03, 0xE1, 0xF0, 0x00, ##        00000    00000      
            0x01, 0xF1, 0xE0, 0x00, ##         00000   0000       
            0x00, 0xF3, 0xC0, 0x00, ##          0000  0000        
            0x00, 0xFF, 0xC0, 0x00, ##          0000000000        
            0x00, 0x7F, 0x80, 0x00, ##           00000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000          
            0x00, 0x3F, 0x00, 0x00, ##            000000          
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '222' => {    # 'Þ'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xFF, 0xFC, 0x00, ##  00000000000000      
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0xF0, 0x07, 0xC0, ##  0000         00000  
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xE0, ##  0000           0000 
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xF0, 0x07, 0xC0, ##  0000         00000  
            0xFF, 0xFF, 0xC0, ##  000000000000000000  
            0xFF, 0xFF, 0x00, ##  0000000000000000    
            0xFF, 0xFC, 0x00, ##  00000000000000      
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0xF0, 0x00, 0x00, ##  0000                
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '223' => {    # 'ß'
        'width'    => 21, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xF8, 0x00, ##        0000000        
            0x0F, 0xFE, 0x00, ##      00000000000      
            0x3F, 0xFF, 0x00, ##    00000000000000     
            0x7E, 0x0F, 0x80, ##   000000     00000    
            0x78, 0x07, 0x80, ##   0000        0000    
            0xF8, 0x03, 0xC0, ##  00000         0000   
            0xF0, 0x01, 0xC0, ##  0000           000   
            0xF0, 0x01, 0xC0, ##  0000           000   
            0xF0, 0x0F, 0xC0, ##  0000        000000   
            0xF0, 0x3F, 0xC0, ##  0000      00000000   
            0xF0, 0x7C, 0x00, ##  0000     00000       
            0xF0, 0x78, 0x00, ##  0000     0000        
            0xF0, 0xF0, 0x00, ##  0000    0000         
            0xF0, 0xF0, 0x00, ##  0000    0000         
            0xF0, 0xF0, 0x00, ##  0000    0000         
            0xF0, 0xF0, 0x00, ##  0000    0000         
            0xF0, 0xF8, 0x00, ##  0000    00000        
            0xF0, 0x7C, 0x00, ##  0000     00000       
            0xF0, 0x7F, 0x00, ##  0000     0000000     
            0xF0, 0x3F, 0x80, ##  0000      0000000    
            0xF0, 0x1F, 0xC0, ##  0000       0000000   
            0xF0, 0x07, 0xE0, ##  0000         000000  
            0xF0, 0x03, 0xF0, ##  0000          000000 
            0xF0, 0x00, 0xF8, ##  0000            00000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF2, 0x00, 0xF0, ##  0000  0         0000 
            0xF3, 0xFF, 0xF0, ##  0000  00000000000000 
            0xF3, 0xFF, 0xE0, ##  0000  0000000000000  
            0xF3, 0xFF, 0x80, ##  0000  00000000000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '224' => {    # 'à'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x1E, 0x00, 0x00, ##     0000             
            0x0F, 0x00, 0x00, ##      0000            
            0x07, 0x00, 0x00, ##       000            
            0x07, 0x80, 0x00, ##       0000           
            0x03, 0xC0, 0x00, ##        0000          
            0x01, 0xE0, 0x00, ##         0000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x38, 0x00, ##            000       
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x1F, 0xFE, 0x00, ##     000000000000     
            0x3F, 0xFF, 0x80, ##    000000000000000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x30, 0x03, 0xE0, ##    00          00000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x00, 0xE0, ##                  000 
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x03, 0xFF, 0xF0, ##        00000000000000
            0x1F, 0xFF, 0xF0, ##     00000000000000000
            0x3F, 0xFF, 0xF0, ##    000000000000000000
            0x7E, 0x00, 0xF0, ##   000000         0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x03, 0xF0, ##  00000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x7F, 0xFE, 0xF0, ##   00000000000000 0000
            0x3F, 0xFC, 0xF0, ##    000000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '225' => {    # 'á'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0x80, ##               0000   
            0x00, 0x0F, 0x00, ##              0000    
            0x00, 0x1E, 0x00, ##             0000     
            0x00, 0x1C, 0x00, ##             000      
            0x00, 0x3C, 0x00, ##            0000      
            0x00, 0x78, 0x00, ##           0000       
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xE0, 0x00, ##          000         
            0x01, 0xC0, 0x00, ##         000          
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x1F, 0xFE, 0x00, ##     000000000000     
            0x3F, 0xFF, 0x80, ##    000000000000000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x30, 0x03, 0xE0, ##    00          00000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x00, 0xE0, ##                  000 
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x03, 0xFF, 0xF0, ##        00000000000000
            0x1F, 0xFF, 0xF0, ##     00000000000000000
            0x3F, 0xFF, 0xF0, ##    000000000000000000
            0x7E, 0x00, 0xF0, ##   000000         0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x03, 0xF0, ##  00000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x7F, 0xFE, 0xF0, ##   00000000000000 0000
            0x3F, 0xFC, 0xF0, ##    000000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '226' => {    # 'â'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xF8, 0x00, ##         000000       
            0x03, 0xF8, 0x00, ##        0000000       
            0x03, 0x9C, 0x00, ##        000  000      
            0x07, 0x0E, 0x00, ##       000    000     
            0x07, 0x0E, 0x00, ##       000    000     
            0x0E, 0x07, 0x00, ##      000      000    
            0x1C, 0x03, 0x80, ##     000        000   
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x1F, 0xFE, 0x00, ##     000000000000     
            0x3F, 0xFF, 0x80, ##    000000000000000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x30, 0x03, 0xE0, ##    00          00000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x00, 0xE0, ##                  000 
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x03, 0xFF, 0xF0, ##        00000000000000
            0x1F, 0xFF, 0xF0, ##     00000000000000000
            0x3F, 0xFF, 0xF0, ##    000000000000000000
            0x7E, 0x00, 0xF0, ##   000000         0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x03, 0xF0, ##  00000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x7F, 0xFE, 0xF0, ##   00000000000000 0000
            0x3F, 0xFC, 0xF0, ##    000000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '227' => {    # 'ã'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x83, 0x80, ##       0000     000   
            0x0F, 0xC3, 0x80, ##      000000    000   
            0x0F, 0xE3, 0x80, ##      0000000   000   
            0x1E, 0xF7, 0x80, ##     0000 0000 0000   
            0x1C, 0x7F, 0x00, ##     000   0000000    
            0x1C, 0x3F, 0x00, ##     000    000000    
            0x1C, 0x1E, 0x00, ##     000     0000     
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x1F, 0xFE, 0x00, ##     000000000000     
            0x3F, 0xFF, 0x80, ##    000000000000000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x30, 0x03, 0xE0, ##    00          00000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x00, 0xE0, ##                  000 
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x03, 0xFF, 0xF0, ##        00000000000000
            0x1F, 0xFF, 0xF0, ##     00000000000000000
            0x3F, 0xFF, 0xF0, ##    000000000000000000
            0x7E, 0x00, 0xF0, ##   000000         0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x03, 0xF0, ##  00000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x7F, 0xFE, 0xF0, ##   00000000000000 0000
            0x3F, 0xFC, 0xF0, ##    000000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '228' => {    # 'ä'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x1F, 0xFE, 0x00, ##     000000000000     
            0x3F, 0xFF, 0x80, ##    000000000000000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x30, 0x03, 0xE0, ##    00          00000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x00, 0xE0, ##                  000 
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x03, 0xFF, 0xF0, ##        00000000000000
            0x1F, 0xFF, 0xF0, ##     00000000000000000
            0x3F, 0xFF, 0xF0, ##    000000000000000000
            0x7E, 0x00, 0xF0, ##   000000         0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x03, 0xF0, ##  00000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x7F, 0xFE, 0xF0, ##   00000000000000 0000
            0x3F, 0xFC, 0xF0, ##    000000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '229' => {    # 'å'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0x00, ##          0000        
            0x03, 0xFC, 0x00, ##        00000000      
            0x07, 0xFE, 0x00, ##       0000000000     
            0x0F, 0x0E, 0x00, ##      0000    000     
            0x0E, 0x07, 0x00, ##      000      000    
            0x0E, 0x07, 0x00, ##      000      000    
            0x0E, 0x07, 0x00, ##      000      000    
            0x0E, 0x07, 0x00, ##      000      000    
            0x0F, 0x0E, 0x00, ##      0000    000     
            0x07, 0xFE, 0x00, ##       0000000000     
            0x03, 0xFC, 0x00, ##        00000000      
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x1F, 0xFE, 0x00, ##     000000000000     
            0x3F, 0xFF, 0x80, ##    000000000000000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x30, 0x03, 0xE0, ##    00          00000 
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x00, 0xE0, ##                  000 
            0x00, 0x00, 0xF0, ##                  0000
            0x00, 0x00, 0xF0, ##                  0000
            0x03, 0xFF, 0xF0, ##        00000000000000
            0x1F, 0xFF, 0xF0, ##     00000000000000000
            0x3F, 0xFF, 0xF0, ##    000000000000000000
            0x7E, 0x00, 0xF0, ##   000000         0000
            0x78, 0x00, 0xF0, ##   0000           0000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x03, 0xF0, ##  00000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x7F, 0xFE, 0xF0, ##   00000000000000 0000
            0x3F, 0xFC, 0xF0, ##    000000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '230' => {    # 'æ'
        'width'    => 37, 
        'xoffset'  => 3, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x1F, 0xFE, 0x03, 0xFF, 0x00, ##     000000000000       0000000000     
            0x3F, 0xFF, 0x0F, 0xFF, 0x80, ##    00000000000000    0000000000000    
            0x3F, 0xFF, 0xDF, 0xFF, 0xC0, ##    0000000000000000 000000000000000   
            0x30, 0x03, 0xFE, 0x03, 0xE0, ##    00          000000000       00000  
            0x00, 0x01, 0xFC, 0x00, 0xF0, ##                 0000000          0000 
            0x00, 0x00, 0xF8, 0x00, 0xF0, ##                  00000           0000 
            0x00, 0x00, 0xF8, 0x00, 0x78, ##                  00000            0000
            0x00, 0x00, 0xF0, 0x00, 0x78, ##                  0000             0000
            0x03, 0xFF, 0xF0, 0x00, 0x78, ##        00000000000000             0000
            0x1F, 0xFF, 0xFF, 0xFF, 0xF8, ##     0000000000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xFF, 0xF8, ##    00000000000000000000000000000000000
            0x7E, 0x00, 0xFF, 0xFF, 0xF8, ##   000000         000000000000000000000
            0x78, 0x00, 0xF0, 0x00, 0x00, ##   0000           0000                 
            0xF8, 0x00, 0xF0, 0x00, 0x00, ##  00000           0000                 
            0xF0, 0x00, 0xF0, 0x00, 0x00, ##  0000            0000                 
            0xF0, 0x01, 0xF0, 0x00, 0x00, ##  0000           00000                 
            0xF0, 0x01, 0xF8, 0x00, 0x00, ##  0000           000000                
            0xF0, 0x01, 0xF8, 0x00, 0x00, ##  0000           000000                
            0xF8, 0x03, 0xFC, 0x00, 0x00, ##  00000         00000000               
            0x7C, 0x07, 0xBF, 0x00, 0x70, ##   00000       0000 000000         000 
            0x7F, 0xFF, 0x1F, 0xFF, 0xF0, ##   000000000000000   00000000000000000 
            0x3F, 0xFE, 0x0F, 0xFF, 0xF0, ##    0000000000000     0000000000000000 
            0x0F, 0xF8, 0x03, 0xFF, 0xC0, ##      000000000         000000000000   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '231' => {    # 'ç'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                     
            0x03, 0xFF, 0xC0, ##        000000000000 
            0x07, 0xFF, 0xE0, ##       00000000000000
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x3F, 0x00, 0x60, ##    000000         00
            0x3C, 0x00, 0x00, ##    0000             
            0x7C, 0x00, 0x00, ##   00000             
            0x78, 0x00, 0x00, ##   0000              
            0xF8, 0x00, 0x00, ##  00000              
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF0, 0x00, 0x00, ##  0000               
            0xF8, 0x00, 0x00, ##  00000              
            0x78, 0x00, 0x00, ##   0000              
            0x7C, 0x00, 0x00, ##   00000             
            0x3C, 0x00, 0x00, ##    0000             
            0x3F, 0x00, 0x60, ##    000000         00
            0x1F, 0xFF, 0xE0, ##     0000000000000000
            0x0F, 0xFF, 0xE0, ##      000000000000000
            0x03, 0xFF, 0xC0, ##        000000000000 
            0x00, 0x18, 0x00, ##             00      
            0x00, 0x1C, 0x00, ##             000     
            0x00, 0x0E, 0x00, ##              000    
            0x00, 0x0E, 0x00, ##              000    
            0x00, 0x1E, 0x00, ##             0000    
            0x01, 0xFE, 0x00, ##         00000000    
            0x01, 0xFC, 0x00, ##         0000000     
            0x01, 0xF8, 0x00, ##         000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '232' => {    # 'è'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x00, 0x00, ##      0000              
            0x07, 0x80, 0x00, ##       0000             
            0x03, 0xC0, 0x00, ##        0000            
            0x01, 0xC0, 0x00, ##         000            
            0x01, 0xE0, 0x00, ##         0000           
            0x00, 0xF0, 0x00, ##          0000          
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x38, 0x00, ##            000         
            0x00, 0x1C, 0x00, ##             000        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x80, ##        00000000000     
            0x07, 0xFF, 0xC0, ##       0000000000000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x1E, 0x01, 0xF0, ##     0000        00000  
            0x3C, 0x00, 0xF8, ##    0000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x3C, ##   0000             0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0x78, 0x00, 0x00, ##   0000                 
            0x78, 0x00, 0x00, ##   0000                 
            0x3C, 0x00, 0x00, ##    0000                
            0x1F, 0x00, 0x38, ##     00000          000 
            0x1F, 0xFF, 0xF8, ##     000000000000000000 
            0x07, 0xFF, 0xF8, ##       0000000000000000 
            0x01, 0xFF, 0xE0, ##         000000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '233' => {    # 'é'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xE0, ##                00000   
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x0F, 0x00, ##              0000      
            0x00, 0x1E, 0x00, ##             0000       
            0x00, 0x3C, 0x00, ##            0000        
            0x00, 0x38, 0x00, ##            000         
            0x00, 0x70, 0x00, ##           000          
            0x00, 0xF0, 0x00, ##          0000          
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x80, ##        00000000000     
            0x07, 0xFF, 0xC0, ##       0000000000000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x1E, 0x01, 0xF0, ##     0000        00000  
            0x3C, 0x00, 0xF8, ##    0000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x3C, ##   0000             0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0x78, 0x00, 0x00, ##   0000                 
            0x78, 0x00, 0x00, ##   0000                 
            0x3C, 0x00, 0x00, ##    0000                
            0x1F, 0x00, 0x38, ##     00000          000 
            0x1F, 0xFF, 0xF8, ##     000000000000000000 
            0x07, 0xFF, 0xF8, ##       0000000000000000 
            0x01, 0xFF, 0xE0, ##         000000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '234' => {    # 'ê'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x38, 0x00, ##            000         
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFE, 0x00, ##          0000000       
            0x01, 0xCE, 0x00, ##         000  000       
            0x03, 0xC7, 0x00, ##        0000   000      
            0x03, 0x83, 0x80, ##        000     000     
            0x07, 0x03, 0x80, ##       000      000     
            0x0E, 0x01, 0xC0, ##      000        000    
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x80, ##        00000000000     
            0x07, 0xFF, 0xC0, ##       0000000000000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x1E, 0x01, 0xF0, ##     0000        00000  
            0x3C, 0x00, 0xF8, ##    0000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x3C, ##   0000             0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0x78, 0x00, 0x00, ##   0000                 
            0x78, 0x00, 0x00, ##   0000                 
            0x3C, 0x00, 0x00, ##    0000                
            0x1F, 0x00, 0x38, ##     00000          000 
            0x1F, 0xFF, 0xF8, ##     000000000000000000 
            0x07, 0xFF, 0xF8, ##       0000000000000000 
            0x01, 0xFF, 0xE0, ##         000000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '235' => {    # 'ë'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x80, ##        00000000000     
            0x07, 0xFF, 0xC0, ##       0000000000000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x1E, 0x01, 0xF0, ##     0000        00000  
            0x3C, 0x00, 0xF8, ##    0000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x3C, ##   0000             0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0xF0, 0x00, 0x00, ##  0000                  
            0x78, 0x00, 0x00, ##   0000                 
            0x78, 0x00, 0x00, ##   0000                 
            0x3C, 0x00, 0x00, ##    0000                
            0x1F, 0x00, 0x38, ##     00000          000 
            0x1F, 0xFF, 0xF8, ##     000000000000000000 
            0x07, 0xFF, 0xF8, ##       0000000000000000 
            0x01, 0xFF, 0xE0, ##         000000000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '236' => {    # 'ì'
        'width'    => 10, 
        'xoffset'  => -1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x00, ##  0000      
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x3C, 0x00, ##    0000    
            0x1E, 0x00, ##     0000   
            0x0F, 0x00, ##      0000  
            0x07, 0x00, ##       000  
            0x03, 0x80, ##        000 
            0x01, 0xC0, ##         000
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '237' => {    # 'í'
        'width'    => 10, 
        'xoffset'  => 3, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xC0, ##        0000
            0x07, 0x80, ##       0000 
            0x0F, 0x00, ##      0000  
            0x0F, 0x00, ##      0000  
            0x1E, 0x00, ##     0000   
            0x3C, 0x00, ##    0000    
            0x78, 0x00, ##   0000     
            0x70, 0x00, ##   000      
            0xE0, 0x00, ##  000       
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x00, 0x00, ##            
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x78, 0x00, ##   0000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '238' => {    # 'î'
        'width'    => 14, 
        'xoffset'  => -1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x0F, 0xC0, ##      000000    
            0x1F, 0xE0, ##     00000000   
            0x1C, 0xE0, ##     000  000   
            0x38, 0x70, ##    000    000  
            0x38, 0x70, ##    000    000  
            0x70, 0x38, ##   000      000 
            0xE0, 0x1C, ##  000        000
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '239' => {    # 'ï'
        'width'    => 12, 
        'xoffset'  => 0, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0xF0, 0xF0, ##  0000    0000
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '240' => {    # 'ð'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0xC0, 0x00, ##       00000            
            0x07, 0xC0, 0x60, ##       00000       00   
            0x03, 0xE3, 0xF0, ##        00000   000000  
            0x01, 0xFF, 0xC0, ##         00000000000    
            0x00, 0xFE, 0x00, ##          0000000       
            0x07, 0xFC, 0x00, ##       000000000        
            0x3F, 0xBE, 0x00, ##    0000000 00000       
            0x3C, 0x1F, 0x00, ##    0000     00000      
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x0F, 0x80, ##              00000     
            0x01, 0xFF, 0xC0, ##         00000000000    
            0x07, 0xFF, 0xE0, ##       00000000000000   
            0x0F, 0xFF, 0xF0, ##      0000000000000000  
            0x1F, 0x81, 0xF0, ##     000000      00000  
            0x3E, 0x00, 0xF8, ##    00000         00000 
            0x7C, 0x00, 0x78, ##   00000           0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x7C, ##   0000            00000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '241' => {    # 'ñ'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x83, 0x80, ##       0000     000   
            0x0F, 0xC3, 0x80, ##      000000    000   
            0x0F, 0xE7, 0x80, ##      0000000  0000   
            0x1E, 0x7F, 0x00, ##     0000  0000000    
            0x1C, 0x3F, 0x00, ##     000    000000    
            0x1C, 0x1E, 0x00, ##     000     0000     
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xF1, 0xFF, 0x00, ##  0000   000000000    
            0xF3, 0xFF, 0x80, ##  0000  00000000000   
            0xF7, 0xFF, 0xC0, ##  0000 0000000000000  
            0xFE, 0x03, 0xE0, ##  0000000       00000 
            0xFC, 0x01, 0xE0, ##  000000         0000 
            0xF8, 0x01, 0xF0, ##  00000          00000
            0xF8, 0x00, 0xF0, ##  00000           0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '242' => {    # 'ò'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x00, 0x00, ##      0000              
            0x0F, 0x80, 0x00, ##      00000             
            0x07, 0x80, 0x00, ##       0000             
            0x03, 0xC0, 0x00, ##        0000            
            0x01, 0xE0, 0x00, ##         0000           
            0x00, 0xF0, 0x00, ##          0000          
            0x00, 0x70, 0x00, ##           000          
            0x00, 0x38, 0x00, ##            000         
            0x00, 0x1C, 0x00, ##             000        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x78, 0x00, 0xF8, ##   0000           00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '243' => {    # 'ó'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xC0, ##                0000    
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x0F, 0x00, ##              0000      
            0x00, 0x1E, 0x00, ##             0000       
            0x00, 0x3C, 0x00, ##            0000        
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x70, 0x00, ##           000          
            0x00, 0xE0, 0x00, ##          000           
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x78, 0x00, 0xF8, ##   0000           00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '244' => {    # 'ô'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0xFC, 0x00, ##          000000        
            0x01, 0xFE, 0x00, ##         00000000       
            0x01, 0xCE, 0x00, ##         000  000       
            0x03, 0x87, 0x00, ##        000    000      
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x03, 0x80, ##       000      000     
            0x0E, 0x01, 0xC0, ##      000        000    
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x78, 0x00, 0xF8, ##   0000           00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '245' => {    # 'õ'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xC1, 0xC0, ##        0000     000    
            0x07, 0xE1, 0xC0, ##       000000    000    
            0x07, 0xF1, 0xC0, ##       0000000   000    
            0x0F, 0x7B, 0xC0, ##      0000 0000 0000    
            0x0E, 0x3F, 0x80, ##      000   0000000     
            0x0E, 0x1F, 0x80, ##      000    000000     
            0x0E, 0x0F, 0x00, ##      000     0000      
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x78, 0x00, 0xF8, ##   0000           00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '246' => {    # 'ö'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x78, 0x00, 0xF8, ##   0000           00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '247' => {    # '÷'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '248' => {    # 'ø'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x07, ##                       000
            0x01, 0xFF, 0x8E, ##         0000000000   000 
            0x07, 0xFF, 0xFC, ##       00000000000000000  
            0x0F, 0xFF, 0xF8, ##      00000000000000000   
            0x1F, 0x01, 0xF8, ##     00000       000000   
            0x1E, 0x00, 0xFC, ##     0000         000000  
            0x3C, 0x01, 0xFC, ##    0000         0000000  
            0x3C, 0x03, 0xFC, ##    0000        00000000  
            0x7C, 0x07, 0x9E, ##   00000       0000  0000 
            0x78, 0x07, 0x1E, ##   0000        000   0000 
            0x78, 0x0E, 0x1E, ##   0000       000    0000 
            0x78, 0x1E, 0x1E, ##   0000      0000    0000 
            0x78, 0x3C, 0x1E, ##   0000     0000     0000 
            0x78, 0x78, 0x1E, ##   0000    0000      0000 
            0x78, 0xF0, 0x1E, ##   0000   0000       0000 
            0x78, 0xE0, 0x1E, ##   0000   000        0000 
            0x79, 0xC0, 0x3E, ##   0000  000        00000 
            0x3F, 0x80, 0x3C, ##    0000000         0000  
            0x3F, 0x80, 0x3C, ##    0000000         0000  
            0x1F, 0x00, 0x78, ##     00000         0000   
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x3F, 0xFF, 0xF0, ##    000000000000000000    
            0x3F, 0xFF, 0xE0, ##    00000000000000000     
            0x71, 0xFF, 0x80, ##   000   0000000000       
            0xE0, 0x00, 0x00, ##  000                     
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '249' => {    # 'ù'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x1E, 0x00, 0x00, ##     0000             
            0x1F, 0x00, 0x00, ##     00000            
            0x0F, 0x00, 0x00, ##      0000            
            0x07, 0x80, 0x00, ##       0000           
            0x03, 0xC0, 0x00, ##        0000          
            0x01, 0xC0, 0x00, ##         000          
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x78, 0x00, ##           0000       
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x01, 0xF0, ##  00000          00000
            0x78, 0x03, 0xF0, ##   0000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x3F, 0xFE, 0xF0, ##    0000000000000 0000
            0x1F, 0xFC, 0xF0, ##     00000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '250' => {    # 'ú'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0x80, ##               0000   
            0x00, 0x0F, 0x00, ##              0000    
            0x00, 0x1E, 0x00, ##             0000     
            0x00, 0x1C, 0x00, ##             000      
            0x00, 0x3C, 0x00, ##            0000      
            0x00, 0x78, 0x00, ##           0000       
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xE0, 0x00, ##          000         
            0x01, 0xC0, 0x00, ##         000          
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x01, 0xF0, ##  00000          00000
            0x78, 0x03, 0xF0, ##   0000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x3F, 0xFE, 0xF0, ##    0000000000000 0000
            0x1F, 0xFC, 0xF0, ##     00000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '251' => {    # 'û'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xF8, 0x00, ##         000000       
            0x03, 0xF8, 0x00, ##        0000000       
            0x03, 0x9C, 0x00, ##        000  000      
            0x07, 0x1E, 0x00, ##       000   0000     
            0x0F, 0x0E, 0x00, ##      0000    000     
            0x0E, 0x07, 0x00, ##      000      000    
            0x1C, 0x03, 0x80, ##     000        000   
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x01, 0xF0, ##  00000          00000
            0x78, 0x03, 0xF0, ##   0000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x3F, 0xFE, 0xF0, ##    0000000000000 0000
            0x1F, 0xFC, 0xF0, ##     00000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '252' => {    # 'ü'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0xF8, 0x01, 0xF0, ##  00000          00000
            0x78, 0x03, 0xF0, ##   0000         000000
            0x7C, 0x07, 0xF0, ##   00000       0000000
            0x3F, 0xFE, 0xF0, ##    0000000000000 0000
            0x1F, 0xFC, 0xF0, ##     00000000000  0000
            0x0F, 0xF8, 0xF0, ##      000000000   0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '253' => {    # 'ý'
        'width'    => 23, 
        'xoffset'  => 1, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xC0, ##                0000     
            0x00, 0x07, 0x80, ##               0000      
            0x00, 0x0F, 0x00, ##              0000       
            0x00, 0x1E, 0x00, ##             0000        
            0x00, 0x1C, 0x00, ##             000         
            0x00, 0x38, 0x00, ##            000          
            0x00, 0x70, 0x00, ##           000           
            0x00, 0xF0, 0x00, ##          0000           
            0x00, 0x00, 0x00, ##                         
            0x00, 0x00, 0x00, ##                         
            0x00, 0x00, 0x00, ##                         
            0xF0, 0x00, 0x3E, ##  0000              00000
            0xF8, 0x00, 0x3C, ##  00000             0000 
            0x78, 0x00, 0x3C, ##   0000             0000 
            0x78, 0x00, 0x78, ##   0000            0000  
            0x3C, 0x00, 0x78, ##    0000           0000  
            0x3C, 0x00, 0xF8, ##    0000          00000  
            0x1E, 0x00, 0xF0, ##     0000         0000   
            0x1E, 0x00, 0xF0, ##     0000         0000   
            0x1E, 0x01, 0xE0, ##     0000        0000    
            0x0F, 0x01, 0xE0, ##      0000       0000    
            0x0F, 0x03, 0xE0, ##      0000      00000    
            0x07, 0x83, 0xC0, ##       0000     0000     
            0x07, 0x83, 0xC0, ##       0000     0000     
            0x07, 0x87, 0x80, ##       0000    0000      
            0x03, 0xC7, 0x80, ##        0000   0000      
            0x03, 0xCF, 0x00, ##        0000  0000       
            0x01, 0xEF, 0x00, ##         0000 0000       
            0x01, 0xEF, 0x00, ##         0000 0000       
            0x00, 0xFE, 0x00, ##          0000000        
            0x00, 0xFE, 0x00, ##          0000000        
            0x00, 0xFC, 0x00, ##          000000         
            0x00, 0x7C, 0x00, ##           00000         
            0x00, 0x7C, 0x00, ##           00000         
            0x00, 0x78, 0x00, ##           0000          
            0x00, 0x78, 0x00, ##           0000          
            0x00, 0xF0, 0x00, ##          0000           
            0x00, 0xF0, 0x00, ##          0000           
            0x01, 0xE0, 0x00, ##         0000            
            0x03, 0xE0, 0x00, ##        00000            
            0x3F, 0xC0, 0x00, ##    00000000             
            0x3F, 0xC0, 0x00, ##    00000000             
            0x3F, 0x00, 0x00, ##    000000               
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '254' => {    # 'þ'
        'width'    => 21, 
        'xoffset'  => 4, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF1, 0xFF, 0x00, ##  0000   000000000     
            0xF3, 0xFF, 0x80, ##  0000  00000000000    
            0xF7, 0xFF, 0xC0, ##  0000 0000000000000   
            0xFE, 0x03, 0xE0, ##  0000000       00000  
            0xFC, 0x01, 0xE0, ##  000000         0000  
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0x78, ##  0000             0000
            0xF0, 0x00, 0xF8, ##  0000            00000
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xF8, 0x00, 0xF0, ##  00000           0000 
            0xFC, 0x01, 0xE0, ##  000000         0000  
            0xFE, 0x03, 0xE0, ##  0000000       00000  
            0xF7, 0xFF, 0xC0, ##  0000 0000000000000   
            0xF3, 0xFF, 0x80, ##  0000  00000000000    
            0xF1, 0xFF, 0x00, ##  0000   000000000     
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0xF0, 0x00, 0x00, ##  0000                 
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '255' => {    # 'ÿ'
        'width'    => 22, 
        'xoffset'  => 1, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0xF0, 0x00, 0x3C, ##  0000              0000
            0xF0, 0x00, 0x3C, ##  0000              0000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x1E, 0x01, 0xE0, ##     0000        0000   
            0x1E, 0x01, 0xE0, ##     0000        0000   
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x07, 0x87, 0x80, ##       0000    0000     
            0x07, 0x87, 0x80, ##       0000    0000     
            0x03, 0xCF, 0x00, ##        0000  0000      
            0x03, 0xCF, 0x00, ##        0000  0000      
            0x03, 0xCF, 0x00, ##        0000  0000      
            0x01, 0xFE, 0x00, ##         00000000       
            0x01, 0xFE, 0x00, ##         00000000       
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0xF0, 0x00, ##          0000          
            0x00, 0xF0, 0x00, ##          0000          
            0x00, 0xF0, 0x00, ##          0000          
            0x01, 0xE0, 0x00, ##         0000           
            0x03, 0xE0, 0x00, ##        00000           
            0x3F, 0xC0, 0x00, ##    00000000            
            0x3F, 0x80, 0x00, ##    0000000             
            0x3F, 0x00, 0x00, ##    000000              
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { '65' => -1, '66' => -2, '71' => 2, '74' => 2, '79' => 1, '81' => 2, '84' => -4, '86' => -3, '87' => -2, '88' => -2, '89' => -5, '111' => 1, '118' => -1, '121' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '210' => 1, '211' => 1, '212' => 1, '213' => 1, '214' => 1, '221' => -5, '242' => 1, '243' => 1, '244' => 1, '245' => 1, '246' => 1, '253' => -1, '255' => -1, },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { '45' => -1, '46' => -1, '58' => -1, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -3, '86' => -3, '87' => -2, '89' => -3, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -3, '119' => -2, '121' => -3, '171' => -2, '192' => 1, '193' => 1, '194' => 1, '195' => 1, '196' => 1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -3, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -3, '255' => -3, },  # A
    '66' => { '67' => -1, '71' => -1, '79' => -1, '83' => -1, '86' => -1, '87' => -2, '89' => -2, '171' => -1, '187' => -1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -2, },  # B
    '67' => { '89' => -1, '171' => -1, '187' => -1, '221' => -1, },  # C
    '68' => { '65' => -1, '86' => -1, '89' => -2, '171' => -1, '187' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -2, },  # D
    '69' => { },  # E
    '70' => { '46' => -7, '58' => -3, '65' => -4, '83' => -1, '84' => -1, '97' => -4, '101' => -2, '105' => -3, '111' => -2, '114' => -3, '117' => -2, '121' => -4, '192' => -4, '193' => -4, '194' => -4, '195' => -4, '196' => -4, '224' => -4, '225' => -4, '226' => -4, '227' => -4, '228' => -4, '229' => -4, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '249' => -2, '250' => -2, '251' => -2, '252' => -2, '253' => -4, '255' => -4, },  # F
    '71' => { '84' => -2, '89' => -2, '171' => -1, '187' => -1, '221' => -2, },  # G
    '72' => { '46' => -1, },  # H
    '73' => { },  # I
    '74' => { '45' => -2, '65' => -1, '171' => -1, '187' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # J
    '75' => { '45' => -5, '65' => -1, '67' => -2, '79' => -2, '84' => -3, '85' => -1, '87' => -2, '89' => -2, '97' => -1, '101' => -2, '111' => -2, '117' => -2, '121' => -3, '171' => -3, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '199' => -2, '210' => -2, '211' => -2, '212' => -2, '213' => -2, '214' => -2, '217' => -1, '218' => -1, '219' => -1, '220' => -1, '221' => -2, '224' => -1, '225' => -1, '226' => -1, '227' => -1, '228' => -1, '229' => -1, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '249' => -2, '250' => -2, '251' => -2, '252' => -2, '253' => -3, '255' => -3, },  # K
    '76' => { '45' => -1, '65' => 1, '79' => -2, '84' => -6, '85' => -2, '86' => -5, '87' => -4, '89' => -6, '101' => -1, '111' => -1, '117' => -1, '121' => -4, '192' => 1, '193' => 1, '194' => 1, '195' => 1, '196' => 1, '210' => -2, '211' => -2, '212' => -2, '213' => -2, '214' => -2, '217' => -2, '218' => -2, '219' => -2, '220' => -2, '221' => -6, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '249' => -1, '250' => -1, '251' => -1, '252' => -1, '253' => -4, '255' => -4, },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { '45' => 1, '46' => -2, '58' => -1, '65' => -1, '86' => -1, '88' => -3, '89' => -2, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -2, },  # O
    '80' => { '45' => -1, '46' => -7, '65' => -3, '89' => -1, '97' => -2, '101' => -2, '105' => -1, '110' => -1, '111' => -2, '114' => -1, '115' => -1, '117' => -1, '171' => -1, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '221' => -1, '224' => -2, '225' => -2, '226' => -2, '227' => -2, '228' => -2, '229' => -2, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '241' => -1, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '249' => -1, '250' => -1, '251' => -1, '252' => -1, },  # P
    '81' => { '45' => 1, },  # Q
    '82' => { '45' => -2, '46' => -2, '58' => -1, '65' => -2, '67' => -2, '84' => -3, '86' => -2, '87' => -2, '89' => -3, '97' => -1, '101' => -2, '111' => -2, '117' => -2, '121' => -2, '171' => -2, '187' => -1, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '199' => -2, '221' => -3, '224' => -1, '225' => -1, '226' => -1, '227' => -1, '228' => -1, '229' => -1, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '249' => -2, '250' => -2, '251' => -2, '252' => -2, '253' => -2, '255' => -2, },  # R
    '83' => { '65' => 1, '192' => 1, '193' => 1, '194' => 1, '195' => 1, '196' => 1, },  # S
    '84' => { '45' => -4, '46' => -5, '58' => -5, '65' => -3, '67' => -3, '97' => -7, '99' => -7, '101' => -7, '105' => -1, '111' => -7, '114' => -6, '115' => -7, '117' => -7, '119' => -7, '121' => -7, '171' => -4, '187' => -2, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '199' => -3, '224' => -7, '225' => -7, '226' => -7, '227' => -7, '228' => -7, '229' => -7, '231' => -7, '232' => -7, '233' => -7, '234' => -7, '235' => -7, '242' => -7, '243' => -7, '244' => -7, '245' => -7, '246' => -7, '249' => -7, '250' => -7, '251' => -7, '252' => -7, '253' => -7, '255' => -7, },  # T
    '85' => { '90' => -1, },  # U
    '86' => { '45' => -3, '46' => -6, '58' => -3, '65' => -3, '79' => -1, '97' => -3, '101' => -3, '105' => -1, '111' => -3, '117' => -3, '121' => -1, '171' => -4, '187' => -2, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '224' => -3, '225' => -3, '226' => -3, '227' => -3, '228' => -3, '229' => -3, '232' => -3, '233' => -3, '234' => -3, '235' => -3, '242' => -3, '243' => -3, '244' => -3, '245' => -3, '246' => -3, '249' => -3, '250' => -3, '251' => -3, '252' => -3, '253' => -1, '255' => -1, },  # V
    '87' => { '45' => -2, '46' => -5, '58' => -3, '65' => -2, '97' => -3, '101' => -3, '105' => -1, '111' => -3, '114' => -2, '117' => -2, '121' => -1, '171' => -2, '187' => -1, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '224' => -3, '225' => -3, '226' => -3, '227' => -3, '228' => -3, '229' => -3, '232' => -3, '233' => -3, '234' => -3, '235' => -3, '242' => -3, '243' => -3, '244' => -3, '245' => -3, '246' => -3, '249' => -2, '250' => -2, '251' => -2, '252' => -2, '253' => -1, '255' => -1, },  # W
    '88' => { '45' => -2, '67' => -3, '79' => -3, '84' => -1, '101' => -2, '171' => -2, '199' => -3, '210' => -3, '211' => -3, '212' => -3, '213' => -3, '214' => -3, '232' => -2, '233' => -2, '234' => -2, '235' => -2, },  # X
    '89' => { '45' => -5, '46' => -9, '58' => -6, '65' => -3, '67' => -2, '79' => -2, '97' => -6, '101' => -6, '105' => -2, '111' => -6, '117' => -5, '171' => -5, '187' => -3, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '199' => -2, '210' => -2, '211' => -2, '212' => -2, '213' => -2, '214' => -2, '224' => -6, '225' => -6, '226' => -6, '227' => -6, '228' => -6, '229' => -6, '232' => -6, '233' => -6, '234' => -6, '235' => -6, '242' => -6, '243' => -6, '244' => -6, '245' => -6, '246' => -6, '249' => -5, '250' => -5, '251' => -5, '252' => -5, },  # Y
    '90' => { '45' => -1, },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { '120' => -1, },  # e
    '102' => { '45' => -2, '46' => -3, '58' => -2, '116' => -1, '119' => -1, '121' => -1, '171' => -2, '187' => -1, '253' => -1, '255' => -1, },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { '97' => -1, '101' => -2, '111' => -2, '117' => -1, '121' => -2, '224' => -1, '225' => -1, '226' => -1, '227' => -1, '228' => -1, '229' => -1, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '249' => -1, '250' => -1, '251' => -1, '252' => -1, '253' => -2, '255' => -2, },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { '45' => 1, '46' => -1, '120' => -1, },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { '45' => -3, '46' => -4, '58' => -1, '99' => -1, '100' => -1, '101' => -1, '103' => -1, '104' => -1, '109' => -1, '110' => -1, '111' => -1, '113' => -1, '120' => -1, '171' => -2, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '241' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { '45' => -1, '46' => -3, '58' => -2, '171' => -1, '187' => -1, },  # v
    '119' => { '46' => -4, '58' => -2, '171' => -1, '187' => -1, },  # w
    '120' => { '99' => -1, '101' => -1, '111' => -1, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, },  # x
    '121' => { '45' => -1, '46' => -6, '58' => -3, '171' => -1, '187' => -1, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '160' => { },  #  
    '161' => { },  # ¡
    '162' => { },  # ¢
    '163' => { },  # £
    '164' => { },  # ¤
    '165' => { },  # ¥
    '166' => { },  # ¦
    '167' => { },  # §
    '168' => { },  # ¨
    '169' => { },  # ©
    '170' => { },  # ª
    '171' => { '66' => -1, '67' => -1, '68' => -1, '71' => -1, '74' => -1, '84' => -2, '86' => -2, '87' => -1, '89' => -3, '118' => -1, '119' => -1, '121' => -1, '198' => 3, '199' => -1, '221' => -3, '253' => -1, '255' => -1, },  # «
    '172' => { },  # ¬
    '173' => { },  # ­
    '174' => { },  # ®
    '175' => { },  # ¯
    '176' => { },  # °
    '177' => { },  # ±
    '178' => { },  # ²
    '179' => { },  # ³
    '180' => { },  # ´
    '181' => { },  # µ
    '182' => { },  # ¶
    '183' => { },  # ·
    '184' => { },  # ¸
    '185' => { },  # ¹
    '186' => { },  # º
    '187' => { '65' => -2, '66' => -2, '67' => -1, '68' => -1, '74' => -1, '79' => -1, '84' => -4, '86' => -4, '87' => -2, '88' => -2, '89' => -5, '118' => -1, '119' => -1, '121' => -1, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -5, '253' => -1, '255' => -1, },  # »
    '188' => { },  # ¼
    '189' => { },  # ½
    '190' => { },  # ¾
    '191' => { },  # ¿
    '192' => { '45' => -1, '46' => -1, '58' => -1, '65' => 1, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -3, '86' => -3, '87' => -2, '89' => -3, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -3, '119' => -2, '121' => -3, '171' => -2, '193' => 1, '194' => 1, '195' => 1, '196' => 1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -3, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -3, '255' => -3, },  # À
    '193' => { '45' => -1, '46' => -1, '58' => -1, '65' => 1, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -3, '86' => -3, '87' => -2, '89' => -3, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -3, '119' => -2, '121' => -3, '171' => -2, '192' => 1, '194' => 1, '195' => 1, '196' => 1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -3, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -3, '255' => -3, },  # Á
    '194' => { '45' => -1, '46' => -1, '58' => -1, '65' => 1, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -3, '86' => -3, '87' => -2, '89' => -3, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -3, '119' => -2, '121' => -3, '171' => -2, '192' => 1, '193' => 1, '195' => 1, '196' => 1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -3, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -3, '255' => -3, },  # Â
    '195' => { '45' => -1, '46' => -1, '58' => -1, '65' => 1, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -3, '86' => -3, '87' => -2, '89' => -3, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -3, '119' => -2, '121' => -3, '171' => -2, '192' => 1, '193' => 1, '194' => 1, '196' => 1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -3, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -3, '255' => -3, },  # Ã
    '196' => { '45' => -1, '46' => -1, '58' => -1, '65' => 1, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -3, '86' => -3, '87' => -2, '89' => -3, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -3, '119' => -2, '121' => -3, '171' => -2, '192' => 1, '193' => 1, '194' => 1, '195' => 1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -3, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -3, '255' => -3, },  # Ä
    '197' => { },  # Å
    '198' => { },  # Æ
    '199' => { '89' => -1, '171' => -1, '187' => -1, '221' => -1, },  # Ç
    '200' => { },  # È
    '201' => { },  # É
    '202' => { },  # Ê
    '203' => { },  # Ë
    '204' => { },  # Ì
    '205' => { },  # Í
    '206' => { },  # Î
    '207' => { },  # Ï
    '208' => { },  # Ð
    '209' => { },  # Ñ
    '210' => { '45' => 1, '46' => -2, '58' => -1, '65' => -1, '86' => -1, '88' => -3, '89' => -2, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -2, },  # Ò
    '211' => { '45' => 1, '46' => -2, '58' => -1, '65' => -1, '86' => -1, '88' => -3, '89' => -2, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -2, },  # Ó
    '212' => { '45' => 1, '46' => -2, '58' => -1, '65' => -1, '86' => -1, '88' => -3, '89' => -2, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -2, },  # Ô
    '213' => { '45' => 1, '46' => -2, '58' => -1, '65' => -1, '86' => -1, '88' => -3, '89' => -2, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -2, },  # Õ
    '214' => { '45' => 1, '46' => -2, '58' => -1, '65' => -1, '86' => -1, '88' => -3, '89' => -2, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -2, },  # Ö
    '215' => { },  # ×
    '216' => { },  # Ø
    '217' => { '90' => -1, },  # Ù
    '218' => { '90' => -1, },  # Ú
    '219' => { '90' => -1, },  # Û
    '220' => { '90' => -1, },  # Ü
    '221' => { '45' => -5, '46' => -9, '58' => -6, '65' => -3, '67' => -2, '79' => -2, '97' => -6, '101' => -6, '105' => -2, '111' => -6, '117' => -5, '171' => -5, '187' => -3, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '199' => -2, '210' => -2, '211' => -2, '212' => -2, '213' => -2, '214' => -2, '224' => -6, '225' => -6, '226' => -6, '227' => -6, '228' => -6, '229' => -6, '232' => -6, '233' => -6, '234' => -6, '235' => -6, '242' => -6, '243' => -6, '244' => -6, '245' => -6, '246' => -6, '249' => -5, '250' => -5, '251' => -5, '252' => -5, },  # Ý
    '222' => { '46' => -3, '58' => -2, },  # Þ
    '223' => { '45' => 1, },  # ß
    '224' => { },  # à
    '225' => { },  # á
    '226' => { },  # â
    '227' => { },  # ã
    '228' => { },  # ä
    '229' => { },  # å
    '230' => { },  # æ
    '231' => { },  # ç
    '232' => { '120' => -1, },  # è
    '233' => { '120' => -1, },  # é
    '234' => { '120' => -1, },  # ê
    '235' => { '120' => -1, },  # ë
    '236' => { },  # ì
    '237' => { },  # í
    '238' => { },  # î
    '239' => { },  # ï
    '240' => { },  # ð
    '241' => { },  # ñ
    '242' => { '45' => 1, '46' => -1, '120' => -1, },  # ò
    '243' => { '45' => 1, '46' => -1, '120' => -1, },  # ó
    '244' => { '45' => 1, '46' => -1, '120' => -1, },  # ô
    '245' => { '45' => 1, '46' => -1, '120' => -1, },  # õ
    '246' => { '45' => 1, '46' => -1, '120' => -1, },  # ö
    '247' => { },  # ÷
    '248' => { },  # ø
    '249' => { },  # ù
    '250' => { },  # ú
    '251' => { },  # û
    '252' => { },  # ü
    '253' => { '45' => -1, '46' => -6, '58' => -3, '171' => -1, '187' => -1, },  # ý
    '254' => { },  # þ
    '255' => { '45' => -1, '46' => -6, '58' => -3, '171' => -1, '187' => -1, },  # ÿ
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
